

#include <windows.h>
#include <iostream>
#include <conio.h>
#include "..\DLL\de_la_exp1.h"

#include "..\DLL\llist_data.h"


//////////////////////////////////////////////////
// INFO
//
// Die hier vorhandenen Funktionen werden nicht mit 
// in die DLL kopiert. Diese dienten den ersten Tests
// mit den Interpretern. Hier sollte nicht weiter 
// gearbeitet werden, es sollten statt dessen direkt 
// Tests mit der LA-Software durchgefhrt werden
//
///////////////////////////////////////////////////


/////////////////////////////////////
//  Testfunktionen
/////////////////////////////////////

bool GenerateSpiBuffer(const LA_HWInfo HWInfo, SPIConfig SpiCfg, unsigned char *buf);
bool GenerateRsBuffer(const LA_HWInfo HWInfo, LA_Configuration LAConf, RS232Config RsCfg, 
							unsigned char *buf);

bool WriteRsData(const LA_HWInfo HWInfo, LA_Configuration LAConf, RS232Config RsCfg, 
							unsigned char *buf, ULONG SampleStart, unsigned char cData);
void ClearBuffer(const LA_HWInfo HWInfo, unsigned char *buf, bool bit);
bool WriteSpiData(const LA_HWInfo HWInfo, SPIConfig SpiCfg, unsigned char *buf, ULONG nSampleStart, unsigned char data);
void PrintBuffer(LA_HWInfo HWInfo, unsigned char *buf, ULONG nStart, ULONG nEnd, unsigned int nStep);


void PrintInterpreters()
{
//ULONG LA_EXP_GetInterpreterNames(ULONG todo, char * text, ULONG text_length)

	ULONG	nNumInterpreters = 0;
	ULONG	nLength = 100;
	ULONG	i;
	char	*str1 = NULL;
	char	*str2 = NULL;

	str1 = new char[nLength];

	//Die einzelnen Interpreter auflisten!

	nNumInterpreters = LA_EXP_GetInterpreterNames(0, str1, nLength);  //Sollte nLength

	std::cout << "\n\n|| Interpreter: " << nNumInterpreters << std::endl;

	for (i=1;i<=nNumInterpreters;i++)
	{
		LA_EXP_GetInterpreterNames(i, str1, nLength);
		std::cout << "\n    Interpreter Nr.: " << i << "; Name: " << str1;
	}

	std::cout << "\n\n\n";


	//Die Interpreter mit ihren Parametern anzeigen

	unsigned int nNumParameters=0;

	str2 = new char[nLength];

	for (i=1;i<=nNumInterpreters;i++)
	{
		nNumParameters = LA_EXP_GetConfigurationInfo(i,0,NULL,0,NULL,0);
		std::cout << "\nInterpreter Nr.: " << i << "  (" << nNumParameters << " Parameter)\n\n"; 

		for (int j=1;j<=nNumParameters;j++)
		{

			switch(LA_EXP_GetConfigurationInfo(i,j,str1,nLength,str2,nLength))
			{
				case 1:			//PARAM_CHANNEL
					{
						std::cout << "  [Kanal]\t\t" << str1 << "\n";
						break;
					}
				case 2:			//PARAM_SELECTION
					{
						std::cout << "  [Auswahl]\t\t" << str1 << "\n\t\t\t " << str2 << "\n";
						break;
					}
				case 3:			//PARAM_CHANNEL
					{
						std::cout << "  [Auswahl+Kanal]\t\t" << str1 << "\n\t\t\t " << str2 << "\n";
						break;
					}
				default:
					{
						std::cout << "  Parameter-Typ nicht bekannt!\n";
					}
			}

		}


		std::cout << "\n  " ;

	}

	
	delete [] str1;
	delete [] str2;
}

unsigned long potentiate(unsigned int nBase, unsigned int nExp)
{
	unsigned long n = nBase;
	for (unsigned int i=0;i<(nExp-1);i++)
		n *= nBase;
	return n;
}

void PrintData(unsigned char *data, unsigned int nNumData)
{
	unsigned long nStart, nLength;
	unsigned char cText, cType, cChan, cColor;

	int nPaketSize = 45;
	int nBitPos = 0;

	char str[50], strAnzeige[33];
	std::cout << "\n\nData \t\tText \tType \tColor \tKanal \tWert \tStart \tnLength\n";

	for (int i=0;i<nNumData;i++)
	{

		nBitPos = 0;

		cText	= data[(i*nPaketSize)+nBitPos++];
		cType	= data[(i*nPaketSize)+nBitPos++];
		cColor	= data[(i*nPaketSize)+nBitPos++];
		cChan	= data[(i*nPaketSize)+nBitPos++];

/*
		nValue =   data[(i*nPaketSize)+nBitPos++]
				 + data[(i*nPaketSize)+nBitPos++] * potentiate(2,8)
				 + data[(i*nPaketSize)+nBitPos++] * potentiate(2,16)
				 + data[(i*nPaketSize)+nBitPos++] * potentiate(2,24);
*/
		for (int j=0;j<33;j++)
			strAnzeige[j] = data[(i*nPaketSize)+nBitPos++];

		if (1)
		{
			char msg[100];
			sprintf(msg,"%s\n",str);
					OutputDebugString(msg);
		}

		nStart =   data[(i*nPaketSize)+nBitPos++];
		nStart +=  data[(i*nPaketSize)+nBitPos++] * potentiate(2,8);
		nStart += data[(i*nPaketSize)+nBitPos++] * potentiate(2,16);
		nStart += data[(i*nPaketSize)+nBitPos++] * potentiate(2,24);

		nLength  =  data[(i*nPaketSize)+nBitPos++];
		nLength += data[(i*nPaketSize)+nBitPos++] * potentiate(2,8);
		nLength += data[(i*nPaketSize)+nBitPos++] * potentiate(2,16);
		nLength += data[(i*nPaketSize)+nBitPos++] * potentiate(2,24);

		if (1)
		{
			char msg[100];
			sprintf(msg,"%d | %d\n",nStart,nLength);
					OutputDebugString(msg);
		}



		std::cout << "Nr. " << i << " : \t"
					<< itoa((int)(cText), str,10) << "\t" ;
		std::cout << itoa((int)(cType), str,10) << "\t";
		std::cout << itoa((int)(cColor), str,10) << "\t";
		std::cout << itoa((int)(cChan), str,10) << "\t"
				<< (char*)strAnzeige << "\t"
				<< nStart << "\t"
				<< nLength << "\t"
				<< "\n";

	}

	std::cout.flush();
}

int main()
{

	std::cout	<< "------------------------------\n"
				<< "| Test-Anwendung             |\n"
				<< "------------------------------\n";


	std::cout << " - Verwendete DLL-Version: " 
					<< (ULONG)LA_EXP_GetDLLVersion() << "\n";




	//Interpreter Informationen anzeigen!
		PrintInterpreters();


	//Interpreter setzen (Kanal, InterpreterNr, ParamNr)
		LA_EXP_setInterpreter(5, 1,7);	//Spi
		LA_EXP_setInterpreter(6, 2,6);	//RS232
		LA_EXP_setInterpreter(6, 1,7);	//Fehler!
		LA_EXP_setInterpreter(5, 2,6);	//Fehler!

		//SPI konfigurieren
			LA_EXP_setConfiguration(5, 1, 0, 1);	// K:1 P:1 [SPI]Type	= 0
			LA_EXP_setConfiguration(5, 2, 3, 0);	// K:1 P:2 [SPI]CLK		= 2
			LA_EXP_setConfiguration(5, 3, 4, 0);	// K:1 P:3 [SPI]DTA		= 3
			LA_EXP_setConfiguration(5, 4, 2, 0);	// K:1 P:4 [SPI]CS		= 1
			LA_EXP_setConfiguration(5, 5, 0, 1);	// K:1 P:5 [SPI]CS-Act.	= 0
			LA_EXP_setConfiguration(5, 6, 0, 1);	// K:1 P:6 [SPI]MODE	= 1
			LA_EXP_setConfiguration(5, 7, 0, 1);	// K:1 P:7 [SPI]Anz.Bits= 1

		//RS232 konfigurieren
			LA_EXP_setConfiguration(6, 1, 0, 1);	// K:2 P:1 [RS232]Type			= 0
			LA_EXP_setConfiguration(6, 2, 7, 0);	// K:2 P:2 [RS232]DTA			= 6
			LA_EXP_setConfiguration(6, 3, 0, 7);	// K:2 P:3 [RS232]Baud			= 7/9600
			LA_EXP_setConfiguration(6, 4, 0, 7);	// K:2 P:4 [RS232]Anz.Bits		= 7/8
			LA_EXP_setConfiguration(6, 5, 0, 2);	// K:2 P:5 [RS232]Paritts-Bit	= 2/ODD
			LA_EXP_setConfiguration(6, 6, 0, 3);	// K:2 P:6 [RS232]StopBits		= 3/2.0
		
	//Hardware-Daten
		DWORD tStart, tTime;
		LA_HWInfo HWInfo;
		LA_Configuration LAConf;
		unsigned char *data=NULL;
		ULONG nNumData=0;

		HWInfo.adress_mask = 0;
		HWInfo.bytes_per_sample = 5;
		HWInfo.channel_max = 36;
		HWInfo.samples_max = 128000;
		HWInfo.version = 1;

		LAConf.sample_clock	= 50000;	//Abtastrate 50kHz
		



	//Puffer generieren 

		unsigned char *la_buffer;
		ULONG nBufferSize;
		SPIConfig SpiCfg;
		RS232Config RsCfg;

		nBufferSize = HWInfo.bytes_per_sample * HWInfo.samples_max;

		la_buffer = (unsigned char*)malloc(nBufferSize);

		SpiCfg.nChannelCS	= 1;
		SpiCfg.nChannelClk	= 2;
		SpiCfg.nChannelData = 3;
		SpiCfg.nNumBits = 8;
		SpiCfg.nRisingEdge	= 0;

		RsCfg.nBaud			= 9600;
		RsCfg.nChannelData	= 6;
		RsCfg.nNumBits		= 8;
		RsCfg.fNumStopBits	= 1.0f;
		RsCfg.nParityBit	= PAR_ODD;

		std::cout << "\n\n\nGeneriere Test-Puffer... \n";
			GenerateSpiBuffer(HWInfo, SpiCfg,la_buffer);
			GenerateRsBuffer(HWInfo, LAConf, RsCfg, la_buffer);
		std::cout << "..Test-Puffer erstellt.\n";

		PrintBuffer(HWInfo, la_buffer, 0,185,1);


		int nPaketSize = 45;



	//Daten konvertieren

		tStart = GetTickCount();
		la_exp_interprete_data(HWInfo, LAConf, la_buffer, 0);
		


		nNumData = la_exp_get_data(0,0,NULL,0,0);
		data = (unsigned char*)malloc(sizeof(char)*nPaketSize*nNumData);
		la_exp_get_data(1,nNumData, data,0,0);




		tTime = GetTickCount() - tStart;

		OutputDebugString(" [APP] Daten konvertiert");
		std::cout << "\n\n\nDataConvert() ausgefuehrt, Dauer: " << tTime << "ms.";


	//Interpretierte Daten anzeigen
		PrintData(data, nNumData);

	_getch();

	return 0;
}



//////////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////
//
//	PUFFER-Generierung
//
//////////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////



////////////////////////////////////
//
///////////////////////////////////

void PrintBuffer(LA_HWInfo HWInfo, unsigned char *buf, ULONG nStart, ULONG nEnd, unsigned int nStep)
{

	if (nEnd > HWInfo.samples_max)
		return;

	std::cout << "\n\n------------------------------------\n";
	std::cout << " Sample-Ausschnitt:\n";
	std::cout << " Beginn :  " << nStart << "\n";
	std::cout << " Ende   :  " << nEnd << "\n";
	std::cout << " Channel:  " << HWInfo.channel_max << "\n";
	std::cout << "------------------------------------\n";



	for (ULONG t=nStart; t<nEnd;t+=nStep)
	{
		for (int i=0;i<HWInfo.channel_max;i++)
		{

			if ((i%8)==0 && i != 0)
				std::cout << ".";

			if (IsSet(HWInfo, buf,i, t))
				std::cout << "1";
			else
				std::cout << "0";


		}
		std::cout << "    \t t = " << t << "\n";
	}

	std::cout.flush();


}

//////////////////////////////////////////////////////////// 
// Zur Generierung eines Test-Buffers fr RS232
////////////////////////////////////////////////////////////


bool GenerateRsBuffer(const LA_HWInfo HWInfo, LA_Configuration LAConf, RS232Config RsCfg, 
							unsigned char *buf)
{
	if (buf == NULL)
		return false;

	//Datenleitung auf 1 setzen!

	for (ULONG i=0;i<HWInfo.samples_max;i++)
		SetBit(HWInfo, buf, RsCfg.nChannelData,i,true);


	WriteRsData(HWInfo, LAConf,RsCfg, buf, 5, 0);
	WriteRsData(HWInfo, LAConf,RsCfg, buf, 65, 255);
	WriteRsData(HWInfo, LAConf,RsCfg, buf, 125, 3);

	return true;
}

bool WriteRsData(const LA_HWInfo HWInfo, LA_Configuration LAConf, RS232Config RsCfg, 
							unsigned char *buf, ULONG SampleStart, unsigned char cData)

{
	if (buf == NULL)
		return false;

	int i;
	int nParCount;
	bool bSet;
	unsigned int nSamplesPerBit;

	nSamplesPerBit = (int)(LAConf.sample_clock / RsCfg.nBaud);

	ULONG nSamplePos = SampleStart;

	//Start-Bit
		for (i=0;i<nSamplesPerBit;i++)
		{
			SetBit(HWInfo, buf, RsCfg.nChannelData,nSamplePos,false);
			nSamplePos++;
		}

	//Datenbits:

		nParCount = 0;

		for (i=0;i<8;i++)
		{
			if (cData & (1 << (i)))
			{
				bSet = true;
				nParCount++;
			}
			else
				bSet = false;
			for (int k=0;k<nSamplesPerBit;k++)
			{
				SetBit(HWInfo, buf, RsCfg.nChannelData,nSamplePos,bSet);
				nSamplePos++;
			}
		}

	//Parity-Bit
		if (RsCfg.nParityBit != PAR_NONE)
		{
			bSet = false;
			switch(RsCfg.nParityBit)
			{
			case PAR_ODD:
				if (nParCount%2 == 0)
					bSet = true;
				break;
			case PAR_EVEN:
				if (nParCount%2 != 0)
					bSet = true;
				break;

			case PAR_MARK:
				bSet = true;
				break;

			case PAR_SPACE:
				bSet = false;
				break;
			default: 
				bSet = false;
			}

			for (i=0;i<nSamplesPerBit;i++)
			{
				SetBit(HWInfo, buf, RsCfg.nChannelData,nSamplePos,bSet);
				nSamplePos++;
			}

		}
	//Stop-Bits:
		int n;

		n = (int)((float)nSamplesPerBit * RsCfg.fNumStopBits);

		for (i=0;i<n;i++)
		{
			SetBit(HWInfo, buf, RsCfg.nChannelData,nSamplePos,true);
			nSamplePos++;
		}
	return true;
}

//////////////////////////////////////////////////////////// 
// Zur Generierung eines Test-Buffers fr SPI
////////////////////////////////////////////////////////////



bool GenerateSpiBuffer(const LA_HWInfo HWInfo, SPIConfig SpiCfg, unsigned char *buf)
{
	ULONG nSample;


	
	if (buf == NULL)
		return false;

	ClearBuffer(HWInfo, buf, 0);

	int nMode = 0;

	bool idle;

	if (nMode == 0 || nMode == 1)
		idle = false;
	else
		idle = true;

	//CLK auf Idle setzen
	for (nSample=0;nSample<HWInfo.samples_max;nSample++)
	{
		SetBit(HWInfo, buf, SpiCfg.nChannelClk, nSample, idle);
	}

	//SS auf deaktiviert (1) setzen
	for (nSample=0;nSample<HWInfo.samples_max;nSample++)
	{
		SetBit(HWInfo, buf, SpiCfg.nChannelCS, nSample, true);
	}

	
	WriteSpiData(HWInfo, SpiCfg, buf, 4,170); //10101010

	WriteSpiData(HWInfo, SpiCfg, buf, 80,0); //0

	WriteSpiData(HWInfo, SpiCfg, buf, 150,255); //11111111

	WriteSpiData(HWInfo, SpiCfg, buf, 150,123);

	
	return true;
}



//Info: 1 Byte dauert 8*8= 64 Abtastungen!

bool WriteSpiData(const LA_HWInfo HWInfo, SPIConfig SpiCfg, unsigned char *buf, ULONG nSampleStart, unsigned char data)
{
	int i;
	if (buf == NULL)
		return false;



	// 4 Samples / nderung!
	// 8 Bits
	// Pro Bit /2 nderungen (Bit Setzen& CLK lschen; CLK setzen)

	bool set;
	bool idle;

	int nMode = 1;

	if (nMode == 0 || nMode == 1)
		idle = false;
	else
		idle = true;





	for (int nBit=0; nBit<8;nBit++)
	{
		if (data & (1<<(7-nBit)))
			set = true;
		else
			set = false;



		// 4 Werte/nderung
		for (i=0;i<8;i++)
		{

			//Chip Select
			SetBit(HWInfo, buf, SpiCfg.nChannelCS, nSampleStart+i+(nBit*8),0);

			SetBit(HWInfo, buf, SpiCfg.nChannelData, nSampleStart+i+(nBit*8),set);
			SetBit(HWInfo, buf, SpiCfg.nChannelClk, nSampleStart+i+(nBit*8),idle);
		}
		for (i=2;i<6;i++)
			SetBit(HWInfo, buf, SpiCfg.nChannelClk, nSampleStart+i+(nBit*8),!idle);

	}

	return true;
}



void ClearBuffer(const LA_HWInfo HWInfo,unsigned char *buf, bool bit)
{

	for (ULONG nSample=0; nSample< HWInfo.samples_max;nSample++)
	{
		for (ULONG nChannel=0;nChannel < HWInfo.channel_max;nChannel++)
		{
			SetBit(HWInfo, buf,nChannel, nSample, false);
		}
	}
}

