///////////////////////////////////////
// structs.h
//
// Definitionen; Strukturen
//
//

#pragma once

#include <windows.h>



#define DLL_VERSION	40110

//Macro fr die DLL-Funktionen
#define dllExp	__declspec (dllexport)
#define exC extern "C"

// Debug Ausgabe?
#define DebugMode

#ifdef DebugMode
	#define PrintDebug(msg) OutputDebugString(msg);
#else
	#define PrintDebug(msg)	
#endif



//unbekannt; aus Ur._DLL bernommen
#define REV_USB_LOGI_600	1
#define REV_USB_LOGI_800	2
#define REV_USB_LOGI_1000	3


#define PAR_NONE	1
#define PAR_ODD		2
#define PAR_EVEN	3
#define PAR_MARK	4
#define PAR_SPACE	5

#define TYPE_DEZ	1
#define TYPE_HEX	2
#define TYPE_BIN	3
#define TYPE_ASC	4




///////////////////////////////////
// Parameter Darstellungen
///////////////////////////////////

#define PARAM_CHANNEL	1
#define PARAM_SELECTION	2
#define PARAM_CHANSEL	3
//#define PARAM_TEXT		4


///////////////////////////////////
// Strukturen
///////////////////////////////////

//weitere Strukturen in der LLists


	typedef struct XXLA_Configuartion
	{
		ULONG version;
	//	ULONG testmode;							// 0 = LA-Mode, 1,2,3... = testmode
		ULONG trigger_ignore;					// ignoriere Trigger (bei 1)
		ULONG sample_clock;						// Aufzeichnungstakt
		ULONG pretrigger;						// 1..7
		ULONG trigger_0[2][4];					// 2 Level, Max 128 channals
		ULONG trigger_1[2][4];					// 2 Level, Max 128 channals
		ULONG trigger_SF[2][4];					// 2 Level, Max 128 channals
		ULONG trigger_FF[2][4];					// 2 Level, Max 128 channals
		ULONG trigger_Helper0;					// 
		ULONG trigger_Helper1;					// 
		ULONG trigger_Selection;				// 
		ULONG trigger_StartTrigger;				// 
		ULONG trigger_Counter0;					// 16 Bit
		ULONG sample_intern_extern;				// 0 =interner Takt, 1 = externer Takt
	} LA_Configuration;





	typedef struct XXLA_HWInfo
	{
		ULONG version;
		ULONG channel_max;						// Nr of channels
		ULONG samples_max;						// Nr of samples
		ULONG bytes_per_sample;					// Nr of bytes/per Sample
		ULONG adress_mask;						// Maske fr Adress-Counter
	} LA_HWInfo;



///////////////////////////////////////////////////
// interne structs



struct RS232Config
{
	int nChannelData;
	int nBaud;
	int nNumBits;

	int nParityBit;

	unsigned char cType;

	float fNumStopBits;
};

struct SPIConfig
{
	int nChannelClk;
	int nChannelData;
	int nChannelCS;
	int nRisingEdge;	//wird als bool angesehen!

	int nCSActive;

	int nNumBits;

	unsigned char cType;
};

struct CANConfig
{
	int nChannelData;
	int nBaud;

	unsigned char cDetail;

	unsigned char cType;
};

struct IICConfig
{
	int nChannelData;
	int nChannelClk;

	unsigned char cType;
	unsigned char cDetail;
};