#include "llist_data.h"



struct LL_DataNode *LL_DataGetFirst(struct LL_DataNode *list)
{
	if (list == NULL)
		return NULL;

	while((*list).prev != NULL)
	{
		list = (*list).prev;
	}
	return list;
}

struct LL_DataNode *LL_DataGetLast(struct LL_DataNode *list)
{
	if (list == NULL)
		return NULL;

	while((*list).next != NULL)
	{
		list = (*list).next;
	}
	return list;
}

struct LL_DataNode *LL_DataGetNext(struct LL_DataNode *list)
{
	if (list == NULL)
		return NULL;
	if ((*list).next == NULL)
		return NULL;

	return (*list).next;
}

ULONG LL_DataGetNumElements(struct LL_DataNode *list)
{
	struct LL_DataNode *node;
	ULONG nNum = 0;
	if (list == NULL)
		return 0;

	list = LL_DataGetFirst(list);

	node = list;

	while(node != NULL)
	{
		nNum++;
		node = LL_DataGetNext(node);
	}


	return nNum;
}


struct LL_DataNode *LL_DataAdd(struct LL_DataNode *list, struct sData Data)
{
	struct LL_DataNode *Node;

	//neue Liste?
	if (list == NULL)
	{
		Node = (struct LL_DataNode*)malloc(sizeof(struct LL_DataNode));
		(*Node).prev = NULL;
	}
	else
	{
		list = LL_DataGetLast(list);
		(*list).next = (struct LL_DataNode*)malloc(sizeof(struct LL_DataNode));
		Node = (*list).next;
		(*Node).prev = list;
	}

	(*Node).next = NULL;

	(*Node).Data = Data;

	return Node;
}


struct LL_DataNode *LL_DataClearList(struct LL_DataNode *list)
{
	struct LL_DataNode *node;
	if (list == NULL)
		return NULL;

	
	list = LL_DataGetFirst(list);

	while (list != NULL)
	{
		node = list;
		list = LL_DataGetNext(node);
		free(node);
		
	}

	return NULL;
}