///////////////////////////////////
// Verkettete Liste
//  zum Speichern der Spezialkanle
///////////////////////////////////
#pragma once

#include <windows.h>

#include "structs.h"

struct ChannelInfo
{
	int bUseInterpreter;
	int nNumParamsSet;
		
	int nChannel;
	int nInterpreterNr;

	struct SPIConfig	SpiCfg;
	struct RS232Config	RsCfg;
	struct CANConfig	CanCfg;
	struct IICConfig	IicCfg;


};


struct LL_ChanInfoNode
{
	 struct ChannelInfo ChanInfo;
	 struct LL_ChanInfoNode *next;
	 struct LL_ChanInfoNode *prev;
};

struct LL_ChanInfoNode *LL_ChanInfoGetFirst(struct LL_ChanInfoNode *list);
struct LL_ChanInfoNode *LL_ChanInfoGetLast(struct LL_ChanInfoNode *list);


struct LL_ChanInfoNode *LL_ChanInfoGetNext(struct LL_ChanInfoNode *list);
struct LL_ChanInfoNode *LL_ChanInfoGet(struct LL_ChanInfoNode *list, int nChannel);

struct LL_ChanInfoNode *LL_ChanInfoAdd(struct LL_ChanInfoNode *list, struct ChannelInfo ChanInfo);

struct LL_ChanInfoNode *LL_ChanInfoClearList(struct LL_ChanInfoNode *list);

ULONG LL_ChanInfoGetNumElements(struct LL_ChanInfoNode *list);
