#include "llist_ChanInfo.h"


struct LL_ChanInfoNode *LL_ChanInfoGetFirst(struct LL_ChanInfoNode *list)
{
	if (list == NULL)
		return NULL;

	while((*list).prev != NULL)
	{
		list = (*list).prev;
		if (list == NULL)
			return NULL;
	}
	return list;
}

struct LL_ChanInfoNode *LL_ChanInfoGetLast(struct LL_ChanInfoNode *list)
{
	if (list == NULL)
		return NULL;

	while((*list).next != NULL)
	{
		list = (*list).next;
	}
	return list;
}

struct LL_ChanInfoNode *LL_ChanInfoGetNext(struct LL_ChanInfoNode *list)
{
	if (list == NULL)
		return NULL;
	if ((*list).next == NULL)
		return NULL;

	return (*list).next;
}

struct LL_ChanInfoNode *LL_ChanInfoGet(struct LL_ChanInfoNode *list, int nChannel)
{
	struct LL_ChanInfoNode *node;

	if (list == NULL)
		return NULL;

	node = list;
	node = LL_ChanInfoGetFirst(node);

	while(node != NULL)
	{
		if ((*node).ChanInfo.nChannel == nChannel)
			return node;
		node = LL_ChanInfoGetNext(node);
	}

	return NULL;
}

ULONG LL_ChanInfoGetNumElements(struct LL_ChanInfoNode *list)
{
	struct LL_ChanInfoNode *node;
	ULONG nNum = 0;
	if (list == NULL)
		return 0;

	list = LL_ChanInfoGetFirst(list);

	node = list;

	while(node != NULL)
	{
		nNum++;
		node = LL_ChanInfoGetNext(node);
	}


	return nNum;
}


struct LL_ChanInfoNode *LL_ChanInfoAdd(struct LL_ChanInfoNode *list, struct ChannelInfo ChanInfo)
{
	struct LL_ChanInfoNode *Node;

	//neue Liste?
	if (list == NULL)
	{
		Node = (struct LL_ChanInfoNode*)malloc(sizeof(struct LL_ChanInfoNode));
		(*Node).prev = NULL;
	}
	else
	{
		list = LL_ChanInfoGetLast(list);
		(*list).next = (struct LL_ChanInfoNode*)malloc(sizeof(struct LL_ChanInfoNode));
		Node = (*list).next;
		(*Node).prev = list;
	}

	(*Node).next = NULL;

	(*Node).ChanInfo = ChanInfo;

	return Node;
}


struct LL_ChanInfoNode *LL_ChanInfoClearList(struct LL_ChanInfoNode *list)
{
	struct LL_ChanInfoNode *node;
	if (list == NULL)
		return NULL;

	
	list = LL_ChanInfoGetFirst(list);

	while (list != NULL)
	{
		node = list;
		list = LL_ChanInfoGetNext(node);
		free(node);
		
	}

	return NULL;
}