#include "de_la_exp1.h"

//Konvertierungsfunktionen
#include "convertSPI.h"
#include "convertRS232.h"
#include "convertCAN2.h"




/////////////////////////////////////////
//TODO:
//	- Parameter Funktion bearbeiten!!!



	bool APIENTRY DllMain( HANDLE hModule, 
						   DWORD  ul_reason_for_call, 
						   LPVOID lpReserved)
	{
		return TRUE;
	}


	dllExp ULONG LA_EXP_GetDLLVersion()
	{
		return DLL_VERSION;
	}


/////////////////////////////////////////
// Get Interpreter Names
//
// Liefert die Anzahl der einzelnen Interpreter
// sowie deren Namen zurck
/////////////////////////////////////////

	exC dllExp ULONG LA_EXP_GetInterpreterNames(ULONG todo, char * text, ULONG text_length)
	{
		//Anzahl der Interpreter: 3
		//	1: SPI
		//	2: RS232
		//	3: CAN 2.0

		int ret=0;


		switch(todo)
		{
		case 0:	//Anzahl der Interpreter
			{
				ret = 3;
				break;
			}
		// Namen der Interpreter angeben
		case 1:
			{
				strncpy(text,"SPI\0",text_length);
				break;
			}
		case 2:
			{
				strncpy(text,"RS232\0",text_length);
				break;
			}
		case 3:
			{
				strncpy(text,"CAN 2.0\0", text_length);
				break;
			}
		}

		//Debug-Ausgaben
		#ifdef DebugMode
			char *msg;
			msg = (char*)malloc(sizeof(char)*(text_length+100));
			sprintf(msg, " [DLL] GetInterpreterNames(ToDo = %d, TextLength = %d): return %d\n", todo, text_length, ret);	
			PrintDebug(msg);
			if (text != NULL)
				if (strlen(text) <= text_length)
				{
					sprintf(msg, " [DLL]        - Text: %s\n",text);	
					PrintDebug(msg);
				}
			free(msg);
		#endif

		return ret;
	}


/////////////////////////////////////////
// SetInterpreter
//
// "aktiviert" die Spezialkanle und weit
// ihnen einen Interpreter zu
/////////////////////////////////////////
	
	dllExp ULONG LA_EXP_setInterpreter(ULONG channelNo, ULONG nInterpreter, ULONG parCount)
	{

		char *msg;
		msg = (char*)malloc(sizeof(char)*(400));

		switch(nInterpreter)
		{
		case 1:
			{
				if (LL_ChanInfoGet(ChanList, channelNo) == NULL)
				{
					//Neuen Interpreter hinzufgen:
					ChannelInfo ChanInfo;
					
					ChanInfo.bUseInterpreter = false;
					ChanInfo.nNumParamsSet	 = 0;
					ChanInfo.nChannel		 = channelNo;
					ChanInfo.nInterpreterNr  = nInterpreter;

					ChanList = LL_ChanInfoAdd(ChanList, ChanInfo);

					#ifdef DebugMode
						sprintf(msg, " [DLL] SetInterpreter(): Erkannter Interpreter: SPI (Kanal %d   Interpreter: %d Anz.Param.: %d)\n", 
											channelNo, nInterpreter, parCount);	
						PrintDebug(msg);
					#endif

				}
				else
				{
					#ifdef DebugMode
						sprintf(msg, " [DLL] SetInterpreter(): Fehler: Kanal %d bereits belegt!\n",
												channelNo);	
						PrintDebug(msg);
					#endif
				}



				break;
			}
		case 2: //RS232
			{
				if (LL_ChanInfoGet(ChanList, channelNo) == NULL)
				{

					ChannelInfo ChanInfo;
					
					ChanInfo.bUseInterpreter = false;
					ChanInfo.nNumParamsSet	 = 0;
					ChanInfo.nChannel		 = channelNo;
					ChanInfo.nInterpreterNr  = nInterpreter;

					ChanList = LL_ChanInfoAdd(ChanList, ChanInfo);					

					#ifdef DebugMode
						sprintf(msg, " [DLL] SetInterpreter(): Erkannter Interpreter: CAN 2.0 (Kanal %d   Interpreter: %d  Anz.Param.: %d)\n",
												channelNo, nInterpreter, parCount);	
						PrintDebug(msg);
					#endif
				}
				else
				{
					#ifdef DebugMode
						sprintf(msg, " [DLL] SetInterpreter(): Fehler: Kanal %d bereits belegt!\n",
												channelNo);	
						PrintDebug(msg);
					#endif
				}


				break;
			}
		case 3:	//CAN 2.0
			{
				if (LL_ChanInfoGet(ChanList, channelNo) == NULL)
				{
		

					ChannelInfo ChanInfo;
					
					ChanInfo.bUseInterpreter = false;
					ChanInfo.nNumParamsSet	 = 0;
					ChanInfo.nChannel		 = channelNo;
					ChanInfo.nInterpreterNr  = nInterpreter;

					ChanList = LL_ChanInfoAdd(ChanList, ChanInfo);					

					#ifdef DebugMode
						sprintf(msg, " [DLL] SetInterpreter(): Erkannter Interpreter: CAN 2.0 (Kanal %d   Interpreter: %d  Anz.Param.: %d)\n",
												channelNo, nInterpreter, parCount);	
						PrintDebug(msg);
					#endif
				}
				else
				{
					#ifdef DebugMode
						sprintf(msg, " [DLL] SetInterpreter(): Fehler: Kanal %d bereits belegt!\n",
												channelNo);	
						PrintDebug(msg);
					#endif
				}
				break;
			}

		default:
			{
				#ifdef DebugMode
					sprintf(msg, " [DLL] SetInterpreter(): Unbekannter Interpreter (Kanal %d   Interpreter: %d  Anz.Param.: %d\n",
											channelNo, nInterpreter, parCount);	
					PrintDebug(msg);
				#endif
				break;
			}
		}
		return 0;
	}
	
		// Logi+ liefert den ausgewhlten Interpreter fr channelNo
		// *text = Namen des Interpreters 
		// *text_length = Lnge des Interpreternamen (maximal 100 Zeichen)
		//*parCount =  Anzahl der Parameter fr diesen Interpreter

//Neuen Messung!

	exC dllExp	void LA_EXP_startNew()
	{
		#ifdef DebugMode
			char *msg = (char*)malloc(sizeof(char)*50);
			sprintf(msg, " [DLL] startNew()\n");	
			PrintDebug(msg);
			free(msg);
		#endif
		ChanList = LL_ChanInfoClearList(ChanList);
	}



/////////////////////////////////////////
// Get Configuration Info
//
// bestimmt die Anzahl der Paramater/Interpreter
// und definiert diese
/////////////////////////////////////////

	exC dllExp ULONG LA_EXP_GetConfigurationInfo(ULONG InterpreterNr, ULONG todo, char * name, 
											 ULONG name_length, char * auswahl, ULONG auswahl_length)
	{

				#ifdef DebugMode
			char *msg;
			msg = (char*)malloc(sizeof(char)*(100));
			sprintf(msg, " [DLL] GetConfiguration (Interpreter-Nr: %d; todo: %d", InterpreterNr, todo);	
			PrintDebug(msg);
			free(msg);
		#endif

		int nRet;

		nRet = 0;

		switch(InterpreterNr)
		{
		
		// SPI
		case 1:
			{
				switch(todo)
				{	
					//Anz. d. Parameter
					case 0: 
						{
							return 7;
							break;
						}
					// Zahlensystem
					case 1:
						{
							nRet = PARAM_SELECTION;
							strncpy(name, "Darstellung\0", name_length);
							strncpy(auswahl, "Dezimal;Hexadezimal;Binr;ASCII\0", auswahl_length);

							break;
						}
					// Clock-Signal
					case 2: 
						{
							nRet = PARAM_CHANNEL; 
							strncpy(name, "Clock\0", name_length); 

							break;
						}

					//Datenleitung MISO/MOSI
					case 3: 
						{
							nRet = PARAM_CHANNEL; 
							strncpy(name, "MISO/MOSI\0", name_length);

							break;
						}
					//CS
					case 4:
						{
							nRet = PARAM_CHANNEL; 
							strncpy(name, "Chip Select\0", name_length);
							break;
						}
					//CS low-active?
					case 5:
						{
							nRet = PARAM_SELECTION; 
							strncpy(name, "Chip-Select\0", name_length);


							strncpy(auswahl, "low-active;high-active\0",auswahl_length);
							break;
						}
					//Datenbernahme
					case 6: 
						{
							nRet = PARAM_SELECTION; 
							strncpy(name, "Datenbernahme\0", name_length);


							strncpy(auswahl, 
								 "bei steigender Flanke;bei fallender Flanke",auswahl_length);
							break;
						}
					//Bit Anzahl
					case 7: 
						{
							nRet = PARAM_SELECTION; 
							strncpy(name, "Daten-Bits\0", name_length);


							strncpy(auswahl, "8;16;24;32\0",auswahl_length);
							break;
						}


				}		
				break;
			}

		//RS232
		case 2:
			{
				switch(todo)
				{
				//Anzahl der Parameter
				case 0:
					{
						return 6;
						break;
					}
				// Zahlensystem
				case 1:
					{
						nRet = PARAM_SELECTION;
						strncpy(name, "Darstellung\0", name_length);
						strncpy(auswahl, "Dezimal;Hexadezimal;Binr;ASCII\0", auswahl_length);

						break;
					}
				//Datenleitung RxD/TxD
				case 2:
					{
							nRet = PARAM_CHANNEL; 
							strncpy(name, "RxD/TxD\0", name_length);
							
							break;
					}
				//Baudrate
				case 3:
					{
//							nRet = PARAM_TEXT; 
							nRet = PARAM_SELECTION;

							strncpy(name, "Baudrate\0", name_length); 
							//strncpy(auswahl, "50;300;600;1200;2400;4800;9600;14400;19200;28800;38400;56000;57600;115200;128000;230400;256000;460800;500000",auswahl_length);
							strncpy(auswahl, "50;300;600;1200;2400;4800;9600;14400;19200;28800;38400;56k;57600;115200;128k;230k4;256k;460k8;500k",auswahl_length);
							break;						
					}

				//Bit Anzahl
				case 4:
					{
							nRet = PARAM_SELECTION; 

							strncpy(name, "Bit-Anzahl\0", name_length); 
							strncpy(auswahl, "2;3;4;5;6;7;8;9;10;11;12;13;14;15;16;17;18;19;20;21;22;23;24\0",auswahl_length);

							break;	
					}

				//Paritts-Bit
				case 5:
					{
							nRet = PARAM_SELECTION; 

							strncpy(name, "Paritts-Bit\0", name_length); 
							strncpy(auswahl, "None;Odd;Even;Mark;Space\0",auswahl_length);

							break;					
					}

				//Anz der Stop-Bits
				case 6:
					{
							nRet = PARAM_SELECTION; 

							strncpy(name, "Stop-Bits\0", name_length); 
							strncpy(auswahl, "1 ;1,5 ;2\0",auswahl_length);

							break;
					}

				}

				break;

			}
		//CAN 2.0
		case 3:
			{
				switch(todo)
				{
				//Anzahl der Parameter
				case 0:
					return 4;
					break;

				case 1:
					{
						nRet = PARAM_SELECTION;
						strncpy(name, "Darstellung\0", name_length);
						strncpy(auswahl, "Dezimal;Hexadezimal;Binr;ASCII\0", auswahl_length);
						break;
					}
				//Datenleitung
				case 2:
					{
						nRet = PARAM_CHANNEL;
						strncpy(name, "Data\0", name_length);
						break;
					}
				//Baudrate
				case 3:
					{
							nRet = PARAM_SELECTION;

							strncpy(name, "Baudrate\0", name_length); 
							strncpy(auswahl, "125kBit;250kBit;500kBit;750kBit;1MBit;1,5MBit;2MBit",auswahl_length);
							break;						
					}
				//Detailgrad
				case 4:
					{
						nRet = PARAM_SELECTION;

						strncpy(name, "Detailgrad\0", name_length);
						strncpy(auswahl, "Identifer+Daten; Identifer+Daten+Checksum", auswahl_length);
						break;
					}
	
				}
				break;
			}			



		}


		return nRet;
	}




/////////////////////////////////////////
// SetConfiguration
//
// Fllt die Interpreter-Konfigurationen 
// der Benutzereingaben
/////////////////////////////////////////

	dllExp ULONG LA_EXP_setConfiguration(ULONG channelNo, ULONG parNo, ULONG nChannel, ULONG nSelection)
	{
		char *msg;
		msg = (char*)malloc(sizeof(char)*(400));


		if (LL_ChanInfoGet(ChanList, channelNo) == NULL)
		{
			#ifdef DebugMode
				sprintf(msg, " [DLL] SetConfig(): ChanNr: %d nicht gefunden!\n", channelNo);	
				PrintDebug(msg);
			#endif
			free(msg);
			return 1;
		}
		ChanList = LL_ChanInfoGet(ChanList, channelNo);

		//Was ist der Parameter-Typ?

		switch(ChanList->ChanInfo.nInterpreterNr)
		{
		case 1:			// SPI
			{

				//alle Parameter mssen nach der Reihe durchgereicht werden!
				if (parNo != (ULONG)(ChanList->ChanInfo.nNumParamsSet+1))
				{
					#ifdef DebugMode
						sprintf(msg, " [DLL] SetConfig(): ChanNr: %d, parNr: %d, [SPI] VORSICHT: Parameter bitte nacheinander angeben,.\n", 
														channelNo, parNo);	
						PrintDebug(msg);
					#endif
				}

				switch(parNo)		// 7 Parameter (Type, Clk, Data, CS, CS-Active high/low, Mode, Bit-Anz)
				{
				case 1:	//Type			- Auswahl
					{
						#ifdef DebugMode
							sprintf(msg, " [DLL] SetConfig(ChanNr: %d, parNr: %d, Kanal: %d, Auswahl: %d) : [SPI] Type: %d.\n", 
															channelNo, parNo, nChannel, nSelection, nSelection);	
							PrintDebug(msg);
						#endif

						ChanList->ChanInfo.SpiCfg.cType = (unsigned char)nSelection;
						ChanList->ChanInfo.nNumParamsSet++;

						break;
					}
				case 2:	//Clk			- Kanalauswahl
					{
						#ifdef DebugMode
							sprintf(msg, " [DLL] SetConfig(ChanNr: %d, parNr: %d, Kanal: %d, Auswahl: %d) : [SPI] Clock-Kanal: %d.\n", 
															channelNo, parNo, nChannel, nSelection, nChannel);	
							PrintDebug(msg);
						#endif

						ChanList->ChanInfo.SpiCfg.nChannelClk = nChannel-1;
						ChanList->ChanInfo.nNumParamsSet++;

						break;
					}
				case 3:	//Datenleitung	- Kanalauswahl
					{
						#ifdef DebugMode
							sprintf(msg, " [DLL] SetConfig(ChanNr: %d, parNr: %d, Kanal: %d, Auswahl: %d) : [SPI] DATA-Kanal: %d.\n", 
															channelNo, parNo, nChannel, nSelection, nChannel);	
							PrintDebug(msg);
						#endif

						ChanList->ChanInfo.SpiCfg.nChannelData = nChannel-1;
						ChanList->ChanInfo.nNumParamsSet++;

						break;
					}
				case 4:	//CS			- Kanalauswahl
					{
						#ifdef DebugMode
							sprintf(msg, " [DLL] SetConfig(ChanNr: %d, parNr: %d, Kanal: %d, Auswahl: %d) : [SPI] CS-Kanal: %d.\n", 
															channelNo, parNo, nChannel, nSelection, nChannel);	
							PrintDebug(msg);
						#endif

						ChanList->ChanInfo.SpiCfg.nChannelCS = nChannel-1;
						ChanList->ChanInfo.nNumParamsSet++;

						break;
					}
				case 5:	//CS Active low/high- Kanalauswahl
					{
						#ifdef DebugMode
							sprintf(msg, " [DLL] SetConfig(ChanNr: %d, parNr: %d, Kanal: %d, Auswahl: %d) : [SPI] CS-Active-Indx: %d.\n", 
															channelNo, parNo, nChannel, nSelection, nSelection);	
							PrintDebug(msg);
						#endif

						ChanList->ChanInfo.SpiCfg.nCSActive = nSelection-1;
						ChanList->ChanInfo.nNumParamsSet++;

						break;
					}
				case 6:	//Datenbernahme			- Auswahl (steigende Flanke/fallende Flanke)
					{
						#ifdef DebugMode
							sprintf(msg, " [DLL] SetConfig(ChanNr: %d, parNr: %d, Kanal: %d, Auswahl: %d) : [SPI] Datenbernahme-Index: %d.\n", 
															channelNo, parNo, nChannel, nSelection, nSelection);	
							PrintDebug(msg);
						#endif

						if (nSelection > 2 || nSelection < 1)
						{
							#ifdef DebugMode
								sprintf(msg, "          Fehler: Datenbername ist nicht zulssig!\n");	
								PrintDebug(msg);
							#endif
						}

						if (nSelection == 1)
							ChanList->ChanInfo.SpiCfg.nRisingEdge = 1;
						else
							ChanList->ChanInfo.SpiCfg.nRisingEdge = 0;

						ChanList->ChanInfo.nNumParamsSet++;

						break;
					}
				case 7:	//Bit-Anzahl	- Auswahl (8,16,24,32)
					{
						#ifdef DebugMode
							sprintf(msg, " [DLL] SetConfig(ChanNr: %d, parNr: %d, Kanal: %d, Auswahl: %d) : [SPI] Bit-Index: %d.\n", 
															channelNo, parNo, nChannel, nSelection, nSelection);	
							PrintDebug(msg);
						#endif

						ChanList->ChanInfo.SpiCfg.nNumBits = nSelection *8;
						ChanList->ChanInfo.nNumParamsSet++;
						ChanList->ChanInfo.bUseInterpreter = true;

						#ifdef DebugMode
							sprintf(msg, " [DLL] SetConfig() : [SPI] Kanal(%d) : Konfiguration abgeschlossen\n", 
															channelNo);	
							PrintDebug(msg);
						#endif
						break;
					}

				}
				break;
			}

		case 2:	//RS232
			{

				//alle Parameter mssen nach der Reihe durchgereicht werden!
				if (parNo != (ULONG)(ChanList->ChanInfo.nNumParamsSet+1))
				{
					#ifdef DebugMode
						sprintf(msg, " [DLL] SetConfig(): ChanNr: %d, parNr: %d, [RS232] VORSICHT: Parameter bitte nacheinander angeben,.\n", 
														channelNo, parNo);	
						PrintDebug(msg);
					#endif
				}


				switch(parNo)	// 6 Parameter (Type, Data, Baud, Bit-Anzahl, Paritts-bits, Stop-Bits)
				{
				case 1:	//Type			- Auswahl
					{
						#ifdef DebugMode
							sprintf(msg, " [DLL] SetConfig(ChanNr: %d, parNr: %d, Kanal: %d, Auswahl: %d) : [RS232] Type: %d.\n", 
															channelNo, parNo, nChannel, nSelection, nSelection);	
							PrintDebug(msg);
						#endif

						ChanList->ChanInfo.RsCfg.cType = (unsigned char)nSelection;
						ChanList->ChanInfo.nNumParamsSet++;

						break;
					}
				case 2:	//Datenleitung			- Kanalauswahl
					{
						#ifdef DebugMode
							sprintf(msg, " [DLL] SetConfig(ChanNr: %d, parNr: %d, Kanal: %d, Auswahl: %d) : [RS232] Daten-Kanal: %d.\n", 
															channelNo, parNo, nChannel, nSelection, nChannel);	
							PrintDebug(msg);
						#endif

						ChanList->ChanInfo.RsCfg.nChannelData = nChannel-1;
						ChanList->ChanInfo.nNumParamsSet++;

						break;
					}

				case 3:	//Baud			- Auswahl 
					{
						#ifdef DebugMode
							sprintf(msg, " [DLL] SetConfig(ChanNr: %d, parNr: %d, Kanal: %d, Auswahl: %d) : [RS232] Baud-Index: %d.\n", 
															channelNo, parNo, nChannel, nSelection, nSelection);	
							PrintDebug(msg);
						#endif

						int nBaud = 0;

						switch(nSelection)
						{
						case 1: nBaud = 50;			break;
						case 2: nBaud = 300;		break;
						case 3: nBaud = 600;		break;
						case 4: nBaud = 1200;		break;
						case 5: nBaud = 2400;		break;
						case 6: nBaud = 4800;		break;
						case 7: nBaud = 9600;		break;
						case 8: nBaud = 14400;		break;
						case 9: nBaud = 19200;		break;
						case 10: nBaud = 28800;		break;
						case 11: nBaud = 38400;		break;
						case 12: nBaud = 56000;		break;
						case 13: nBaud = 57600;		break;
						case 14: nBaud = 115200;	break;
						case 15: nBaud = 128000;	break;
						case 16: nBaud = 230400;	break;
						case 17: nBaud = 256000;	break;
						case 18: nBaud = 460800;	break;
						case 19: nBaud = 500000;	break;
						default: nBaud = 0;			break;
						}



						ChanList->ChanInfo.RsCfg.nBaud = nBaud;
						ChanList->ChanInfo.nNumParamsSet++;

						break;
					}

				case 4: //Bits			- Auswahl (2;3;4;5;6;7;8;9;10;11;12;13;14;15;16;17;18;19;20;21;22;23;24)
					{
						#ifdef DebugMode
							sprintf(msg, " [DLL] SetConfig(ChanNr: %d, parNr: %d, Kanal: %d, Auswahl: %d) : [RS232] Bit-Index: %d.\n", 
															channelNo, parNo, nChannel, nSelection, nSelection);	
							PrintDebug(msg);
						#endif

						if (nSelection > 23)
							ChanList->ChanInfo.RsCfg.nNumBits = 0;
						else
							ChanList->ChanInfo.RsCfg.nNumBits = nSelection + 1;

						ChanList->ChanInfo.nNumParamsSet++;

						break;
					}

				case 5: //Paritts-Bit	- Auswahl (None;Odd;Even;Mark;Space)
					{
						#ifdef DebugMode
							sprintf(msg, " [DLL] SetConfig(ChanNr: %d, parNr: %d, Kanal: %d, Auswahl: %d) : [RS232] P.Bit-Index: %d.\n", 
															channelNo, parNo, nChannel, nSelection, nSelection);	
							PrintDebug(msg);
						#endif

						if (nSelection > 5)
							ChanList->ChanInfo.RsCfg.nParityBit = PAR_NONE;
						else
							ChanList->ChanInfo.RsCfg.nParityBit = nSelection;

						ChanList->ChanInfo.nNumParamsSet++;

						break;
					}

				case 6: //Stop-Bits		- Auswahl (1;1.5;2)
					{
						#ifdef DebugMode
							sprintf(msg, " [DLL] SetConfig(ChanNr: %d, parNr: %d, Kanal: %d, Auswahl: %d) : [RS232] S.Bit-Index: %d.\n", 
															channelNo, parNo, nChannel, nSelection, nSelection);	
							PrintDebug(msg);
						#endif

						switch(nSelection)
						{
							case 1:	ChanList->ChanInfo.RsCfg.fNumStopBits = 1.0f; break;
							case 2:	ChanList->ChanInfo.RsCfg.fNumStopBits = 1.5f; break;
							case 3:	ChanList->ChanInfo.RsCfg.fNumStopBits = 2.0f; break;

							default:	ChanList->ChanInfo.RsCfg.fNumStopBits = 1.0f; break;
						}

						ChanList->ChanInfo.nNumParamsSet++;
						ChanList->ChanInfo.bUseInterpreter = true;

						#ifdef DebugMode
							sprintf(msg, " [DLL] SetConfig() : [RS232] Kanal(%d) : Konfiguration abgeschlossen\n", 
															channelNo);		
							PrintDebug(msg);
						#endif

						break;
					}

				}

				break;
			}
		//CAN 2.0
		case 3:
			{

				//alle Parameter mssen nach der Reihe durchgereicht werden!
				if (parNo != (ULONG)(ChanList->ChanInfo.nNumParamsSet+1))
				{
					#ifdef DebugMode
						sprintf(msg, " [DLL] SetConfig(): ChanNr: %d, parNr: %d, [CAN 2.0] VORSICHT: Parameter bitte nacheinander angeben,.\n", 
														channelNo, parNo);	
						PrintDebug(msg);
					#endif
				}


				switch(parNo)	// 4 Parameter (Type, Channel, Baud, Detail)
				{
				case 1:	//Type			- Auswahl
					{
						#ifdef DebugMode
							sprintf(msg, " [DLL] SetConfig(ChanNr: %d, parNr: %d, Kanal: %d, Auswahl: %d) : [CAN 2.0] Type: %d.\n", 
															channelNo, parNo, nChannel, nSelection, nSelection);	
							PrintDebug(msg);
						#endif

						ChanList->ChanInfo.CanCfg.cType = (unsigned char)nSelection;
						ChanList->ChanInfo.nNumParamsSet++;

						break;
					}

				case 2: //Data
					{
						#ifdef DebugMode
							sprintf(msg, " [DLL] SetConfig(ChanNr: %d, parNr: %d, Kanal: %d, Auswahl: %d) : [CAN 2.0] Datenkanal: %d.\n", 
															channelNo, parNo, nChannel, nSelection, nSelection);	
							PrintDebug(msg);
						#endif

						ChanList->ChanInfo.CanCfg.nChannelData = (unsigned char)nChannel-1;
						ChanList->ChanInfo.nNumParamsSet++;

						break;
					}

				case 3:	//Baud			- Auswahl
					{
						#ifdef DebugMode
							sprintf(msg, " [DLL] SetConfig(ChanNr: %d, parNr: %d, Kanal: %d, Auswahl: %d) : [CAN 2.0] Baud-Index: %d.\n", 
															channelNo, parNo, nChannel, nSelection, nSelection);	
							PrintDebug(msg);
						#endif

						int nBaud = 0;

						switch(nSelection)
						{
						case 1: nBaud = 125000;		break;
						case 2: nBaud = 250000;		break;
						case 3: nBaud = 500000;		break;
						case 4: nBaud = 750000;		break;
						case 5: nBaud = 1000000;	break;
						case 6: nBaud = 1500000;	break;
						case 7: nBaud = 2000000;	break;
						default: nBaud = 0;			break;
						}


						ChanList->ChanInfo.CanCfg.nBaud = nBaud;
						ChanList->ChanInfo.nNumParamsSet++;

						break;
					}
				case 4:
					{
						#ifdef DebugMode
							sprintf(msg, " [DLL] SetConfig(ChanNr: %d, parNr: %d, Kanal: %d, Auswahl: %d) : [CAN 2.0] Detail: %d.\n", 
															channelNo, parNo, nChannel, nSelection, nSelection);	
							PrintDebug(msg);
						#endif

						ChanList->ChanInfo.CanCfg.cDetail = (unsigned char)nSelection;
						ChanList->ChanInfo.nNumParamsSet++;
						ChanList->ChanInfo.bUseInterpreter = true;

						break;
					}
				}

			}
	


		}

		free(msg);
		return 0;
	}


//////////////////
// Interpretieren
//////////////////

/*

	Diese Funktion muss beim starten der Messung, nachdem die 
	Spezialkanle mit Ihrem einstellungen bergeben werden, 
	aufgerufen werden.
 */

dllExp ULONG la_exp_interprete_data(LA_HWInfo HWInfo, LA_Configuration LAConf, 
									unsigned char *la_buffer, unsigned int todo)
{

	char *msg;
	int i;

	msg = (char*)malloc(sizeof(char)*1000);


	#ifdef DebugMode
		sprintf(msg, " [DLL] interprete_data(); todo = %d\n", todo);	
		PrintDebug(msg);
	#endif


	DWORD dStart = GetTickCount();

	if (todo == 0)
	{

		if (la_buffer == NULL)
		{
			#ifdef DebugMode
				sprintf(msg, " [DLL] interprete_data(); Fehler: la_buffer = NULL\n");	
				PrintDebug(msg);
			#endif
			free(msg);
			return 1;
		}

		if (DataList != NULL)
			DataList = LL_DataClearList(DataList);


		DataList = NULL;

		//interpretieren
		//alle Spezial-Kanle Durchlaufen
		
		int nNumChan =0;

		//Keine Daten zu interpretieren!
		if (ChanList == NULL)
		{
			#ifdef DebugMode
				sprintf(msg, " [DLL] interprete_data(); Keine Spezialkanle gewhlt.\n");	
				PrintDebug(msg);
			#endif
			free(msg);
			return 1;
		}

		nNumChan = LL_ChanInfoGetNumElements(ChanList);

			#ifdef DebugMode
				sprintf(msg, " [DLL] interprete_data(); Anzahl d. Spezialkanle: %d\n", nNumChan);	
				PrintDebug(msg);
			#endif

		ChanList = LL_ChanInfoGetFirst(ChanList);



		for (i=0;i<nNumChan;i++)
		{

			if (ChanList != NULL)
			{
				
				if (ChanList->ChanInfo.bUseInterpreter == 1)
				{
					
					//welcher Interpreter?
					switch(ChanList->ChanInfo.nInterpreterNr)
					{
					case 1:		//SPI
						{
							int res;
							res = ConvertSpi(HWInfo, ChanList->ChanInfo.nChannel, ChanList->ChanInfo.SpiCfg, la_buffer, &DataList);
								#ifdef DebugMode
									sprintf(msg, "                            %d.Spezialkanal(%d): SPI\n", 
																				i+1,ChanList->ChanInfo.nChannel);
									PrintDebug(msg);
								#endif

							break;
						}

					case 2:		//RS232
						{
							int res;
							res = ConvertRS232(HWInfo, LAConf, ChanList->ChanInfo.nChannel, 
											ChanList->ChanInfo.RsCfg, la_buffer, &DataList);
								#ifdef DebugMode
									sprintf(msg, "                            %d.Spezialkanal(Kanal: %d): RS232\n", 
																				i+1,ChanList->ChanInfo.nChannel);	
									PrintDebug(msg);
								#endif
							break;
						}
					case 3:
						{
							int res;
							res = ConvertCAN2(HWInfo, LAConf, ChanList->ChanInfo.nChannel, 
											ChanList->ChanInfo.CanCfg, la_buffer, &DataList);
								#ifdef DebugMode
									sprintf(msg, "                            %d.Spezialkanal(Kanal: %d): CAN 2.0\n", 
																				i+1,ChanList->ChanInfo.nChannel);	
									PrintDebug(msg);
								#endif
							break;
						}

					//eventuell weitere Interpreter hinzufgen

					}

				}

			//nchsten Spezialkanal abarbeiten
				if (i <nNumChan-1)
					ChanList = LL_ChanInfoGetNext(ChanList);
			}


			if (ChanList == NULL)
			{
				#ifdef DebugMode
					sprintf(msg, " [DLL] interprete_Data() ChanList == NULL; Abbruch!\n");	
					PrintDebug(msg);
				#endif
				break;
			}
		}

	}


	#ifdef DebugMode
		sprintf(msg, " [DLL] interprete_Data(); Interpretations-Dauer: %dms; Gefundene Pakete: %d\n",
			GetTickCount()-dStart,LL_DataGetNumElements(DataList));	
		PrintDebug(msg);
		
	#endif

	free(msg);

	return 1;
}

	char CalcByte(unsigned long nVal, unsigned int nNum)
	{
		char c;
		c = (char)(nVal >> (nNum*8) & 0xFF); 
		return c;
	}


	//////////////////////////////////
	//Zum addieren mehrere Channel
	//Diese Funktion darf nicht gendert werden
	//////////////////////////////////
	dllExp ULONG la_exp_get_multi_data(LA_HWInfo HWInfo, unsigned char *la_buffer, 
		int nTodo, int nChannel, ULONG t1, ULONG t2, int nChanBegin, int nChanEnd, unsigned char* cData)
	{

		char *msg = (char*)malloc(sizeof(unsigned char)*500);


		#ifdef DebugMode
			sprintf(msg, " [DLL] get__multi_data(); todo = %d; nChannel = %d; t1 = %d, t2 = %d, nMultlBeg = %d, nMultiEnd = %d\n",
				nTodo, nChannel,t1,t2, nChanBegin, nChanEnd);

			PrintDebug(msg);
		#endif

		DWORD dStart = GetTickCount();

		//Daten auslesen und die Anzahl zurck geben
		if (nTodo == 0)
		{
			


			if (la_buffer == NULL)
			{
				#ifdef DebugMode
					sprintf(msg, "             - Error: la_buffer = NULL\n");

					PrintDebug(msg);
				#endif
				return 0;
			}

			if (t1 == t2 || t1 > t2)
			{
				#ifdef DebugMode
					sprintf(msg, "             - Error: check t1 <=> t2\n");

					PrintDebug(msg);
				#endif
				return 0;
			}

			if (HWInfo.samples_max < t1 ||
				HWInfo.samples_max < t2)
			{
				#ifdef DebugMode
					sprintf(msg, "             - Error: t1/t2\n");

					PrintDebug(msg);
				#endif
				return 0;
			}

			ULONG nNumData = 0;
			int nNumMultiChan = (nChanEnd - nChanBegin) + 1; //z.B. (4-2) + 1
			int k;	//Schleifenvariable

			unsigned char *cChanState, *cChanStateLast;
			cChanState = (unsigned char*)malloc(nNumMultiChan * sizeof(unsigned char));
			cChanStateLast = (unsigned char*)malloc(nNumMultiChan * sizeof(unsigned char));



			sData Data;
			bool bChanged = false;

			//durchlaufe alle Samples
			for (ULONG i=t1; i<=t2;i++)
			{
				//aktuellen Kanal-Werte speichern
				for (k=0;k<nNumMultiChan;k++)
					cChanState[k] = IsSet(HWInfo, la_buffer, nChanBegin+k, i);


				//nderungen feststellen
				for (k=0;k<nNumMultiChan;k++)
					if (cChanState[k] != cChanStateLast[k])
						bChanged = true;

				//Gab es eine nderung/erste Runde?
				if (i == t1 || bChanged == true)
				{
					//Gab es eine nderung (erste Runde ausschlieen)
					if (i != t1 && bChanged == true)
					{
						//Datenpaket abschlieen
						Data.nLength = i - Data.nStart;

						//Datenpaket hinzufgen
						DataMultiList = LL_DataAdd(DataMultiList, Data);

						nNumData++;
					}

					//neues Paket vorbereiten
					Data.nStart = i;
					Data.cChannel = (char) nChannel;
					Data.cText = 0;
					Data.cColor = 0;
					Data.cType = 0;
					Data.nValue = 0;

					for (k=0;k<nNumMultiChan;k++)
					{
						if (cChanState[k] == 1)
						{
							Data.nValue += potentiate(2, k);
						}
					}

				/* Testausgaben: kosten viel Zeit!
					#ifdef DebugMode
						sprintf(msg, "             - Data Begin(%d): Start=%d; Channel=%d; Value=%d\n", 
											nNumData, Data.nStart, Data.cChannel, Data.nValue);

						PrintDebug(msg);
					#endif
					*/
				
					itoa(Data.nValue,Data.cStr,10);


					bChanged = false;

				}



				//aktuelle Kanal-Werte in den Last-Puffer schreiben
				for (int k=0;k<nNumMultiChan;k++)
					cChanStateLast[k] = cChanState[k];

			}




			#ifdef DebugMode
				sprintf(msg, "                get_multi_data Beendet (%dms)\n", 
								(GetTickCount() - dStart));

				PrintDebug(msg);
			#endif

			free(cChanState);
			free(cChanStateLast);
			free(msg);


			return nNumData;
		}

		//Daten zurck geben!
		if (nTodo == 1)
		{

			if (DataMultiList == NULL)
			{
				#ifdef DebugMode
					sprintf(msg, "                   - DataMultiList == NULL\n");
					PrintDebug(msg);
				#endif
				free(msg);
				return 0;
			}
	
			ULONG nNumElements;
			nNumElements = LL_DataGetNumElements(DataMultiList);

			DataMultiList = LL_DataGetFirst(DataMultiList);
			
			int nBitPos = 0;
			int nPaketSize = 45;

			//Daten zurckgeben
			for (ULONG i=0;i<nNumElements;i++)
			{
				if (DataMultiList == NULL)
				{
					free(msg);
					return -1;
				}

				nBitPos = 0;

				//Aufbau der Datenrckgabe:
				//	0:		char cText
				//	1:		char cType
				//	2:		char cColor
				//	3:		char cChannel
				//	4-36:	char nValue
				//	37-40:	ULONG nStart
				//	41-44:	ULONG nLength

				cData[(i*nPaketSize)+nBitPos++] = DataMultiList->Data.cText;
				cData[(i*nPaketSize)+nBitPos++] = DataMultiList->Data.cType;
				cData[(i*nPaketSize)+nBitPos++] = DataMultiList->Data.cColor;
				cData[(i*nPaketSize)+nBitPos++] = DataMultiList->Data.cChannel;





				for (int j=0;j<33;j++)
					cData[(i*nPaketSize) + nBitPos++] = DataMultiList->Data.cStr[j];

				//nStart
				cData[(i*nPaketSize)+nBitPos++] = CalcByte(DataMultiList->Data.nStart,0);
				cData[(i*nPaketSize)+nBitPos++] = CalcByte(DataMultiList->Data.nStart,1);
				cData[(i*nPaketSize)+nBitPos++] = CalcByte(DataMultiList->Data.nStart,2);
				cData[(i*nPaketSize)+nBitPos++] = CalcByte(DataMultiList->Data.nStart,3);


				//nLength
				cData[(i*nPaketSize)+nBitPos++] = CalcByte(DataMultiList->Data.nLength,0);
				cData[(i*nPaketSize)+nBitPos++] = CalcByte(DataMultiList->Data.nLength,1);
				cData[(i*nPaketSize)+nBitPos++] = CalcByte(DataMultiList->Data.nLength,2);
				cData[(i*nPaketSize)+nBitPos++] = CalcByte(DataMultiList->Data.nLength,3);

				/* Testausgaben: kosten viel Zeit!
				#ifdef DebugMode
					sprintf(msg, "                   -  Paket %d; Start: %d; Length: %d\n",i,DataMultiList->Data.nStart,
											DataMultiList->Data.nLength);
					PrintDebug(msg);
				#endif
				*/



				//Nchstes Datenpaket (wenn dies nicht das letzte ist
				if (i != (nNumElements-1))
					DataMultiList = LL_DataGetNext(DataMultiList);

			}

				#ifdef DebugMode
					sprintf(msg, "                   -  %d Packete zurck gegeben; Dauer: %dms\n",
									LL_DataGetNumElements(DataMultiList), (GetTickCount()-dStart));
					PrintDebug(msg);
				#endif

			//Datenliste lschen

			if (DataMultiList != NULL)
				DataMultiList = LL_DataClearList(DataMultiList);

			DataMultiList = NULL;


		}

		free(msg);
		return 0;
	}



/////////////////////////////////////////
// Convert Data
//
// Diese Funktion darf nicht gendert werden.
// Sie gibt die einzelnen Pakete zurck
/////////////////////////////////////////


	dllExp ULONG la_exp_get_data(ULONG todo, ULONG nNumData, unsigned char *cData,
									unsigned long t1, unsigned long t2)
	{
		
		char *msg;
		msg = (char*)malloc(sizeof(char)*400);

		#ifdef DebugMode
			sprintf(msg, " [DLL] get_data(); todo = %d; nNumData = %d, t1 = %d, t2 = %d\n", todo, nNumData,t1,t2);
			PrintDebug(msg);
		#endif

		DWORD dStart = GetTickCount();



		//todo == 0
		//Daten im Datenberecih zhlen und in 
		//die temprre Datenliste (DataTempList) einfgen

		if (todo == 0)
		{

			unsigned int nNumElements=0;

			if (DataTempList != NULL)
			{
				DataTempList = LL_DataClearList(DataTempList);
			}

			if (DataList == NULL)
			{
				#ifdef DebugMode
					sprintf(msg, "                   - DatenListe leer.\n");
					PrintDebug(msg);
				#endif
			}
			else
			{

				nNumElements = LL_DataGetNumElements(DataList);

				if (nNumElements == 0)
				{
					#ifdef DebugMode
						sprintf(msg, "                   - Keine Daten vorhanden.\n");
						PrintDebug(msg);
					#endif
				}
				else
				{

					DataList = LL_DataGetFirst(DataList);

					sData Data;

					for (ULONG i=0;i<nNumElements;i++)
					{
						if (DataList == NULL)
						{
							free(msg);
							return -1;
						}

						//Datenpakete auf den aktuellen Bereich berprfen

						Data = DataList->Data;

							#ifdef DebugMode
								sprintf(msg, "                   -  Paket %d; Start: %d; Length: %d; Value: %d\n",i,DataList->Data.nStart,
																		DataList->Data.nLength, DataList->Data.nValue);
								PrintDebug(msg);
							#endif

						if (t1 != t2)
						{
							if ((Data.nStart >= t1 && Data.nStart <= t2) ||
								((Data.nStart+Data.nLength) >= t1 && (Data.nStart+Data.nLength) <= t2) ||
								(Data.nStart <= t1) && (Data.nStart+Data.nLength) > t2)
								DataTempList = LL_DataAdd(DataTempList, Data);
						}
						else
							DataTempList = LL_DataAdd(DataTempList, Data);


						
					LL_DataNode *DListTmp = LL_DataGetNext(DataList);
						if (DListTmp == NULL)
							break;
						DataList = DListTmp;

					}


						#ifdef DebugMode
							sprintf(msg, "                   -  %d von %d Paketen extrahiert; Dauer: %dms\n",
											LL_DataGetNumElements(DataTempList), nNumElements, (GetTickCount()-dStart));
							PrintDebug(msg);
						#endif

				}
			}

			
			free(msg);
			return LL_DataGetNumElements(DataTempList);

		}


		// Temporre Datenliste zurck geben

		if (todo == 1)
		{
			unsigned int nNumElements;
			nNumElements = LL_DataGetNumElements(DataTempList);

			if (nNumData < nNumElements)
			{
				#ifdef DebugMode
					sprintf(msg, "                   - Nicht ausreichend Platz ([nNumData] ist: %d; soll: %d).\n",
										nNumData, nNumElements);
					PrintDebug(msg);
				#endif
				free(msg);
				return 0;
			}

			if (DataTempList == NULL)
			{
				#ifdef DebugMode
					sprintf(msg, "                   - DataTempList == NULL\n");
					PrintDebug(msg);
				#endif
				free(msg);
				return 0;
			}
	


			DataTempList = LL_DataGetFirst(DataTempList);
			
			int nBitPos = 0;
			int nPaketSize = 45;

			//Daten zurckgeben
			for (ULONG i=0;i<nNumElements;i++)
			{
				if (DataTempList == NULL)
				{
					free(msg);
					return -1;
				}

				nBitPos = 0;

				//Aufbau der Datenrckgabe:
				//	0:		char cText
				//	1:		char cType
				//	2:		char cColor
				//	3:		char cChannel
				//	4-36:	char nValue
				//	37-40:	ULONG nStart
				//	41-44:	ULONG nLength

				cData[(i*nPaketSize)+nBitPos++] = DataTempList->Data.cText;
				cData[(i*nPaketSize)+nBitPos++] = DataTempList->Data.cType;
				cData[(i*nPaketSize)+nBitPos++] = DataTempList->Data.cColor;
				cData[(i*nPaketSize)+nBitPos++] = DataTempList->Data.cChannel;


				for (int j=0;j<33;j++)
					cData[(i*nPaketSize) + nBitPos++] = DataTempList->Data.cStr[j];

				//nStart
				cData[(i*nPaketSize)+nBitPos++] = CalcByte(DataTempList->Data.nStart,0);
				cData[(i*nPaketSize)+nBitPos++] = CalcByte(DataTempList->Data.nStart,1);
				cData[(i*nPaketSize)+nBitPos++] = CalcByte(DataTempList->Data.nStart,2);
				cData[(i*nPaketSize)+nBitPos++] = CalcByte(DataTempList->Data.nStart,3);


				//nLength
				cData[(i*nPaketSize)+nBitPos++] = CalcByte(DataTempList->Data.nLength,0);
				cData[(i*nPaketSize)+nBitPos++] = CalcByte(DataTempList->Data.nLength,1);
				cData[(i*nPaketSize)+nBitPos++] = CalcByte(DataTempList->Data.nLength,2);
				cData[(i*nPaketSize)+nBitPos++] = CalcByte(DataTempList->Data.nLength,3);

				#ifdef DebugMode
								sprintf(msg, "                   -  Paket %d; Start: %d; Length: %d; Value: %d\n",i,DataTempList->Data.nStart,
																		DataTempList->Data.nLength, DataTempList->Data.nValue);
					PrintDebug(msg);
				#endif



				//Nchstes Datenpaket (wenn dies nicht das letzte ist
				if (i != (nNumElements-1))
					DataTempList = LL_DataGetNext(DataTempList);

			}

				#ifdef DebugMode
					sprintf(msg, "                   -  %d aus %d Pakete kopiert; Dauer: %dms\n",
									nNumElements,LL_DataGetNumElements(DataList), (GetTickCount()-dStart));
					PrintDebug(msg);
				#endif


		}
		if (msg != NULL)
			free(msg);
		return 1;
	}














