
#include "convertSPI.h"




int ConvertSpi(LA_HWInfo HWInfo, int nChannel, SPIConfig SpiCfg, unsigned char *cBuffer, 
			 LL_DataNode **dList)
{
	
	bool bExtendeDebug = true;
	char *msg;	

	//Fehlerabfragen

	if ((HWInfo.bytes_per_sample*8) < HWInfo.channel_max) 
	{
		#ifdef DebugMode
			msg = (char*)malloc(sizeof(char)*100);
			sprintf(msg, "                      (bytesPerSample*8) < ChannelMax\n");	
			PrintDebug(msg);
			free(msg);
		#endif

		return 1;
	}

	if (cBuffer == NULL)
	{
		#ifdef DebugMode
			msg = (char*)malloc(sizeof(char)*100);
			sprintf(msg, "                      la_buffer == NULL\n");	
			PrintDebug(msg);
			free(msg);
		#endif

		return 1;
	}


	if ((SpiCfg.nChannelClk == SpiCfg.nChannelCS) == SpiCfg.nChannelData)
	{
		#ifdef DebugMode
			msg = (char*)malloc(sizeof(char)*100);
			sprintf(msg, "                      SPI-Kanle mssen verschieden sein!\n");	
			PrintDebug(msg);
			free(msg);
		#endif

		return 1;
	}

	// Konvertierung vorbereiten

	unsigned int nSamplePos = 0;

	unsigned long nByteStart;
//	unsigned long nByteLength;
	unsigned long nBitCount;
	sData	data;
	int nChipSelect;
	int nClock;
	int nData;
	bool bReadBits;
	bool bLastClk;

	bReadBits = false;
	bLastClk  = false;

	nByteStart = 0;

	nBitCount = 0;

	data.nValue = 0;


		#ifdef DebugMode
			msg = (char*)malloc(sizeof(char)*200);
			sprintf(msg, "                  (SPI); Datenbername(%d) NumBits(%d) CS(%d) CLK(%d) DATA(%d)!\n",
											SpiCfg.nRisingEdge, SpiCfg.nNumBits, SpiCfg.nChannelCS, SpiCfg.nChannelClk,
											SpiCfg.nChannelData);	
			PrintDebug(msg);
			free(msg);
		#endif


	while (nSamplePos <= HWInfo.samples_max)
	{
		//1. Such nach CS = 0

		nChipSelect = IsSet(HWInfo, cBuffer,SpiCfg.nChannelCS, nSamplePos);
		if (nChipSelect == -1)
			return -1;

		nClock = IsSet(HWInfo, cBuffer,SpiCfg.nChannelClk, nSamplePos);
			if (nClock == -1)
				return -1;

		if (nChipSelect == SpiCfg.nCSActive )
		{ 
			//CS wird zum ersten mal aktiviert
			/*
			if (bReadBits == false)
			{
				bReadBits = true;
				nBitCount = 0;
				data.nStart = nSamplePos;
			}
			*/
			//CLK-Signal untersuchen

			//TODO: auf fallende/steigende Flanke warten
			// CLK liegt in nCLK!
			// Ebenfalls vorhanden: bLastClk!

			//Steigende Flanke:
			if (nClock == 1 && bLastClk == false && SpiCfg.nRisingEdge == 1)
			{
				//startet Datenwort?
				bReadBits = true;

				if (nBitCount == 0)
				{
					data.nStart = nSamplePos;
				}

				//Datenbit auswerten
				nData = IsSet(HWInfo, cBuffer,SpiCfg.nChannelData, nSamplePos);

				if (nData == -1)
					return -1;

				if (nData == 0)
					data.cStr[nBitCount] = '0';
				else
					data.cStr[nBitCount] = '1';

				data.nValue += nData * potentiate(2,SpiCfg.nNumBits-nBitCount-1);
				nBitCount++;

			}

			//fallende Flanke:
			if (nClock == 0 && bLastClk == true && SpiCfg.nRisingEdge == 0)
			{
				//startet Datenwort?
				bReadBits = true;

				if (nBitCount == 0)
				{
					data.nStart = nSamplePos;
				}

				//Datenbit auswerten
				nData = IsSet(HWInfo, cBuffer,SpiCfg.nChannelData, nSamplePos);

				if (nData == -1)
					return -1;

				if (nData == 0)
					data.cStr[nBitCount] = '0';
				else
					data.cStr[nBitCount] = '1';

				data.nValue += nData * potentiate(2,SpiCfg.nNumBits-nBitCount-1);
				nBitCount++;
			}




/*
			//Datenbit einlesen?
				//erste Flanke?
				if (nClock != nIdle && bLastClk == false)
				{

					bReadBits = true;
					if (nBitCount == 0)
					{
						data.nStart = nSamplePos;
					}
					//Datenbernahme
					if (bFirstEdge)
					{

						nData = IsSet(HWInfo, cBuffer,SpiCfg.nChannelData, nSamplePos);
						if (nData == -1)
							return -1;
						data.nValue += nData * potentiate(2,SpiCfg.nNumBits-nBitCount-1);
						nBitCount++;
					}
				}
*/
/*
				//weite Flanke?
				if (nClock == nIdle &&  bLastClk == true)
				{
					if (!bFirstEdge)
					{
						nData = IsSet(HWInfo, cBuffer,SpiCfg.nChannelData, nSamplePos);
						if (nData == -1)
							return -1;
						data.nValue += nData * potentiate(2,SpiCfg.nNumBits-nBitCount-1);
						nBitCount++;
					}
				}
*/

			//Datenwort abschlieen!
			//Hier wird im korrekten Fall das Datenwort abgeschlossen
			if (nBitCount == (unsigned int)SpiCfg.nNumBits ) // && nCl... ausklammern?
			{

				
				data.cText = 0;			//kein Text

				data.cChannel	= (unsigned char)nChannel;
				data.cColor		= 0;
				data.cType		= SpiCfg.cType;
				data.nLength	= nSamplePos - data.nStart-1;



				switch (SpiCfg.cType)
				{
				case TYPE_DEZ:
					itoa(data.nValue, data.cStr, 10);
					break;
				case TYPE_HEX:
					itoa(data.nValue, data.cStr, 16);
					break;
				case TYPE_BIN:
					//Str ist schon binr! noch Terminieren:
					data.cStr[nBitCount] = '\0';
					break;
				case TYPE_ASC:

					if (data.nValue > 255)
						strncpy(data.cStr,"Error: ASCII 8Bit",30);
					else
					{
						data.cStr[0] = (char)data.nValue;
						data.cStr[1] = '\0';
					}
					break;
				default:
					sprintf(data.cStr,"Fehler");
				}

				if (bExtendeDebug)
				{
					#ifdef DebugMode
						msg = (char*)malloc(sizeof(char)*250);

						sprintf(msg, "                  (SPI);  DatenWert(%d); Lnge(%d); DatenBits(%d); DatenStart(%d) Daten-Text: %d Anzeige: %s\n",
							data.nValue, data.nLength, nBitCount,data.nStart, data.cText, data.cStr);	
						PrintDebug(msg);
						free(msg);
					#endif
				}


				(*dList) = LL_DataAdd((*dList), data);
			

				data.nValue = 0;
				bReadBits = false;
				nBitCount = 0;

			}



		}
		else
		{
			//wird das Datenlesen beendet?
			if (bReadBits == true)
			{
				bReadBits = false;
				
				//Bits korrekt?
				if (nBitCount == (unsigned int)SpiCfg.nNumBits)
				{
					data.cText = 0;			//kein Text
					data.cColor = 0;
				}
				else
				{
					data.cText = 2;			//Text: #Bits falsch
					strncpy(data.cStr, "Bit-Error\0",10);
					data.cColor = 0;
				}
		if (bExtendeDebug)
		{
			#ifdef DebugMode
				msg = (char*)malloc(sizeof(char)*100);

				sprintf(msg, "                 (SPI);  DatenWert: %d; DatenStart: %d; DatenBits: %d; Daten-Text: %d\n",data.nValue, data.nStart, nBitCount, data.cText);	
				PrintDebug(msg);
				free(msg);
			#endif
		}

				data.cChannel	= (unsigned char)nChannel;
				data.cType		= SpiCfg.cType;
				data.nLength	= nSamplePos - data.nStart;


				(*dList) = LL_DataAdd((*dList), data);


				data.nValue = 0;
				data.nStart = 0;


			}


		}

		if (nClock == 0)
			bLastClk = false;
		else
			bLastClk = true;


		nSamplePos++;
	}

	return 0;
}
