#include "convertIIC.h"






int ConvertIIC(LA_HWInfo HWInfo, int nChannel, IICConfig IICCfg, unsigned char *cBuffer,
				LL_DataNode **dList)

{
	bool bExtendedDebug = false;

	char *msg;	
	msg = (char*)malloc(sizeof(char)*1000);

	if (bExtendedDebug)
	{
		
	//Konfiguration anzeigen
		#ifdef DebugMode
			sprintf(msg, "         ConvertIIC(); Begin (Clock: %d; Daten: %d\n", IICCfg.nChannelClk, IICCfg.nChannelData);	
			PrintDebug(msg);
		#endif
	}


	//Fehlerabfragen

	if ((HWInfo.bytes_per_sample*8) < HWInfo.channel_max) 
	{
		#ifdef DebugMode
			sprintf(msg, "                     (bytesPerSample*8) < ChannelMax\n");	
			PrintDebug(msg);
		#endif
		
		free(msg);
		return 1;
	}

	if (IICCfg.nChannelClk == IICCfg.nChannelData)
	{
		#ifdef DebugMode
			sprintf(msg, "                     IIC: Clk == Data\n");	
			PrintDebug(msg);
		#endif
		free(msg);
		return 1;
	}


	ULONG nSamplePos = 0;
	int nData, nClk;


	//Zunchst: Warten, bis Data und CLK 1 sind

	while(nSamplePos < (HWInfo.samples_max ))
	{
		nData = IsSet(HWInfo,cBuffer,IICCfg.nChannelData, nSamplePos);
		nClk = IsSet(HWInfo,cBuffer,IICCfg.nChannelClk, nSamplePos);

		if (nData == -1 ||
			nClk == -1)
			return 0;

		if (nData == 1 &&
			nClk == 1)
		{
			break;
		}

		nSamplePos++;
	}

	bool bExtendedAdress = false;
	bool bWrite = false;

	unsigned char byte[8];
	unsigned int nAdress;
	sData Data;
	char cStr[33], cVal[33];
	int i;

	while (nSamplePos < (HWInfo.samples_max))
	{

		nData = IsSet(HWInfo,cBuffer,IICCfg.nChannelData, nSamplePos);
		nClk = IsSet(HWInfo,cBuffer,IICCfg.nChannelClk, nSamplePos);


		//Todo: Startsignal abwarten!

		if (nClk == 1 && nData == 0)
		{

			//Warte, bis nClk auf 0 geht

			while (nSamplePos < (HWInfo.samples_max))
			{
				nClk = IsSet(HWInfo,cBuffer,IICCfg.nChannelClk, nSamplePos);
				if (nClk == -1)
					return 0;
				if (nClk == 0)
					break;
				nSamplePos++;
			}

			Data.nStart = nSamplePos;

			//Adresse ( 4Bits HW-Adresse; 3Bits Sub-Adresse) + R/W lesen

			for (i=0;i<8;i++)
			{	
				//Warte, bis CLK == 1
				while (nSamplePos < (HWInfo.samples_max))
				{
					nClk = IsSet(HWInfo,cBuffer,IICCfg.nChannelClk, nSamplePos);
					if (nClk == -1)
						return 0;
					if (nClk == 1)
						break;
					nSamplePos++;
				}

							
				//Datenbit einlesen (MSB zuerst)
				nData = IsSet(HWInfo,cBuffer,IICCfg.nChannelData, nSamplePos);

				if (nData == -1)
					return 0;

				byte[i] = nData;

				//Warte, bis CLK == 0
				while (nSamplePos < (HWInfo.samples_max))
				{
					nClk = IsSet(HWInfo,cBuffer,IICCfg.nChannelClk, nSamplePos);
					if (nClk == -1)
						return 0;
					if (nClk == 0)
						break;
					nSamplePos++;
				}
				
			}

			//ACK einlesen

//TODO!

			if (byte[7] == 1)
				bWrite = false;
			else
				bWrite = true;

			//Achtung: HW Adresse 1 1 1 1 ; Sub.0 = 0 --> 10 Bit Adressierung verwenden

			nAdress = 0;

			if (byte[0] == 1 &&
				byte[1] == 1 &&
				byte[2] == 1 &&
				byte[3] == 1 &&
				byte[4] == 0)
			{
				bExtendedAdress = true;

				//bit 5 und 6 verweten!

				nAdress = nAdress | (byte[5] << 9);
				nAdress = nAdress | (byte[6] << 8);

				if (byte[5] == 1)
					cVal[0] = '1';
				else
					cVal[0] = '0';

				if (byte[6] == 1)
					cVal[1] = '1';
				else
					cVal[1] = '0';

				//weitere 8 Adress-bits:

				for (i=0;i<8;i++)
				{	
					//Warte, bis CLK == 1
					while (nSamplePos < (HWInfo.samples_max))
					{
						nClk = IsSet(HWInfo,cBuffer,IICCfg.nChannelClk, nSamplePos);
						if (nClk == -1)
							return 0;
						if (nClk == 1)
							break;
						nSamplePos++;
					}
					
					//Datenbit einlesen (MSB zuerst)
					nData = IsSet(HWInfo,cBuffer,IICCfg.nChannelData, nSamplePos);

					if (nData == -1)
						return 0;

					byte[i] = nData;

					//Warte, bis CLK == 0
					while (nSamplePos < (HWInfo.samples_max))
					{
						nClk = IsSet(HWInfo,cBuffer,IICCfg.nChannelClk, nSamplePos);
						if (nClk == -1)
							return 0;
						if (nClk == 0)
							break;
						nSamplePos++;
					}
					
				}

				//ACK einlesen

//TODO

				for (i=0;i<7;i++)
				{
					nAdress = nAdress | (byte[i]<<(7-i));
					if (byte[i] == 1)
						cVal[2+i] = '1';
					else
						cVal[2+i] = '0';
				}

				cVal[10] = '\0';

			}
			else
			{
				for (int i=0;i<7;i++)
				{
					nAdress = nAdress | (byte[i]<<(7-i));
					if (byte[i] == 1)
						cVal[i] = '1';
					else
						cVal[i] = '0';
				}
				cVal[8] = '\0';
			}

			//1. Datenpaket

			switch (IICCfg.cType)
			{
				case TYPE_DEZ:
					itoa(nAdress, cVal, 10);
					break;
				case TYPE_HEX:
					itoa(nAdress, cVal, 16);
					break;
			}


			Data.nLength = nSamplePos - Data.nStart;
			Data.cChannel = nChannel;
			Data.cText = 0;
			Data.cColor = 0;
			Data.cType = IICCfg.cType;

			strncpy(cStr, "Adr.: ",33);
			strncat(cStr, cVal,33);
			if (bWrite)
				strncat(cStr, " [W]",33);
			else
				strncat(cStr, " [R]",33);

			strncpy(Data.cStr, cStr,33);
			
			//Datenpaket hinzufgen



			//STOP Signal?

			//Datenbyte (8Bit) lesen

			//ACK lesen



			//

		}


		nSamplePos ++;
	}



	free(msg);

	return 0;
}