#include "convertCAN2.h"






int ConvertCAN2(LA_HWInfo HWInfo,LA_Configuration LAConf, int nChannel, 
				 CANConfig CanCfg, unsigned char *cBuffer, LL_DataNode **dList)
{

	
	bool bExtendedDebug = false;

	char *msg;	
	msg = (char*)malloc(sizeof(char)*1000);

	if (bExtendedDebug)
	{
		
	//Konfiguration anzeigen
		#ifdef DebugMode
			sprintf(msg, "         ConvertCAN2(); Begin \n");	
			PrintDebug(msg);

			sprintf(msg, "             - Baud:%d\n", CanCfg.nBaud);
			PrintDebug(msg);

			sprintf(msg, "             - Kanal:%d\n", CanCfg.nChannelData);
			PrintDebug(msg)
		#endif
	}


	//Fehlerabfragen

	if ((HWInfo.bytes_per_sample*8) < HWInfo.channel_max) 
	{
		#ifdef DebugMode
			sprintf(msg, "                     (bytesPerSample*8) < ChannelMax\n");	
			PrintDebug(msg);
		#endif
		
		free(msg);
		return 1;
	}


	float	TBaud,TSample;
	unsigned int nSamplesPerBit;
	float fSamplesPerBit;

	if (CanCfg.nBaud == 0)
	{
		#ifdef DebugMode
			sprintf(msg, "                      CAN2 Baud == 0\n");	
			PrintDebug(msg);
		#endif
		free(msg);
		return 1;
	}


	fSamplesPerBit = (float)LAConf.sample_clock / (float)CanCfg.nBaud;
	nSamplesPerBit = (int)(LAConf.sample_clock / CanCfg.nBaud);
	
	if (fSamplesPerBit < 2.0)
	{
		#ifdef DebugMode
			sprintf(msg, "         ConvertCAN2(); *** ACHTUNG: Abtastrate zu gering! \n");	
			PrintDebug(msg);
		#endif
	}
	if (fSamplesPerBit > 2.0 && fSamplesPerBit < 2.5)
	{
		#ifdef DebugMode
			sprintf(msg, "         ConvertCAN2(); *** ACHTUNG: Abtastrate  sollte hher gewhlt werden! \n");	
			PrintDebug(msg);
		#endif
	}


	ULONG nSamplePos;
	double fSamplePos; 

	unsigned char cNumData;

	ULONG nStart, nCRC, nCalcCRC;
	int nTmp, nRTR, nIDE;
	bool bExtendedFrame, bStuffError, bCRCError, bRTR;
	bExtendedFrame = false;
	bRTR = false;

	int nBitStuffCount, nBitStuffPolarity;

	nSamplePos = 0;
	fSamplePos = 0.0;
	cNumData = 0;
	sData dIdent, dData[8], dCRC;

	nBitStuffCount = 0;


//	if (bExtendedDebug)
//	{
		#ifdef DebugMode
			sprintf(msg, "         ConvertCAN2(); analyse \n");	
			PrintDebug(msg);

			sprintf(msg, "                        Baud: %d; Detail: %d\n", CanCfg.nBaud, CanCfg.cDetail);	
			PrintDebug(msg);

			sprintf(msg, "                        Samples_Max: %d; Clock: %d\n", HWInfo.samples_max, LAConf.sample_clock);	
			PrintDebug(msg);


		#endif
//	}


	unsigned char crc[25];
	int nCrcBit = 0;

	for (int i=0;i<25;i++)
		crc[i] = 0;
/*	
	for (int i=0;i<9;i++)
	{
		CrcSetBit(crc,i,1);
	}

	#ifdef DebugMode
		sprintf(msg, "         CRC: %d, %d.\n", crc[0], crc[1]);	
		PrintDebug(msg);
	#endif
*/




	while ((unsigned long)fSamplePos < (HWInfo.samples_max-(int)fSamplesPerBit))
	{

		nTmp = IsSet(HWInfo,cBuffer,CanCfg.nChannelData, (int)fSamplePos);
		nBitStuffCount = 1;
		nBitStuffPolarity = nTmp;

		bStuffError = false;
		bCRCError = false;

		if (nTmp == -1)
		{
			free(msg);
			return 0;
		}
		//erstes Start-Bit (low):
		if (nTmp == 0)
		{

			if (bExtendedDebug)
			{
				#ifdef DebugMode
					sprintf(msg, "         ConvertCAN2(); DataStart (%f) \n", fSamplePos);	
					PrintDebug(msg);
				#endif
			}
			
			nCrcBit = 0;

			for (int i=0;i<20;i++)
				crc[i] = 0;

			nStart = (int)fSamplePos;
			nSamplePos = (int)fSamplePos;



			dIdent.cText		= 0;
			dIdent.cColor		= 0;
			dIdent.cType		= CanCfg.cType;
			dIdent.cChannel	= nChannel;
			dIdent.nValue		= 0;
			dIdent.nStart		= nStart;

			//Halbe Bitlnge nach vorn springen
			fSamplePos += (fSamplesPerBit / 2.0f);

				//Datenbits durchlaufen!:
				
					if (bExtendedDebug)
					{
						#ifdef DebugMode
							sprintf(msg, "         ConvertCAN2(); Identifer durchlaufen\n");	
							PrintDebug(msg);
						#endif
					}

				//11 Bits Identifer (MSB zuerst!)

					for (i=0;(i<11) && bStuffError == false;i++)
					{

						fSamplePos += fSamplesPerBit;
						nTmp = IsSet(HWInfo, cBuffer,CanCfg.nChannelData, (int)fSamplePos);

						// Bit Stuffing (bei 5 gleiochen Bits folgt ein entgegengesetztes)
							if (nTmp == nBitStuffPolarity || nBitStuffCount == 0)
							{
								nBitStuffCount++;
								nBitStuffPolarity = nTmp;
								/*
								#ifdef DebugMode
									sprintf(msg, "            - BitStuffing: StuffCount:%d ; Position: %f\n", nBitStuffCount, fSamplePos);	
									PrintDebug(msg);
								#endif
								*/
								if (nBitStuffCount > 4)
								{
									int nStuff;
									fSamplePos += fSamplesPerBit;
									nStuff = IsSet(HWInfo, cBuffer,CanCfg.nChannelData, (int)fSamplePos);

									//Richtiges gestopftes Bit?
									if (nStuff == 0 && nBitStuffPolarity == 1 ||
										nStuff == 1 && nBitStuffPolarity == 0)
									{
										
									}
									else
									{
										#ifdef DebugMode
											sprintf(msg, "         ConvertCAN2(); Bit Stuffing nicht korrekt.\n");	
											PrintDebug(msg);
										#endif
										bStuffError = true;
									}
									nBitStuffCount = 1;
									nBitStuffPolarity = nStuff;
								}
							}
							else
							{
								nBitStuffCount = 1;
								nBitStuffPolarity = nTmp;
							}
						//Bit Stuffing Ende


						if (nTmp == -1)
						{
							free(msg);
							return 0;
						}

						
						if (nTmp)
						{

							dIdent.nValue += potentiate(2,10-i);

							dIdent.cStr[i] = '1';

							CrcSetBit(crc, nCrcBit,1);
							nCrcBit++;

							if (bExtendedDebug)
							{
								#ifdef DebugMode
									sprintf(msg, " [CAN 2.0] %d. Bit: %d - (Pos: %f)\n",i+1, nTmp, fSamplePos);	
									PrintDebug(msg);
								#endif
							}
						}	
						else
						{
							dIdent.cStr[i] = '0';

							CrcSetBit(crc, nCrcBit,0);
							nCrcBit++;

							if (bExtendedDebug)
							{
								#ifdef DebugMode
									sprintf(msg, " [CAN 2.0] %d. Bit: 0 - (Pos: %f)\n",i+1,fSamplePos);	
									PrintDebug(msg);
								#endif
							}
						}

						if (bStuffError)
							break;
					}

				//RTR auslesen
					fSamplePos += fSamplesPerBit;
					nRTR = IsSet(HWInfo, cBuffer,CanCfg.nChannelData, (int)fSamplePos);
					
					CrcSetBit(crc, nCrcBit,nRTR);
					nCrcBit++;

					if (nRTR == -1)
					{
						free(msg);
						return 0;
					}
			
					if (nRTR == 1)
						bRTR = true;

					// Bit Stuffing (bei 5 gleiochen Bits folgt ein entgegengesetztes)
							if (nRTR == nBitStuffPolarity || nBitStuffCount == 0)
							{
								nBitStuffCount++;
								nBitStuffPolarity = nRTR;
								/*
								#ifdef DebugMode
									sprintf(msg, "            - BitStuffing: StuffCount:%d ; Position: %f\n", nBitStuffCount, fSamplePos);	
									PrintDebug(msg);
								#endif*/
								if (nBitStuffCount > 4)
								{
									int nStuff;
									fSamplePos += fSamplesPerBit;
									nStuff = IsSet(HWInfo, cBuffer,CanCfg.nChannelData, (int)fSamplePos);

									//Richtiges gestopftes Bit?
									if (nStuff == 0 && nBitStuffPolarity == 1 ||
										nStuff == 1 && nBitStuffPolarity == 0)
									{
										
									}
									else
									{
										#ifdef DebugMode
											sprintf(msg, "         ConvertCAN2(); Bit Stuffing nicht korrekt.\n");	
											PrintDebug(msg);
										#endif
										bStuffError = true;
									}
									nBitStuffCount = 1;
									nBitStuffPolarity = nStuff;
								}
							}
							else
							{
								nBitStuffCount = 1;
								nBitStuffPolarity = nRTR;
							}
					//Bit Stuffing Ende

					#ifdef DebugMode
						sprintf(msg, "         RTR: %d\n", nRTR);	
						PrintDebug(msg);
					#endif



				//IDE auslesen
					fSamplePos += fSamplesPerBit;
					nIDE = IsSet(HWInfo, cBuffer,CanCfg.nChannelData, (int)fSamplePos);
					
					CrcSetBit(crc, nCrcBit,nIDE);
					nCrcBit++;

					if (nIDE == -1)
					{
						free(msg);
						return 0;
					}

					// Bit Stuffing (bei 5 gleiochen Bits folgt ein entgegengesetztes)
							if (nIDE == nBitStuffPolarity || nBitStuffCount == 0)
							{
								nBitStuffCount++;
								nBitStuffPolarity = nIDE;
								/*#ifdef DebugMode
									sprintf(msg, "            - BitStuffing: StuffCount:%d ; Position: %f\n", nBitStuffCount, fSamplePos);	
									PrintDebug(msg);
								#endif*/
								if (nBitStuffCount > 4)
								{
									int nStuff;
									fSamplePos += fSamplesPerBit;
									nStuff = IsSet(HWInfo, cBuffer,CanCfg.nChannelData, (int)fSamplePos);

									//Richtiges gestopftes Bit?
									if (nStuff == 0 && nBitStuffPolarity == 1 ||
										nStuff == 1 && nBitStuffPolarity == 0)
									{
										
									}
									else
									{
										#ifdef DebugMode
											sprintf(msg, "         ConvertCAN2(); Bit Stuffing nicht korrekt.\n");	
											PrintDebug(msg);
										#endif
										bStuffError = true;
									}
									nBitStuffCount = 1;
									nBitStuffPolarity = nStuff;
								}
							}
							else
							{
								nBitStuffCount = 1;
								nBitStuffPolarity = nIDE;
							}
					//Bit Stuffing Ende

					#ifdef DebugMode
						sprintf(msg, "         IDE: %d\n", nIDE);	
						PrintDebug(msg);
					#endif


				//Extended Frame? (29 Bit Identifer)
					if (nIDE == 1)
					{
						bExtendedFrame = true;

						dIdent.nValue = dIdent.nValue << 18;

						//weitere 18 Identifer Bits einlesen
						for (int i=0;(i<18) && bStuffError == false;i++)
						{

							fSamplePos += fSamplesPerBit;
							nTmp = IsSet(HWInfo, cBuffer,CanCfg.nChannelData, (int)fSamplePos);
							if (nTmp == -1)
							{
								free(msg);
								return 0;
							}

						// Bit Stuffing (bei 5 gleiochen Bits folgt ein entgegengesetztes)
								if (nTmp == nBitStuffPolarity || nBitStuffCount == 0)
								{
									nBitStuffCount++;
									nBitStuffPolarity = nTmp;
									/*
									#ifdef DebugMode
										sprintf(msg, "            - BitStuffing: StuffCount:%d ; Position: %f\n", nBitStuffCount, fSamplePos);	
										PrintDebug(msg);
									#endif*/
									if (nBitStuffCount > 4)
									{
										int nStuff;
										fSamplePos += fSamplesPerBit;
										nStuff = IsSet(HWInfo, cBuffer,CanCfg.nChannelData, (int)fSamplePos);

										//Richtiges gestopftes Bit?
										if (nStuff == 0 && nBitStuffPolarity == 1 ||
											nStuff == 1 && nBitStuffPolarity == 0)
										{
											
										}
										else
										{
											#ifdef DebugMode
												sprintf(msg, "         ConvertCAN2(); Bit Stuffing nicht korrekt.\n");	
												PrintDebug(msg);
											#endif
											bStuffError = true;
										}
										nBitStuffCount = 1;
										nBitStuffPolarity = nStuff;
									}
								}
								else
								{
									nBitStuffCount = 1;
									nBitStuffPolarity = nTmp;
								}
						//Bit Stuffing Ende

							
							if (nTmp)
							{

								dIdent.nValue += potentiate(2,17-i);

								dIdent.cStr[i+12] = '1';

								CrcSetBit(crc, nCrcBit,1);
								nCrcBit++;

								if (bExtendedDebug)
								{
									#ifdef DebugMode
										sprintf(msg, " [CAN 2.0] %d. Bit: %d - (Pos: %f)\n",i+12, nTmp, fSamplePos);	
										PrintDebug(msg);
									#endif
								}
							}	
							else
							{
								dIdent.cStr[i+11] = '0';

								CrcSetBit(crc, nCrcBit,0);
								nCrcBit++;

								if (bExtendedDebug)
								{
									#ifdef DebugMode
										sprintf(msg, " [CAN 2.0] %d. Bit: 0 - (Pos: %f)\n",i+12,fSamplePos);	
										PrintDebug(msg);
									#endif
								}
							}
							if (bStuffError)
								break;
						}

						//ID ist nun "verkehrt" und muss gedreht werden (11111111111111111100000000000)
						/*
						ULONG lngTmp = dIdent.nValue;
						lngTmp = lngTmp << 19;
						lngTmp = lngTmp & 0x3FF80000;
						dIdent.nValue = dIdent.nValue >> 11;
						dIdent.nValue = dIdent.nValue & 0x7FFFF;
						dIdent.nValue = dIdent.nValue | lngTmp;
						*/
						//RTR einlesen
						fSamplePos += fSamplesPerBit;
						nRTR = IsSet(HWInfo, cBuffer,CanCfg.nChannelData, (int)fSamplePos);

						CrcSetBit(crc, nCrcBit,nRTR);
						nCrcBit++;

						if (nRTR == -1)
						{
							free(msg);
							return 0;
						}

						bRTR = false;
						if (nRTR == 1)
							bRTR = true;

						// Bit Stuffing (bei 5 gleiochen Bits folgt ein entgegengesetztes)
								if (nRTR == nBitStuffPolarity || nBitStuffCount == 0)
								{
									nBitStuffCount++;
									nBitStuffPolarity = nRTR;
									/*
									#ifdef DebugMode
										sprintf(msg, "            - BitStuffing: StuffCount:%d ; Position: %f\n", nBitStuffCount, fSamplePos);	
										PrintDebug(msg);
									#endif*/
									if (nBitStuffCount > 4)
									{
										int nStuff;
										fSamplePos += fSamplesPerBit;
										nStuff = IsSet(HWInfo, cBuffer,CanCfg.nChannelData, (int)fSamplePos);

										//Richtiges gestopftes Bit?
										if (nStuff == 0 && nBitStuffPolarity == 1 ||
											nStuff == 1 && nBitStuffPolarity == 0)
										{
											
										}
										else
										{
											#ifdef DebugMode
												sprintf(msg, "         ConvertCAN2(); Bit Stuffing nicht korrekt.\n");	
												PrintDebug(msg);
											#endif
											bStuffError = true;
										}
										nBitStuffCount = 1;
										nBitStuffPolarity = nStuff;
									}
								}
								else
								{
									nBitStuffCount = 1;
									nBitStuffPolarity = nRTR;
								}
						//Bit Stuffing Ende

							#ifdef DebugMode
								sprintf(msg, "         ext. RTR: %d\n", nRTR);	
								PrintDebug(msg);
							#endif

						//r1 (reserviert) einlesen (keine Bedeutung)
						fSamplePos += fSamplesPerBit;
						nRTR = IsSet(HWInfo, cBuffer,CanCfg.nChannelData, (int)fSamplePos);

						CrcSetBit(crc, nCrcBit,nRTR);
						nCrcBit++;

						// Bit Stuffing (bei 5 gleiochen Bits folgt ein entgegengesetztes)
								if (nRTR == nBitStuffPolarity || nBitStuffCount == 0)
								{
									nBitStuffCount++;
									nBitStuffPolarity = nRTR;
									/*
									#ifdef DebugMode
										sprintf(msg, "            - BitStuffing: StuffCount:%d ; Position: %f\n", nBitStuffCount, fSamplePos);	
										PrintDebug(msg);
									#endif*/
									if (nBitStuffCount > 4)
									{
										int nStuff;
										fSamplePos += fSamplesPerBit;
										nStuff = IsSet(HWInfo, cBuffer,CanCfg.nChannelData, (int)fSamplePos);

										//Richtiges gestopftes Bit?
										if (nStuff == 0 && nBitStuffPolarity == 1 ||
											nStuff == 1 && nBitStuffPolarity == 0)
										{
											
										}
										else
										{
											#ifdef DebugMode
												sprintf(msg, "         ConvertCAN2(); Bit Stuffing nicht korrekt.\n");	
												PrintDebug(msg);
											#endif
											bStuffError = true;
										}
										nBitStuffCount = 1;
										nBitStuffPolarity = nStuff;
									}

								}
								else
								{
									nBitStuffCount = 1;
									nBitStuffPolarity = nRTR;
								}
						//Bit Stuffing Ende

					}
					else
					{

					}


				//Identifer Paket abschlieen!
					dIdent.nLength = (long)fSamplePos - dIdent.nStart ;

					if (bStuffError)
						dIdent.cText = 1;

					switch (CanCfg.cType)
					{
					case TYPE_DEZ:
						itoa(dIdent.nValue, dIdent.cStr, 10);
						break;
					case TYPE_HEX:
						itoa(dIdent.nValue, dIdent.cStr, 16);
						break;
					case TYPE_BIN:
					case TYPE_ASC:
					default:
						//Str ist schon binr! noch Terminieren:
						if (bExtendedFrame)
							dIdent.cStr[28] = '\0';
						else
							dIdent.cStr[11] = '\0';
						break;

					}

				//	(*dList) = LL_DataAdd((*dList), dIdent);



				if (!bStuffError)
				{
				//r0 auslesen (base sowie extended Frame)

					fSamplePos += fSamplesPerBit;
					nRTR = IsSet(HWInfo, cBuffer,CanCfg.nChannelData, (int)fSamplePos);

					CrcSetBit(crc, nCrcBit,nRTR);
					nCrcBit++;

						// Bit Stuffing (bei 5 gleiochen Bits folgt ein entgegengesetztes)
								if (nRTR == nBitStuffPolarity || nBitStuffCount == 0)
								{
									nBitStuffCount++;
									nBitStuffPolarity = nRTR;
									/*
									#ifdef DebugMode
										sprintf(msg, "            - BitStuffing: StuffCount:%d ; Position: %f\n", nBitStuffCount, fSamplePos);	
										PrintDebug(msg);
									#endif*/
									if (nBitStuffCount > 4)
									{
										int nStuff;
										fSamplePos += fSamplesPerBit;
										nStuff = IsSet(HWInfo, cBuffer,CanCfg.nChannelData, (int)fSamplePos);

										//Richtiges gestopftes Bit?
										if (nStuff == 0 && nBitStuffPolarity == 1 ||
											nStuff == 1 && nBitStuffPolarity == 0)
										{
											
										}
										else
										{
											#ifdef DebugMode
												sprintf(msg, "         ConvertCAN2(); Bit Stuffing nicht korrekt.\n");	
												PrintDebug(msg);
											#endif
											bStuffError = true;
										}
										nBitStuffCount = 1;
										nBitStuffPolarity = nStuff;
									}

								}
								else
								{
									nBitStuffCount = 1;
									nBitStuffPolarity = nRTR;
								}
						//Bit Stuffing Ende

					#ifdef DebugMode
						sprintf(msg, "         reserved1: %d\n", nRTR);	
						PrintDebug(msg);
					#endif
				}

				if (!bStuffError)
				{
				// Anz. Daten auslesen.

					cNumData = 0;
					for (i=0;(i<4) && bStuffError == false;i++)
					{
						fSamplePos += fSamplesPerBit;
						nTmp = IsSet(HWInfo, cBuffer,CanCfg.nChannelData, (int)fSamplePos);

						CrcSetBit(crc, nCrcBit,nTmp);
						nCrcBit++;

						if (nTmp == -1)
						{
							free(msg);
							return 0;
						}
						// Bit Stuffing (bei 5 gleiochen Bits folgt ein entgegengesetztes)
								if (nTmp == nBitStuffPolarity || nBitStuffCount == 0)
								{
								nBitStuffCount++;
								nBitStuffPolarity = nTmp;
								//nBitStuffPolarity = nTmp;
								
								/*
								#ifdef DebugMode
									sprintf(msg, "            - BitStuffing: StuffCount:%d ; Position: %f\n", nBitStuffCount, fSamplePos);	
									PrintDebug(msg);
								#endif*/
								if (nBitStuffCount > 4)
								{
									int nStuff;
									fSamplePos += fSamplesPerBit;
									nStuff = IsSet(HWInfo, cBuffer,CanCfg.nChannelData, (int)fSamplePos);

									//Richtiges gestopftes Bit?
									if (nStuff == 0 && nBitStuffPolarity == 1 ||
										nStuff == 1 && nBitStuffPolarity == 0)
									{
										
									}
									else
									{
										#ifdef DebugMode
											sprintf(msg, "         ConvertCAN2(); Bit Stuffing nicht korrekt.\n");	
											PrintDebug(msg);
										#endif
										bStuffError = true;
									}
									nBitStuffCount = 1;
									nBitStuffPolarity = nStuff;
								}

								}
								else
								{
									nBitStuffCount = 1;
									nBitStuffPolarity = nTmp;
								}
						//Bit Stuffing Ende

		

						cNumData = cNumData | (nTmp << (3-i));

							if (bStuffError)
								break;
					}

					#ifdef DebugMode
						sprintf(msg, " [CAN 2.0] Anz. Daten: %d",cNumData);	
						PrintDebug(msg);
					#endif

						if (cNumData > 8)
							cNumData = 0;
				}

				if (!bStuffError)
				{
				//Einzelne Daten auslesen
					if (bRTR)
						cNumData = 0;
					for (int nByte=0; (nByte< cNumData) && bStuffError == false; nByte++)
					{

						dData[nByte].nStart = (long) (fSamplePos+fSamplesPerBit);
						dData[nByte].cChannel = nChannel;
						dData[nByte].cText = 0;
						dData[nByte].nValue = 0;
						dData[nByte].cColor = 0;
						dData[nByte].cType = CanCfg.cType;

						for (int i=0;(i<8) && bStuffError == false;i++)
						{
							fSamplePos += fSamplesPerBit;						
							nTmp = IsSet(HWInfo, cBuffer,CanCfg.nChannelData, (int)fSamplePos);

							CrcSetBit(crc, nCrcBit,nTmp);
							nCrcBit++;

							if (nTmp == -1)
							{
								free(msg);
								return 0;
							}

							if (nTmp == 1)
								dData[nByte].cStr[i] = '1';
							else
								dData[nByte].cStr[i] = '0';

						// Bit Stuffing (bei 5 gleiochen Bits folgt ein entgegengesetztes)
								if (nTmp == nBitStuffPolarity || nBitStuffCount == 0)
								{
									nBitStuffCount++;
									nBitStuffPolarity = nTmp;
									/*
									#ifdef DebugMode
										sprintf(msg, "            - BitStuffing: StuffCount:%d ; Position: %f\n", nBitStuffCount, fSamplePos);	
										PrintDebug(msg);
									#endif
									*/
									if (nBitStuffCount > 4)
									{
										int nStuff;
										fSamplePos += fSamplesPerBit;
										nStuff = IsSet(HWInfo, cBuffer,CanCfg.nChannelData, (int)fSamplePos);

										//Richtiges gestopftes Bit?
										if (nStuff == 0 && nBitStuffPolarity == 1 ||
											nStuff == 1 && nBitStuffPolarity == 0)
										{
											
										}
										else
										{
											#ifdef DebugMode
												sprintf(msg, "         ConvertCAN2(); Bit Stuffing nicht korrekt.\n");	
												PrintDebug(msg);
											#endif
											bStuffError = true;
										}
										nBitStuffCount = 1;
										nBitStuffPolarity = nStuff;
									}

								}
								else
								{
									nBitStuffCount = 1;
									nBitStuffPolarity = nTmp;
								}
						//Bit Stuffing Ende
							dData[nByte].nValue = dData[nByte].nValue | (nTmp << (7-i));

								if (bStuffError)
									break;

						}
						dData[nByte].nLength = (unsigned long)(fSamplePos) - dData[nByte].nStart; 

						switch (CanCfg.cType)
						{
						case TYPE_DEZ:
							itoa(dData[nByte].nValue, dData[nByte].cStr, 10);
							break;
						case TYPE_HEX:
							itoa(dData[nByte].nValue, dData[nByte].cStr, 16);
							break;
						case TYPE_BIN:
						case TYPE_ASC:
						default:
							//Str ist schon binr! noch Terminieren:
								dData[nByte].cStr[8] = '\0';
							break;

						}



						//(*dList) = LL_DataAdd((*dList), dData[nByte]);

						#ifdef DebugMode
							sprintf(msg, " [CAN 2.0] %d. Datenbyte: %d (Start: %d)\n",nByte+1, dData[nByte].nValue, dData[nByte].nStart);	
							PrintDebug(msg);
						#endif			
						}


					}
					if (!bStuffError)
						nCalcCRC = calcCRC(crc, nCrcBit);
					else
						nCalcCRC = 0;
					#ifdef DebugMode
					if (bExtendedDebug)
					{
						sprintf(msg, "    CRC-Bits: %d\n", nCrcBit);	
						PrintDebug(msg);
						for (int u=0;u<=(nCrcBit/8);u++)
						{
							sprintf(msg, "    CRC[%d]: %d\n", u+1, crc[u]);	
							PrintDebug(msg);
						}
					}
						if (!bStuffError)
						{
							sprintf(msg, "    Berechnete CRC-Value: %d\n", nCalcCRC);	
							PrintDebug(msg);
						}

					#endif


					if (!bStuffError)
					{
					//16 Bit Checksum
					nCRC = 0;

					dCRC.nStart = (long) ((fSamplePos) + fSamplesPerBit);
					dCRC.cChannel = nChannel;
					dCRC.cText = 0;
					dCRC.nValue = 0;
					dCRC.cColor = 0;
					dCRC.cType = CanCfg.cType;

					for (i=0;(i<16) && bStuffError == false;i++)
					{
						fSamplePos += fSamplesPerBit;
						nTmp = IsSet(HWInfo, cBuffer,CanCfg.nChannelData, (int)fSamplePos);

						if (nTmp == -1)
						{
							free(msg);
							return 0;
						}

						if (nTmp == 1)
							dCRC.cStr[i] = '1';
						else
							dCRC.cStr[i] = '0';


						// Bit Stuffing (bei 5 gleiochen Bits folgt ein entgegengesetztes)
						
						
								if (nTmp == nBitStuffPolarity || nBitStuffCount == 0)
								{
									nBitStuffCount++;
									nBitStuffPolarity = nTmp;
									/*
									#ifdef DebugMode
										sprintf(msg, "            - BitStuffing: StuffCount:%d ; Position: %f\n", nBitStuffCount, fSamplePos);	
										PrintDebug(msg);
									#endif*/
									if (nBitStuffCount > 4)
									{
										int nStuff;
										fSamplePos += fSamplesPerBit;
										nStuff = IsSet(HWInfo, cBuffer,CanCfg.nChannelData, (int)fSamplePos);

										//Richtiges gestopftes Bit?
										if (nStuff == 0 && nBitStuffPolarity == 1 ||
											nStuff == 1 && nBitStuffPolarity == 0)
										{
											
										}
										else
										{
											#ifdef DebugMode
												sprintf(msg, "         ConvertCAN2(); Bit Stuffing nicht korrekt.\n");	
												PrintDebug(msg);
											#endif
											bStuffError = true;
										}
										nBitStuffCount = 1;
										nBitStuffPolarity = nStuff;
									}

								}
								else
								{
									nBitStuffCount = 1;
									nBitStuffPolarity = nTmp;
								}
						//Bit Stuffing Ende
						
						//eigentlich 15 Bits..
						if (i < 15)
							nCRC = nCRC | (nTmp << (14-i));
					}

					dCRC.nValue = nCRC;
					dCRC.nLength = (unsigned long)(fSamplePos) - dCRC.nStart; 

					if (dCRC.nValue != nCalcCRC)
						bCRCError = true;


					switch (CanCfg.cType)
					{
					case TYPE_DEZ:
						itoa(dCRC.nValue, dCRC.cStr, 10);
						break;
					case TYPE_HEX:
						itoa(dCRC.nValue, dCRC.cStr, 16);
						break;
					case TYPE_BIN:
					case TYPE_ASC:
					default:
						//Str ist schon binr! noch Terminieren:
						dCRC.cStr[15] = '\0';
						break;

					}

					//if (CanCfg.cDetail == 1)
					//	(*dList) = LL_DataAdd((*dList), dCRC);

					#ifdef DebugMode
						sprintf(msg, " [CAN 2.0] Checksum: %d \n",nCRC);	
						PrintDebug(msg);
					#endif	
					} //BitStuffError


					if (!bStuffError)
					{

					//2x ACK

					fSamplePos += fSamplesPerBit;						
					nTmp = IsSet(HWInfo, cBuffer,CanCfg.nChannelData, (int)fSamplePos);
					if (nTmp == -1)
					{
						free(msg);
						return 0;
					}

					fSamplePos += fSamplesPerBit;						
					nTmp = IsSet(HWInfo, cBuffer,CanCfg.nChannelData, (int)fSamplePos);
					if (nTmp == -1)
					{
						free(msg);
						return 0;
					}
					//7 Bit EOF (High, ohne Bitstuffing)
					for (i=0;i<7;i++)
					{
						fSamplePos += fSamplesPerBit;						
						nTmp = IsSet(HWInfo, cBuffer,CanCfg.nChannelData, (int)fSamplePos);
						if (nTmp == -1)
						{
							free(msg);
							return 0;
						}

						if (nTmp != 1)
						{
							#ifdef DebugMode
								sprintf(msg, "         ConvertCAN2();End-Of-Frame[%d] nicht korrekt.\n", i+1);	
								PrintDebug(msg);
							#endif
						}

					}


					//3 Bit IFS (High)

					for (i=0;i<3;i++)
					{
						fSamplePos += fSamplesPerBit;						
						nTmp = IsSet(HWInfo, cBuffer,CanCfg.nChannelData, (int)fSamplePos);
						if (nTmp == -1)
						{
							free(msg);
							return 0;
						}

						if (nTmp != 1)
						{
							#ifdef DebugMode
								sprintf(msg, "         ConvertCAN2();Inter-Frame-Space nicht korrekt.\n");	
								PrintDebug(msg);
							#endif
						}

					}

					} // bStuffError

					//Pakete hinzufgen
					if (bStuffError == false)
					{

						if (bCRCError)
						{
							strncpy(dIdent.cStr, "CRC-Error\0",10);
							dIdent.nValue = 0;
							dIdent.cText = 0;
							dIdent.nLength = (long)fSamplePos - dIdent.nStart;
							//dIdent.nLength = (long)(fSamplesPerBit * 10.0f);
							(*dList) = LL_DataAdd((*dList), dIdent);
						}
						else
						{

							char cStr[33];

							strncpy(cStr, dIdent.cStr, 33);
							strncpy(dIdent.cStr, "ID: ", 33);
							strncat(dIdent.cStr, cStr, 33);
							if (bRTR)
								strncat(dIdent.cStr, " - RTR", 33);
							(*dList) = LL_DataAdd((*dList), dIdent);

							for (int i=0;i<cNumData;i++)
							{
								strncpy(cStr, dData[i].cStr, 33);
								strncpy(dData[i].cStr, "D: ", 33);
								strncat(dData[i].cStr, cStr, 33);
								(*dList) = LL_DataAdd((*dList), dData[i]);
							}

							if (CanCfg.cDetail == 2)
							{
								strncpy(cStr, dCRC.cStr, 33);
								strncpy(dCRC.cStr, "CRC: ", 33);
								strncat(dCRC.cStr, cStr, 33);
								(*dList) = LL_DataAdd((*dList), dCRC);
							}
						}
					}
					else
					{
						strncpy(dIdent.cStr, "Error\0",7);
						dIdent.nValue = 0;
						dIdent.cText = 0;
						dIdent.nLength = (long)fSamplePos - dIdent.nStart-2;
						//dIdent.nLength = (long)(fSamplesPerBit * 10.0f);
						(*dList) = LL_DataAdd((*dList), dIdent);
					}

					if (bStuffError || bCRCError)
					{
						int nCount = 0;
						//warte auf 5 high-Signale
						while (nCount < 5)
						{
							fSamplePos += fSamplesPerBit;						
							nTmp = IsSet(HWInfo, cBuffer,CanCfg.nChannelData, (int)fSamplePos);
							if (nTmp == -1)
							{
								free(msg);
								return 0;
							}

							if (nTmp == 1)
								nCount++;
							else
								nCount = 0;

						}

					}


		}

			fSamplePos += 1.0f;
	}


	free(msg);

	return 0;
}



void CrcSetBit(unsigned char *data, int nPos, int nVal)
{
	int nByte = 0;
	int nBit = 0;

	nByte = (int)(nPos/8);
	nBit = nPos%8;
	if (nVal == 1)
	{
		data[nByte] |= (0x01 << (7-nBit)); 
	}

}


unsigned int calcCRC(unsigned char *ptr, unsigned int count)
{
    if (ptr == NULL)
        return 0;

    int nGen[16] = {1,1,0,0,0,1,0,1,        // x^15 + x^14 + x^10 + x^8
                    1,0,0,1,1,0,0,1};        //+x^7 + x^4 + x^3 + x^0

    short A[16];
    unsigned int nCRC = 0;
    int *nFrame, nPos, i;

    // An den Frame werden spter 15 "0"en angehngt
    nFrame = (int*)malloc(sizeof(int) * (count + 15));
    if (nFrame == NULL)
        return 0;

	char *msg;	
	msg = (char*)malloc(sizeof(char)*1000);


	if (count < 18)
	{
		#ifdef DebugMode
			sprintf(msg, "               Fehler: calcCRC\n");	
			PrintDebug(msg);
		#endif
		return 0;
	}


    //*ptr nach nFrame kopieren!
    for (i=0;i<(int)count;i++)
    {
        int nByte = i / 8;
        int nBit = i%8;
        if ((ptr[nByte] & (1 << 7-nBit)) != 0)
            nFrame[i] = 1;
        else
            nFrame[i] = 0;
    }

    //15 Nullen anhngen
    for (i=0;i<15;i++)
        nFrame[count+i] = 0;

    //die ersten Nullen mssen entfernt werden
    while(nFrame[0] == 0)
    {
        for (i=0;i<count+15;i++)
            nFrame[i] = nFrame[i+1];
        count--;
    }


    nPos = 16;
    for ( i=0; i<16; i++)
        A[i] = nFrame[i];

    while(1)
    {
        if (A[0] == 1)
            for (i=0;i<16;i++)
                A[i] = A[i] ^ nGen[i];

        //'links Shift' um 1 Stelle
        for (i=0;i<15;i++)
            A[i] = A[i+1];

        if (nPos == (count+15))
            break;

        A[15] = nFrame[nPos];
        nPos++;
    }

    free(nFrame);

    for (i=0;i<14;i++)
    {
        nCRC = nCRC | A[i];
        nCRC = nCRC << 1;
    }
    nCRC = nCRC | A[15];
    return nCRC;
}

