#include "convertRS232.h"

int ConvertRS232(LA_HWInfo HWInfo,LA_Configuration LAConf, int nChannel, 
				 RS232Config RsCfg, unsigned char *cBuffer,
				 LL_DataNode **dList)
{

	
	bool bExtendedDebug = false;

	char *msg;	
	msg = (char*)malloc(sizeof(char)*1000);

	if (bExtendedDebug)
	{
		#ifdef DebugMode
			sprintf(msg, "         ConvertRS232(); Begin \n");	
			PrintDebug(msg);
		#endif
	}

	//Fehlerabfragen

	if ((HWInfo.bytes_per_sample*8) < HWInfo.channel_max) 
	{
		#ifdef DebugMode
			sprintf(msg, "                     (bytesPerSample*8) < ChannelMax\n");	
			PrintDebug(msg);
		#endif
		
		free(msg);
		return 1;
	}


	float	TBaud,TSample;
	unsigned int nSamplesPerBit;
	float fSamplesPerBit;

	if (RsCfg.nBaud == 0)
	{
		#ifdef DebugMode
			sprintf(msg, "                      RS232 Baud == 0\n");	
			PrintDebug(msg);
		#endif
		free(msg);
		return 1;
	}

	fSamplesPerBit = (float)LAConf.sample_clock / (float)RsCfg.nBaud;
	nSamplesPerBit = (int)(LAConf.sample_clock / RsCfg.nBaud);
	
	if (fSamplesPerBit < 2.0)
	{
		#ifdef DebugMode
			sprintf(msg, "         ConvertRS232(); *** ACHTUNG: Abtastrate zu gering! \n");	
			PrintDebug(msg);
		#endif
	}
	if (fSamplesPerBit > 2.0 && fSamplesPerBit < 2.5)
	{
		#ifdef DebugMode
			sprintf(msg, "         ConvertRS232(); *** ACHTUNG: Abtastrate  sollte hher gewhlt werden! \n");	
			PrintDebug(msg);
		#endif
	}


	ULONG nSamplePos;
	double fSamplePos; 
	int nParity;
	int nParityCount;
	float fStopBits;

	nParity = RsCfg.nParityBit;
	fStopBits = RsCfg.fNumStopBits;

	ULONG nStart;
	int nBitCount;
	int nTmp;
	bool bRead;
	bRead = false;
	nBitCount = 0;
	nSamplePos = 0;
	fSamplePos = 0.0;
	sData Data;


//	if (bExtendedDebug)
//	{
		#ifdef DebugMode
			sprintf(msg, "         ConvertRS232(); analyse \n");	
			PrintDebug(msg);

			sprintf(msg, "                        Baud: %d; NumBits: %d Stopbits: %f\n", RsCfg.nBaud, RsCfg.nNumBits, RsCfg.fNumStopBits);	
			PrintDebug(msg);
			sprintf(msg, "                        SamplesPerBit: %d ( %f)\n", nSamplesPerBit, fSamplesPerBit);	
			PrintDebug(msg);
		#endif
//	}

//!!!!
	while ((int)fSamplePos < (HWInfo.samples_max-(int)fSamplesPerBit))
	{
//!!!!
		nTmp = IsSet(HWInfo,cBuffer,RsCfg.nChannelData, (int)fSamplePos);
		if (nTmp == -1)
		{
			free(msg);
			return 0;
		}
		//erstes Start-Bit:
		if (!nTmp && bRead == false)
		{

			if (bExtendedDebug)
			{
				#ifdef DebugMode
//!!!!
					sprintf(msg, "         ConvertRS232(); DataStart (%f) \n", fSamplePos);	
					PrintDebug(msg);
				#endif
			}
			
//!!!
			nStart = (int)fSamplePos;
			nSamplePos = (int)fSamplePos;
			bRead = true;



			Data.cText		= 0;
			Data.cColor		= 0;
			Data.cType		= RsCfg.cType;
			Data.cChannel	= nChannel;
			Data.nValue		= 0;
			Data.nStart		= nStart;

//!!!!!
			fSamplePos += (fSamplesPerBit / 2.0f);

			//Ist noch genug Platz?
//!!!!!
			if ((int)fSamplePos+(RsCfg.nNumBits+3)*(int)fSamplesPerBit < HWInfo.samples_max)
			{
				//Datenbits durchlaufen!:

					if (bExtendedDebug)
					{
						#ifdef DebugMode
							sprintf(msg, "         ConvertRS232(); Datenbits durchlaufen\n");	
							PrintDebug(msg);
						#endif
					}

					nParityCount = 0;
					for (int i=0;i<RsCfg.nNumBits;i++)
					{

//!!!!!
						fSamplePos += fSamplesPerBit;
						nTmp = IsSet(HWInfo, cBuffer,RsCfg.nChannelData, (int)fSamplePos);
						if (nTmp == -1)
						{
							free(msg);
							return 0;
						}

						
						if (nTmp)
						{

							Data.nValue += potentiate(2,i);

							Data.cStr[i] = '1';

							if (bExtendedDebug)
							{
								#ifdef DebugMode
//!!!!
									sprintf(msg, " [RS232] %d. Bit: %d - (Pos: %f)\n",i+1, nTmp, fSamplePos);	
									PrintDebug(msg);
								#endif
							}
							nParityCount++;
						}	
						else
						{
							Data.cStr[i] = '0';

							if (bExtendedDebug)
							{
								#ifdef DebugMode
//!!!!
									sprintf(msg, " [RS232] %d. Bit: 0 - (Pos: %f)\n",i+1,fSamplePos);	
									PrintDebug(msg);
								#endif
							}
						}
					}

				//ParittsBit
					if (nParity != PAR_NONE)
					{
						bool bSet = false;
						switch(nParity)
						{
						case PAR_ODD:
							if (nParityCount%2 == 0)
								bSet = true;
							break;
						case PAR_EVEN:
							if (nParityCount%2 != 0)
								bSet = true;
							break;
						case PAR_MARK:
							bSet = true;
							break;
						case PAR_SPACE:
							bSet = false;
							break;
						}
//!!!!
						fSamplePos += fSamplesPerBit;
//!!!!
						if (IsSet(HWInfo, cBuffer,RsCfg.nChannelData, fSamplePos) == bSet)
						{
							if (bExtendedDebug)
							{
								#ifdef DebugMode
									sprintf(msg, " [RS232] Parittsbit korrekt (Pos %f)\n", fSamplePos);	
									PrintDebug(msg);
								#endif
							}
						}
						else
						{
							Data.cText = 1;
							
							if (bExtendedDebug)
							{
								#ifdef DebugMode
									sprintf(msg, "         ConvertRS232(); Parittsbit falsch (Pos %f)\n",fSamplePos);	
									PrintDebug(msg);
								#endif
							}
						}

					}
				//StopBits
					
					
//!!!!!
					fSamplePos += fSamplesPerBit;
					if (IsSet(HWInfo, cBuffer,RsCfg.nChannelData, fSamplePos))
					{					
						if (bExtendedDebug)
						{
							#ifdef DebugMode
								sprintf(msg, " [RS232] 1. Stopbit OK.(Pos: %f)\n", fSamplePos);	
								PrintDebug(msg);
							#endif				
						}
					}
					else
					{
						Data.cText = 1;
						if (bExtendedDebug)
						{
							#ifdef DebugMode
								sprintf(msg, " [RS232] 1. Stopbit Falsch.(Pos: %f)\n", fSamplePos);	
								PrintDebug(msg);
							#endif				
						}
					}

					if (RsCfg.fNumStopBits == 1.5f)
					{
//!!!!!
						fSamplePos += (fSamplesPerBit/4.0f)*3.0f;
						if (IsSet(HWInfo, cBuffer,RsCfg.nChannelData, fSamplePos))
						{
							if (bExtendedDebug)
							{
								#ifdef DebugMode
									sprintf(msg, " [RS232] 1.5. Stopbit OK.(Pos: %f)\n",fSamplePos);	
									PrintDebug(msg);
								#endif				
							}			
						}
						else
						{
							Data.cText = 1;
							if (bExtendedDebug)
							{
								#ifdef DebugMode
									sprintf(msg, " [RS232] 1.5. Stopbit FALSCH.(Pos: %f)\n", fSamplePos);	
									PrintDebug(msg);
								#endif				
							}
						}
					}



					if (RsCfg.fNumStopBits == 2.0f)
					{
//!!!!!
						fSamplePos += fSamplesPerBit;
						if (IsSet(HWInfo, cBuffer,RsCfg.nChannelData, fSamplePos))
						{
							if (bExtendedDebug)
							{
								#ifdef DebugMode
									sprintf(msg, " [RS232] 2. Stopbit OK.(Pos: %f)\n",fSamplePos);	
									PrintDebug(msg);
								#endif				
							}			
						}
						else
						{
							Data.cText = 1;
							if (bExtendedDebug)
							{
								#ifdef DebugMode
									sprintf(msg, " [RS232] 2. Stopbit FALSCH.\n");	
									PrintDebug(msg);
								#endif				
							}
						}
					}

					//Datenwort abgeschlossen

					if (bExtendedDebug)
					{
						#ifdef DebugMode
							sprintf(msg, "         ConvertRS232(); Datenwort hinzufgen\n");	
							PrintDebug(msg);
						#endif
					}

					if (RsCfg.fNumStopBits != 1.5f)
						Data.nLength = (fSamplePos + (fSamplesPerBit / 2.0f)) - Data.nStart;
					else
					{	//Bei 1.5 Stop-Bits nur 1/4 SamplesPerBit addirern
						Data.nLength = (fSamplePos + (fSamplesPerBit / 4.0f)) - Data.nStart;
					}


				switch (RsCfg.cType)
				{
				case TYPE_DEZ:
					itoa(Data.nValue, Data.cStr, 10);
					break;
				case TYPE_HEX:
					itoa(Data.nValue, Data.cStr, 16);
					break;
				case TYPE_BIN:
					//Str ist schon binr! noch Terminieren:
					Data.cStr[RsCfg.nNumBits] = '\0';
					break;
				case TYPE_ASC:

					if (Data.nValue > 255)
						strncpy(Data.cStr,"Error: ASCII 8Bit",30);
					else
					{
						Data.cStr[0] = (char)Data.nValue;
						Data.cStr[1] = '\0';
					}
					break;
				default:
					sprintf(Data.cStr,"Fehler");
				}


					(*dList) = LL_DataAdd((*dList), Data);

				//	if (bExtendedDebug)
					{
						#ifdef DebugMode
							sprintf(msg, " [RS232](Data) Wert: %d; Start: %d; Length: %d Text: %d Anzeioge: %s\n",
											Data.nValue, Data.nStart, Data.nLength, Data.cText, Data.cStr );	
							PrintDebug(msg);
						#endif	
					}

					bRead = false;
				

				
			}
			else
			{
				//bereits zu weit am Ende!
					if (bExtendedDebug)
					{
						#ifdef DebugMode
							sprintf(msg, "         ConvertRS232(); kein Platz fr weiteres Datenwort\n");	
							PrintDebug(msg);
						#endif
					}
			}

		}

		/*
		if (nSamplePos > t2 )
		{
			#ifdef DebugMode
				sprintf(msg, "         Stopp der Analyse()\n");	
				PrintDebug(msg);
			#endif
			break;
		}
		*/
		fSamplePos+= 1.0;
	}

	if (bExtendedDebug)
	{
		#ifdef DebugMode
			sprintf(msg, "         ConvertRS232(); End \n");	
			PrintDebug(msg);
		#endif
	}

	free(msg);

	return 0;
}
