#include "BitOperations.h"




////////////////////////////////////////////////////////////////////////
// Grundlegende Bit-Operationen:
//		- IsSet
//		- SetBit
////////////////////////////////////////////////////////////////////////


	int IsSet(const LA_HWInfo HWInfo,unsigned char *buf, 
				ULONG nChannel, ULONG nSample)
	{

		ULONG nPos;

		nPos = (ULONG)(nChannel/8);

		if (nPos > HWInfo.samples_max)
			return -1;

		if (nSample > HWInfo.samples_max)
			return -1;

		return (bool)(buf[nPos+(nSample*HWInfo.bytes_per_sample)] & (1 << nChannel%8));
	}


	int SetBit(const LA_HWInfo HWInfo,unsigned char *buf, 
				ULONG nChannel, ULONG nSample, bool bit)
	{
		//Unzulssige Angaben!
		
			if (nChannel > HWInfo.channel_max)
				return -1;

			if (nSample > HWInfo.samples_max)
				return -1;

			if (buf == NULL)
				return -1;


			//1 Byte enthlt 8 Kanle
			//1. Kanal -> niedrigstes Bit

		// Bit setzen
			ULONG nPos;



			//Pos. des entsprechenden Bytes:
			nPos = (ULONG)(nChannel/8);

			if (bit) //Bit setzen
				buf[nPos+(nSample*HWInfo.bytes_per_sample)] |= (1 << nChannel%8);
			else //Bit lschen
				buf[nPos+(nSample*HWInfo.bytes_per_sample)] &= 255-(1 << nChannel%8);


			// Bit Setzen: Oder-Verknpfung:  10101010
			//                              | 00000100 
			//                                10101110

			//Bit lschen: Und Verknpfung:   10101010
			//                              | 11111101 
			//                                10101000
			return 0;
	}


unsigned long potentiate(unsigned int nBase, unsigned int nExp)
{
	unsigned long n = nBase;

	if (nExp == 0)
		return 1;

	for (unsigned int i=0;i<(nExp-1);i++)
		n *= nBase;
	return n;
}