/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.poifs.dev;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Iterator;
import org.apache.poi.poifs.filesystem.DirectoryEntry;
import org.apache.poi.poifs.filesystem.DirectoryNode;
import org.apache.poi.poifs.filesystem.DocumentInputStream;
import org.apache.poi.poifs.filesystem.DocumentNode;
import org.apache.poi.poifs.filesystem.Entry;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;

public class POIFSDump {
    public static void main(String[] args) throws Exception {
        for (int i = 0; i < args.length; ++i) {
            System.out.println("Dumping " + args[i]);
            FileInputStream is = new FileInputStream(args[i]);
            POIFSFileSystem fs = new POIFSFileSystem(is);
            is.close();
            DirectoryNode root = fs.getRoot();
            File file2 = new File(root.getName());
            file2.mkdir();
            POIFSDump.dump(root, file2);
        }
    }

    public static void dump(DirectoryEntry root, File parent) throws IOException {
        Iterator<Entry> it = root.getEntries();
        while (it.hasNext()) {
            Entry entry = it.next();
            if (entry instanceof DocumentNode) {
                DocumentNode node = (DocumentNode)entry;
                DocumentInputStream is = new DocumentInputStream(node);
                byte[] bytes = new byte[node.getSize()];
                is.read(bytes);
                is.close();
                FileOutputStream out = new FileOutputStream(new File(parent, node.getName().trim()));
                out.write(bytes);
                out.close();
                continue;
            }
            if (entry instanceof DirectoryEntry) {
                DirectoryEntry dir = (DirectoryEntry)entry;
                File file2 = new File(parent, entry.getName());
                file2.mkdir();
                POIFSDump.dump(dir, file2);
                continue;
            }
            System.err.println("Skipping unsupported POIFS entry: " + entry);
        }
    }
}

