/*
 * Decompiled with CFR 0.152.
 */
package ananas.lib.util;

public class SHA1Value {
    private static final int s_byte_array_size = 20;
    private final byte[] mBytes;

    public static void main(String[] arg) {
        SHA1Value sv1 = new SHA1Value();
        System.out.println(sv1 + " int hash:" + sv1.hashCode());
        SHA1Value sv0 = new SHA1Value("4a18e7705fd76219883167cade0fa57753c36d36");
        System.out.println(sv0);
        SHA1Value sv12 = new SHA1Value(sv0);
        System.out.println(sv12 + " int hash:" + sv12.hashCode());
        byte[] buff = sv0.getBytes();
        SHA1Value sv13 = new SHA1Value(buff, 0, buff.length);
        System.out.println(sv13 + " int hash:" + sv13.hashCode());
        sv12 = new SHA1Value(sv0.toString());
        System.out.println(String.valueOf(sv12.toString(true)) + " int hash:" + sv12.hashCode());
    }

    public SHA1Value() {
        this.mBytes = new byte[20];
    }

    public SHA1Value(SHA1Value other) {
        this.mBytes = other.mBytes;
    }

    public SHA1Value(String s) throws NumberFormatException {
        int strlen = s.length();
        if (strlen != 40) {
            throw new NumberFormatException("not a sha-1 string");
        }
        this.mBytes = new byte[20];
        int i = this.mBytes.length - 1;
        while (i >= 0) {
            byte b;
            int ix2 = i * 2;
            char ch0 = s.charAt(ix2);
            char ch1 = s.charAt(ix2 + 1);
            int n0 = MyHelper.charToInt(ch0);
            int n1 = MyHelper.charToInt(ch1);
            this.mBytes[i] = b = (byte)(n0 * 16 + n1);
            --i;
        }
    }

    public SHA1Value(byte[] buff, int off, int len) throws NumberFormatException {
        if (len != 20) {
            throw new NumberFormatException("not a sha-1 bytes array");
        }
        this.mBytes = new byte[len];
        int i = len - 1;
        while (i >= 0) {
            this.mBytes[i] = buff[off + i];
            --i;
        }
    }

    public String toString(boolean upcase) {
        char[] array = MyHelper.getNumCharArray(upcase);
        StringBuilder sb = new StringBuilder();
        byte[] byArray = this.mBytes;
        int n = this.mBytes.length;
        int n2 = 0;
        while (n2 < n) {
            byte b = byArray[n2];
            int n3 = b & 0xFF;
            sb.append(array[0xF & n3 >> 4]);
            sb.append(array[0xF & n3]);
            ++n2;
        }
        return sb.toString();
    }

    public String toString() {
        return this.toString(false);
    }

    public byte[] getBytes() {
        return this.getBytes(null);
    }

    public byte[] getBytes(byte[] buff) {
        if (buff == null) {
            buff = new byte[this.mBytes.length];
        } else if (buff.length != this.mBytes.length) {
            buff = new byte[this.mBytes.length];
        }
        int i = buff.length - 1;
        while (i >= 0) {
            buff[i] = this.mBytes[i];
            --i;
        }
        return buff;
    }

    protected Object clone() throws CloneNotSupportedException {
        return this;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof SHA1Value) {
            SHA1Value o2 = (SHA1Value)obj;
            byte[] buff2 = o2.mBytes;
            byte[] buff1 = this.mBytes;
            int i = buff1.length - 1;
            while (i >= 0) {
                if (buff2[i] != buff1[i]) {
                    return false;
                }
                --i;
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        int n3 = 0;
        int n2 = 0;
        int n1 = 0;
        int n0 = 0;
        int i = this.mBytes.length - 4;
        while (i >= 0) {
            n0 ^= this.mBytes[i];
            n1 ^= this.mBytes[i + 1];
            n2 ^= this.mBytes[i + 2];
            n3 ^= this.mBytes[i + 3];
            i -= 4;
        }
        int n = n0 << 24 & 0xFF000000 | n1 << 16 & 0xFF0000 | n2 << 8 & 0xFF00 | n3 & 0xFF;
        return n;
    }

    private static final class MyHelper {
        private static char[] s_num_char_array_up = null;
        private static char[] s_num_char_array_low = null;

        private MyHelper() {
        }

        public static char[] getNumCharArray(boolean upcase) {
            if (upcase) {
                char[] array = s_num_char_array_up;
                if (array == null) {
                    s_num_char_array_up = array = "0123456789ABCDEF".toCharArray();
                }
                return array;
            }
            char[] array = s_num_char_array_low;
            if (array == null) {
                s_num_char_array_low = array = "0123456789abcdef".toCharArray();
            }
            return array;
        }

        public static int charToInt(char ch) {
            if ('0' <= ch && ch <= '9') {
                return ch - 48;
            }
            if ('a' <= ch && ch <= 'f') {
                return ch - 97 + 10;
            }
            if ('A' <= ch && ch <= 'F') {
                return ch - 65 + 10;
            }
            throw new NumberFormatException("not a sha-1 string");
        }
    }
}

