/*
 * Decompiled with CFR 0.152.
 */
package ananas.lib.io.impl;

import ananas.lib.io.Connection;
import ananas.lib.io.ConnectionFactory;
import ananas.lib.io.ContentConnection;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;

public class DefaultFileConnection
implements ContentConnection {
    private InputStream mIn;
    private final File mFile;

    public DefaultFileConnection(URI uri) {
        this.mFile = new File(uri.getPath());
    }

    public static ConnectionFactory getFactory() {
        return new ConnectionFactory(){

            @Override
            public Connection openConnection(URI uri) throws IOException {
                DefaultFileConnection conn = new DefaultFileConnection(uri);
                return conn;
            }
        };
    }

    @Override
    public void close() throws IOException {
        InputStream in = this.mIn;
        if (in != null) {
            in.close();
        }
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        return null;
    }

    @Override
    public InputStream getInputStream() throws IOException {
        InputStream in = this.mIn;
        if (in == null) {
            this.mIn = in = new FileInputStream(this.mFile);
        }
        return in;
    }

    @Override
    public String getType() {
        return null;
    }

    @Override
    public long getLength() {
        return this.mFile.length();
    }

    @Override
    public String getEncoding() {
        return null;
    }
}

