/*
 * Decompiled with CFR 0.152.
 */
package ananas.lib.io.impl;

import ananas.lib.io.Connection;
import ananas.lib.io.ConnectionFactory;
import ananas.lib.io.ConnectionFactoryRegistrar;
import ananas.lib.io.Connector;
import ananas.lib.io.impl.DefaultFileConnection;
import ananas.lib.io.impl.DefaultResourceConnection;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;

class DefaultConnectorImpl
implements Connector {
    private final ConnectionFactoryRegistrar mReg = new MyConnFactoryRegistrar();

    public DefaultConnectorImpl() {
        this._initDefaultFactories();
    }

    private void _initDefaultFactories() {
        this.getConnectionFactoryRegistrar().registerFactory(URI.create("resource:///"), DefaultResourceConnection.getFactory());
        this.getConnectionFactoryRegistrar().registerFactory(URI.create("file:///"), DefaultFileConnection.getFactory());
    }

    @Override
    public Connection open(String uri) throws IOException {
        URI aURI = URI.create(uri);
        ConnectionFactory factory = this.mReg.getFactory(aURI);
        if (factory == null) {
            throw new IOException("no factory for uri : " + uri);
        }
        return factory.openConnection(aURI);
    }

    @Override
    public ConnectionFactoryRegistrar getConnectionFactoryRegistrar() {
        return this.mReg;
    }

    static class FactoryTableItem {
        private final ConnectionFactory mFactory;
        private final URI mURI;

        public FactoryTableItem(URI uri, ConnectionFactory factory) {
            this.mURI = uri;
            this.mFactory = factory;
        }

        public ConnectionFactory getFactory() {
            return this.mFactory;
        }

        public URI getURI() {
            return this.mURI;
        }
    }

    private class MyConnFactoryRegistrar
    implements ConnectionFactoryRegistrar {
        private final HashMap<String, FactoryTableItem> mFactoryTable = new HashMap();
        public static final int SCHEME = 8;
        public static final int HOST = 4;
        public static final int PORT = 2;
        public static final int PATH = 1;

        @Override
        public void registerFactory(URI uri, ConnectionFactory factory) {
            String key = this._calcKeyString(uri, 15);
            FactoryTableItem item = new FactoryTableItem(uri, factory);
            this.mFactoryTable.put(key, item);
        }

        @Override
        public ConnectionFactory getFactory(URI uri) {
            FactoryTableItem item = this._getItem(uri);
            if (item == null) {
                return null;
            }
            return item.getFactory();
        }

        private FactoryTableItem _getItem(URI uri) {
            String key = this._calcKeyString(uri, 15);
            FactoryTableItem factory = this.mFactoryTable.get(key);
            if (factory != null) {
                return factory;
            }
            key = this._calcKeyString(uri, 14);
            factory = this.mFactoryTable.get(key);
            if (factory != null) {
                return factory;
            }
            key = this._calcKeyString(uri, 12);
            factory = this.mFactoryTable.get(key);
            if (factory != null) {
                return factory;
            }
            key = this._calcKeyString(uri, 8);
            factory = this.mFactoryTable.get(key);
            if (factory != null) {
                return factory;
            }
            key = this._calcKeyString(uri, 0);
            factory = this.mFactoryTable.get(key);
            return factory;
        }

        private String _calcKeyString(URI uri, int mode) {
            String scheme = uri.getScheme();
            String host = uri.getHost();
            int portInt = uri.getPort();
            String port = portInt < 0 ? null : "" + portInt;
            String path = uri.getPath();
            if (host != null && host.length() < 1) {
                host = null;
            }
            if (path != null && path.length() <= 1) {
                path = null;
            }
            if ((mode & 8) == 0) {
                scheme = null;
            }
            if ((mode & 4) == 0) {
                host = null;
            }
            if ((mode & 2) == 0) {
                port = null;
            }
            if ((mode & 1) == 0) {
                path = null;
            }
            return "[" + scheme + host + port + path + "]";
        }

        @Override
        public void printItems() {
            System.out.println(this + ".items:");
            List<URI> items = this.listItems();
            for (URI item : items) {
                System.out.println("    " + item);
            }
        }

        @Override
        public List<URI> listItems() {
            ArrayList<URI> list = new ArrayList<URI>();
            Collection<FactoryTableItem> items = this.mFactoryTable.values();
            for (FactoryTableItem item : items) {
                list.add(item.getURI());
            }
            return list;
        }
    }
}

