/*
 * Decompiled with CFR 0.152.
 */
package ananas.lib.blueprint2.tools;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.Set;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class ResourceIdGen {
    private HashMap<String, String> mParamTable;
    private String mAcceptFile;
    private File mBaseDir;
    private String mAcceptAttr;
    public static final String p_base_dir = "-base-dir";
    public static final String p_res_dir = "-res-dir";
    public static final String p_gen_dir = "-gen-dir";
    public static final String p_r_class = "-R-class";
    public static final String p_accept_file = "-accept-file";
    public static final String p_accept_attr = "-accept-attr";

    public static void main(String[] arg) {
        ResourceIdGen gen = new ResourceIdGen();
        gen.parseCommandLine(arg);
        gen.run();
    }

    private ResourceIdGen() {
    }

    private void parseCommandLine(String[] arg) {
        HashMap<String, String> table = new HashMap<String, String>();
        String key = "";
        String[] stringArray = arg;
        int n = arg.length;
        int n2 = 0;
        while (n2 < n) {
            String str = stringArray[n2];
            if ((str = str.trim()).startsWith("-")) {
                key = str;
            } else {
                System.out.println("'" + key + "':'" + str + "'");
                table.put(key, str);
            }
            ++n2;
        }
        this.mParamTable = table;
    }

    private void run() {
        ResultSet rlt = new ResultSet();
        this.scanResDir(rlt);
        this.outputJava(rlt);
    }

    private void outputJava(ResultSet rlt) {
        System.out.println("write to java file");
        System.out.println("begin[");
        try {
            String baseDir = this.mParamTable.get(p_base_dir);
            String genDir = this.mParamTable.get(p_gen_dir);
            String rClass = this.mParamTable.get(p_r_class);
            String classPath = rClass.replace('.', '/');
            File file2 = new File(baseDir, String.valueOf(genDir) + "/" + classPath + ".java");
            file2.getParentFile().mkdirs();
            FileOutputStream os = new FileOutputStream(file2);
            rlt.writeToJavaFile(os, rClass);
            os.flush();
            ((OutputStream)os).close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.out.println();
        System.out.println("]eof");
    }

    private void scanResDir(ResultSet rlt) {
        File root;
        String baseDir = this.mParamTable.get(p_base_dir);
        String resDir = this.mParamTable.get(p_res_dir);
        this.mAcceptFile = this.mParamTable.get(p_accept_file);
        this.mAcceptAttr = this.mParamTable.get(p_accept_attr);
        this.mBaseDir = root = new File(baseDir, resDir);
        this._scanDir(root, rlt);
    }

    private void _scanDir(File dir, ResultSet rlt) {
        File[] files;
        if (!dir.isDirectory()) {
            return;
        }
        File[] fileArray = files = dir.listFiles();
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File file2 = fileArray[n2];
            if (file2.isDirectory()) {
                this._scanDir(file2, rlt);
            } else {
                this._scanFile(file2, rlt);
            }
            ++n2;
        }
    }

    private void _scanFile(File file2, ResultSet rlt) {
        System.out.print("scan " + file2.getAbsolutePath());
        String exName = null;
        String name = file2.getName();
        int index = name.lastIndexOf(46);
        String string = exName = index >= 0 ? name.substring(index) : "";
        if (this.mAcceptFile.indexOf(exName) < 0) {
            System.out.println(" [skip]");
            return;
        }
        System.out.println(" [done]");
        String p1 = file2.getAbsolutePath();
        String p2 = this.mBaseDir.getAbsolutePath();
        String p3 = p1.substring(p2.length());
        p3 = p3.replace('\\', '/');
        String namespace = "filename";
        String type = "file";
        String key = file2.getName();
        String value = "resource://" + p3;
        rlt.add(namespace, type, key, value);
        if (exName.equalsIgnoreCase(".xml")) {
            this._scanFileContent(file2, rlt);
        }
    }

    private void _scanFileContent(File file2, ResultSet rlt) {
        try {
            MyXmlHandler h = new MyXmlHandler(file2, rlt);
            SAXParserFactory pf = SAXParserFactory.newInstance();
            pf.setNamespaceAware(true);
            SAXParser parser = pf.newSAXParser();
            parser.parse(file2, (DefaultHandler)h);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    class MyXmlHandler
    extends DefaultHandler {
        private File mFile;
        private ResultSet mResult;

        public MyXmlHandler(File file2, ResultSet rlt) {
            this.mFile = file2;
            this.mResult = rlt;
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attr) throws SAXException {
            String namespace = this.mFile.getAbsolutePath();
            int i = attr.getLength() - 1;
            while (i >= 0) {
                String name = attr.getLocalName(i);
                String value = attr.getValue(i);
                if (ResourceIdGen.this.mAcceptAttr.indexOf(name) >= 0) {
                    this.mResult.add(namespace, name, value, value);
                }
                --i;
            }
        }
    }

    static class ResultSet {
        final HashMap<String, ResultSetNamespace> mTableNS = new HashMap();
        final HashMap<String, ResultSetTypespace> mTableTS = new HashMap();

        public void writeToJavaFile(OutputStream os, String aClass) throws IOException {
            PrintStream out = new PrintStream(os, true, "utf-8");
            int index = aClass.lastIndexOf(46);
            String pkgName = aClass.substring(0, index);
            String className = aClass.substring(index + 1);
            out.println("package " + pkgName + ";");
            out.println("// This file is generate by {" + this + "} tool.");
            out.println("// Don't modify it !");
            out.println("class " + className + " {");
            Set<String> keys = this.mTableTS.keySet();
            for (String key : keys) {
                ResultSetTypespace typeSpace = this.mTableTS.get(key);
                String type = typeSpace.mName;
                out.println("    public static class " + type + " {");
                Set keys2 = typeSpace.mTableKV.keySet();
                for (String key2 : keys2) {
                    String value2 = (String)typeSpace.mTableKV.get(key2);
                    out.println("        public static final String " + key2 + " = \"" + value2 + "\";");
                }
                out.println("    }");
            }
            out.println("}");
            out.flush();
            os.flush();
        }

        public ResultSetNamespace getNS(String name) {
            ResultSetNamespace ns = this.mTableNS.get(name);
            if (ns == null) {
                ns = new ResultSetNamespace(name);
                this.mTableNS.put(name, ns);
            }
            return ns;
        }

        public ResultSetTypespace getTS(String name) {
            ResultSetTypespace ts = this.mTableTS.get(name);
            if (ts == null) {
                ts = new ResultSetTypespace(name);
                this.mTableTS.put(name, ts);
            }
            return ts;
        }

        private String _makeNameNormal(String name) {
            char[] ca = name.toCharArray();
            int i = ca.length - 1;
            while (i >= 0) {
                char ch = ca[i];
                if (ch <= '\u0000') {
                    ca[i] = 95;
                } else if (!('0' <= ch && ch <= '9' || 'a' <= ch && ch <= 'z')) {
                    ca[i] = 'A' <= ch && ch <= 'Z' ? (int)(ch - 65 + 97) : 95;
                }
                --i;
            }
            return new String(ca);
        }

        public void add(String namespace, String type, String key, String value) {
            namespace = this._makeNameNormal(namespace);
            type = this._makeNameNormal(type);
            key = this._makeNameNormal(key);
            ResultSetTypespace ts = this.getTS(type);
            ResultSetNamespace ns = this.getNS(namespace);
            ts.put(key, value);
            ns.put(key, value);
        }
    }

    static class ResultSetNamespace {
        private final String mName;
        private final HashMap<String, String> mTableKV;

        public ResultSetNamespace(String name) {
            this.mName = name;
            this.mTableKV = new HashMap();
        }

        public void put(String key, String value) {
            if (this.mTableKV.containsKey(key)) {
                System.err.println("warning : the resource is re-define");
                System.err.println("    namespace = " + this.mName);
                System.err.println("    key       = " + key);
                System.err.println("    value     = " + value);
            } else {
                System.out.println("info : res_namespace.put():" + this.mName + "#" + key + " = " + value);
            }
            this.mTableKV.put(key, value);
        }
    }

    static class ResultSetTypespace {
        private final String mName;
        private final HashMap<String, String> mTableKV;

        public ResultSetTypespace(String name) {
            this.mName = name;
            this.mTableKV = new HashMap();
        }

        public void put(String key, String value) {
            System.out.println("info : res_type.put():" + this.mName + "." + key + " = " + value);
            String v2 = this.mTableKV.get(key);
            if (v2 != null && !value.equals(v2)) {
                System.err.println("warning : the value is re-defined");
                System.err.println("    type   = " + this.mName);
                System.err.println("    key    = " + key);
                System.err.println("    value1 = " + v2);
                System.err.println("    value2 = " + value);
            }
            this.mTableKV.put(key, value);
        }
    }
}

