/*
 * Decompiled with CFR 0.152.
 */
package ananas.lib.blueprint2.swing_ex;

import ananas.lib.blueprint2.swing_ex.JDirectoryTreeNode;
import java.io.File;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Enumeration;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;

public class JDirectoryTree
extends JTree {
    private static final long serialVersionUID = -2236332669278609191L;
    private File mBasePath;
    static final MyTreeNode[] sEmptyNodeArray = new MyTreeNode[0];
    static final Comparator<? super MyTreeNode> sNodeComp = new Comparator<MyTreeNode>(){

        @Override
        public int compare(MyTreeNode arg0, MyTreeNode arg1) {
            File f0 = arg0.mFile;
            File f1 = arg1.mFile;
            if (f0.isDirectory() == f1.isDirectory()) {
                String s1 = f1.getName();
                String s0 = f0.getName();
                return s0.compareTo(s1);
            }
            return f0.isDirectory() ? -1 : 1;
        }
    };

    public JDirectoryTree() {
        this._init();
    }

    private void _init() {
        File basepath = File.listRoots()[0];
        this.setBasePath(basepath);
    }

    public File getBasePath() {
        return this.mBasePath;
    }

    public void setBasePath(File dir) {
        if (dir != null) {
            this.mBasePath = dir;
            MyTreeNode root = new MyTreeNode(dir, null);
            DefaultTreeModel model = new DefaultTreeModel(root);
            this.setModel(model);
        }
    }

    private class MyEnumeration
    implements Enumeration<MyTreeNode> {
        MyTreeNode[] mList;
        final int mLen;
        int mPtr = 0;

        public MyEnumeration(MyTreeNode[] chs) {
            this.mList = chs;
            this.mLen = chs.length;
        }

        @Override
        public boolean hasMoreElements() {
            return this.mPtr < this.mLen;
        }

        @Override
        public MyTreeNode nextElement() {
            return this.mList[this.mPtr++];
        }
    }

    private class MyTreeNode
    implements TreeNode,
    JDirectoryTreeNode {
        private final File mFile;
        private final MyTreeNode mParent;
        private MyTreeNode[] mChildren;

        public MyTreeNode(File file2, MyTreeNode parent) {
            this.mFile = file2;
            this.mParent = parent;
        }

        public Enumeration<MyTreeNode> children() {
            MyTreeNode[] chs = this._listChildren(true);
            return new MyEnumeration(chs);
        }

        @Override
        public boolean getAllowsChildren() {
            return this.mFile.isDirectory();
        }

        @Override
        public TreeNode getChildAt(int index) {
            MyTreeNode[] chs = this._listChildren(true);
            return chs[index];
        }

        private MyTreeNode[] _listChildren(boolean create) {
            MyTreeNode[] list = this.mChildren;
            if (list == null) {
                if (!this.mFile.isDirectory()) {
                    list = sEmptyNodeArray;
                } else {
                    File[] files = this.mFile.listFiles();
                    if (files == null) {
                        list = sEmptyNodeArray;
                    } else {
                        list = new MyTreeNode[files.length];
                        int i = files.length - 1;
                        while (i >= 0) {
                            list[i] = new MyTreeNode(files[i], this);
                            --i;
                        }
                        Comparator<? super MyTreeNode> comp = sNodeComp;
                        Arrays.sort(list, comp);
                    }
                }
                this.mChildren = list;
            }
            return list;
        }

        @Override
        public int getChildCount() {
            MyTreeNode[] chs = this._listChildren(true);
            return chs.length;
        }

        @Override
        public int getIndex(TreeNode node) {
            if (node == null) {
                return -1;
            }
            MyTreeNode[] chs = this._listChildren(true);
            int index = 0;
            MyTreeNode[] myTreeNodeArray = chs;
            int n = chs.length;
            int n2 = 0;
            while (n2 < n) {
                MyTreeNode ch = myTreeNodeArray[n2];
                if (node.equals(ch)) {
                    return index;
                }
                ++index;
                ++n2;
            }
            return -1;
        }

        @Override
        public TreeNode getParent() {
            return this.mParent;
        }

        @Override
        public boolean isLeaf() {
            return !this.mFile.isDirectory();
        }

        public String toString() {
            return this.mFile.getName();
        }

        @Override
        public File getFile() {
            return this.mFile;
        }
    }
}

