/*
 * Decompiled with CFR 0.152.
 */
package ananas.lib.blueprint2.swing;

import ananas.lib.blueprint2.dom.IAttr;
import ananas.lib.blueprint2.swing.JComponentWrapper;
import java.awt.Component;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JToolBar;

public class JToolBarWrapper
extends JComponentWrapper {
    private IAttr mFloatable;
    private IAttr m_attr_actionListener;

    @Override
    public boolean setAttribute(IAttr attr) {
        String name = attr.getBlueprintClass().getLocalName();
        if (name == null) {
            return false;
        }
        if (name.equals("actionListener")) {
            this.m_attr_actionListener = attr;
        } else if (name.equals("floatable")) {
            this.mFloatable = attr;
        } else {
            return super.setAttribute(attr);
        }
        return true;
    }

    @Override
    public void onTagEnd() {
        super.onTagEnd();
        JToolBar tb = (JToolBar)this.getTarget(true);
        if (this.mFloatable != null) {
            boolean b = this.booleanFromAttr(this.mFloatable);
            tb.setFloatable(b);
        }
        if (this.m_attr_actionListener != null) {
            String uri = this.m_attr_actionListener.getValue();
            ActionListener listener = (ActionListener)this.getOwnerDocument().findTargetByURI(uri);
            this._listenToolbar(listener);
        }
    }

    private void _listenToolbar(ActionListener listener) {
        JToolBar toolbar = (JToolBar)this.getTarget(true);
        int cnt = toolbar.getComponentCount();
        int i = 0;
        while (i < cnt) {
            Component comp = toolbar.getComponent(i);
            if (comp instanceof JButton) {
                JButton btn = (JButton)comp;
                btn.addActionListener(listener);
            }
            ++i;
        }
    }
}

