/*
 * Decompiled with CFR 0.152.
 */
package ananas.lib.blueprint2.swing;

import ananas.lib.blueprint2.dom.IAttr;
import ananas.lib.blueprint2.dom.INode;
import ananas.lib.blueprint2.dom.IText;
import ananas.lib.blueprint2.swing.JComponentWrapper;
import javax.swing.text.JTextComponent;

public class JTextComponentWrapper
extends JComponentWrapper {
    private StringBuilder mStringBuilder;
    private IAttr mText;
    private IAttr mEditable;

    @Override
    public boolean setAttribute(IAttr attr) {
        String name = attr.getBlueprintClass().getLocalName();
        if (name == null) {
            return false;
        }
        if (name.equals("editable")) {
            this.mEditable = attr;
        } else if (name.equals("text")) {
            this.mText = attr;
        } else {
            return super.setAttribute(attr);
        }
        return true;
    }

    @Override
    public boolean onAppendChild(INode child) {
        if (child instanceof IText) {
            this.appendText((IText)child);
            return true;
        }
        return super.onAppendChild(child);
    }

    private void appendText(IText txt) {
        String data = txt.getData();
        StringBuilder sb = this._getStringBuilder(true);
        if (sb.length() > 0) {
            sb.append(' ');
        }
        sb.append(data);
    }

    private StringBuilder _getStringBuilder(boolean create) {
        StringBuilder sb = this.mStringBuilder;
        if (sb == null && create) {
            this.mStringBuilder = sb = new StringBuilder();
        }
        return sb;
    }

    @Override
    public void onTagEnd() {
        super.onTagEnd();
        JTextComponent jtc = this.getJTextComponent(true);
        StringBuilder sb = this._getStringBuilder(false);
        if (sb != null) {
            String s = sb.toString();
            jtc.setText(s);
        }
    }

    @Override
    public void onTagBegin() {
        super.onTagBegin();
        JTextComponent jtc = this.getJTextComponent(true);
        if (this.mText != null) {
            String s = this.stringFromAttr(this.mText);
            jtc.setText(s);
        }
        if (this.mEditable != null) {
            boolean b = this.booleanFromAttr(this.mEditable);
            jtc.setEditable(b);
        }
    }

    public JTextComponent getJTextComponent(boolean create) {
        return (JTextComponent)this.getTarget(create);
    }
}

