/*
 * Decompiled with CFR 0.152.
 */
package ananas.lib.blueprint2.swing;

import ananas.lib.blueprint2.dom.IAttr;
import ananas.lib.blueprint2.swing.JComponentWrapper;
import java.awt.event.ActionListener;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;

public class JMenuBarWrapper
extends JComponentWrapper {
    private IAttr mAttrActionListener;

    @Override
    public boolean setAttribute(IAttr attr) {
        String name = attr.getBlueprintClass().getLocalName();
        if (name.equals("actionListener")) {
            this.mAttrActionListener = attr;
            return true;
        }
        return super.setAttribute(attr);
    }

    @Override
    public void onTagEnd() {
        super.onTagEnd();
        if (this.mAttrActionListener != null) {
            String uri = this.mAttrActionListener.getValue();
            ActionListener listener = (ActionListener)this.getOwnerDocument().findTargetByURI(uri);
            this._listenMenuTree(listener);
        }
    }

    private void _listenMenuTree(ActionListener listener) {
        JMenuBar menubar = (JMenuBar)this.getTarget(true);
        int cnt = menubar.getMenuCount();
        int i = 0;
        while (i < cnt) {
            JMenu menu = menubar.getMenu(i);
            this._listenMenuTree(listener, menu);
            ++i;
        }
    }

    private void _listenMenuTree(ActionListener listener, JMenu menu) {
        int cnt = menu.getItemCount();
        int i = cnt - 1;
        while (i >= 0) {
            JMenuItem item = menu.getItem(i);
            if (item != null) {
                if (item instanceof JMenu) {
                    JMenu menu2 = (JMenu)item;
                    this._listenMenuTree(listener, menu2);
                } else if (item instanceof JMenuItem) {
                    item.addActionListener(listener);
                }
            }
            --i;
        }
    }
}

