/*
 * Decompiled with CFR 0.152.
 */
package ananas.lib.blueprint2.swing;

import ananas.lib.blueprint2.dom.IAttr;
import ananas.lib.blueprint2.dom.INode;
import ananas.lib.blueprint2.dom.IText;
import ananas.lib.blueprint2.swing.IconWrapper;
import ananas.lib.blueprint2.swing.JComponentWrapper;
import javax.swing.Icon;
import javax.swing.JLabel;

public class JLabelWrapper
extends JComponentWrapper {
    private IAttr mText;
    private StringBuilder mStringBuilder;
    private String m_attr_horizontalAlignment;
    private String m_attr_verticalAlignment;
    private Icon mIcon;

    @Override
    public boolean setAttribute(IAttr attr) {
        String name = attr.getBlueprintClass().getLocalName();
        if (name == null) {
            return false;
        }
        if (name.equals("text")) {
            this.mText = attr;
        } else if (name.equals("horizontalAlignment")) {
            this.m_attr_horizontalAlignment = attr.getValue();
        } else if (name.equals("verticalAlignment")) {
            this.m_attr_verticalAlignment = attr.getValue();
        } else {
            return super.setAttribute(attr);
        }
        return true;
    }

    @Override
    public void onTagBegin() {
        super.onTagBegin();
        JLabel label = this.getJLabel(true);
        if (this.mText != null) {
            String s = this.stringFromAttr(this.mText);
            label.setText(s);
        }
    }

    private JLabel getJLabel(boolean create) {
        return (JLabel)this.getTarget(create);
    }

    @Override
    public boolean onAppendChild(INode child) {
        if (child instanceof IText) {
            this.appendText((IText)child);
            return true;
        }
        if (child instanceof IconWrapper) {
            this._setIcon((IconWrapper)((Object)child));
            return true;
        }
        return super.onAppendChild(child);
    }

    private void _setIcon(IconWrapper child) {
        Icon icon;
        this.mIcon = icon = child.getIcon();
    }

    private void appendText(IText txt) {
        String data = txt.getData();
        StringBuilder sb = this._getStringBuilder(true);
        if (sb.length() > 0) {
            sb.append(' ');
        }
        sb.append(data);
    }

    private StringBuilder _getStringBuilder(boolean create) {
        StringBuilder sb = this.mStringBuilder;
        if (sb == null && create) {
            this.mStringBuilder = sb = new StringBuilder();
        }
        return sb;
    }

    @Override
    public void onTagEnd() {
        int n;
        String str;
        super.onTagEnd();
        JLabel label = this.getJLabel(true);
        StringBuilder sb = this._getStringBuilder(false);
        if (sb != null) {
            String s = sb.toString();
            label.setText(s);
        }
        if (this.m_attr_horizontalAlignment != null) {
            str = this.m_attr_horizontalAlignment;
            n = str == null ? 0 : (str.equals("LEFT") ? 2 : (str.equals("CENTER") ? 0 : (str.equals("RIGHT") ? 4 : 0)));
            label.setHorizontalAlignment(n);
        }
        if (this.m_attr_verticalAlignment != null) {
            str = this.m_attr_verticalAlignment;
            n = str == null ? 0 : (str.equals("TOP") ? 1 : (str.equals("CENTER") ? 0 : (str.equals("BOTTOM") ? 3 : 0)));
            label.setVerticalAlignment(n);
        }
        if (this.mIcon != null) {
            label.setIcon(this.mIcon);
        }
    }
}

