/*
 * Decompiled with CFR 0.152.
 */
package ananas.lib.blueprint2.impl;

import ananas.lib.blueprint2.BlueprintException;
import ananas.lib.blueprint2.dom.IAttr;
import ananas.lib.blueprint2.dom.IDocument;
import ananas.lib.blueprint2.dom.IElement;
import ananas.lib.blueprint2.dom.IText;
import ananas.lib.blueprint2.dom.helper.IClass;
import ananas.lib.blueprint2.dom.helper.IImplementation;
import ananas.lib.blueprint2.dom.helper.INamespace;
import ananas.lib.blueprint2.impl.ImplText;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;

final class ImplDocument
implements IDocument {
    private final String mDocURI;
    private final IImplementation mImpl;
    private final Map<String, IElement> mElementTable;
    private IElement mRoot;

    public ImplDocument(String docURI, IImplementation impl) {
        this.mDocURI = docURI;
        this.mImpl = impl;
        this.mElementTable = new HashMap<String, IElement>();
    }

    @Override
    public boolean bindBlueprintClass(IClass aClass) {
        return false;
    }

    @Override
    public IClass getBlueprintClass() {
        return null;
    }

    @Override
    public IElement findElementById(String id2) {
        return this.mElementTable.get(id2);
    }

    @Override
    public Object findTargetById(String id2) {
        IElement element = this.findElementById(id2);
        if (element == null) {
            return null;
        }
        return element.getTarget();
    }

    @Override
    public void registerElement(IElement element) {
        String id2 = element.getId();
        if (id2 != null) {
            this.mElementTable.put(id2, element);
        }
    }

    @Override
    public IElement getRootElement() {
        return this.mRoot;
    }

    @Override
    public void setRootElement(IElement root) {
        this.mRoot = root;
    }

    @Override
    public IImplementation getImplementation() {
        return this.mImpl;
    }

    @Override
    public String getDocumentURI() {
        return this.mDocURI;
    }

    @Override
    public IAttr createAttribute(String uri, String localName) {
        try {
            INamespace ns = this.mImpl.getNamespaceRegistrar().getNamespace(uri);
            if (ns == null) {
                throw new BlueprintException("no namespace");
            }
            INamespace ar = ns;
            IClass cls = ar.findClass(null, localName);
            if (cls == null) {
                throw new BlueprintException("no class");
            }
            IAttr attr = (IAttr)this._safe_newInstance(cls.getWrapperClass());
            attr.bindBlueprintClass(cls);
            return attr;
        }
        catch (Exception e) {
            System.err.println("cannot create attribute:");
            System.err.println("          uri = " + uri);
            System.err.println("    localName = " + localName);
            throw new BlueprintException(e);
        }
    }

    private Object _safe_newInstance(Class<?> aClass) {
        try {
            return aClass.newInstance();
        }
        catch (Exception e) {
            throw new BlueprintException(e);
        }
    }

    @Override
    public IElement createElement(String uri, String localName) {
        try {
            INamespace ns;
            INamespace er = ns = this.mImpl.getNamespaceRegistrar().getNamespace(uri);
            if (ns == null) {
                throw new BlueprintException("no namespace");
            }
            IClass cls = er.findClass(null, localName);
            if (cls == null) {
                throw new BlueprintException("no class");
            }
            IElement element = (IElement)this._safe_newInstance(cls.getWrapperClass());
            element.bindOwnerDocument(this);
            element.bindBlueprintClass(cls);
            return element;
        }
        catch (Exception e) {
            System.err.println("cannot create element:");
            System.err.println("          uri = " + uri);
            System.err.println("    localName = " + localName);
            throw new BlueprintException(e);
        }
    }

    @Override
    public IElement createElement(Object target) {
        try {
            IClass cls = this.mImpl.findClass(target);
            if (cls == null) {
                throw new BlueprintException("no class");
            }
            IElement element = (IElement)this._safe_newInstance(cls.getWrapperClass());
            element.bindOwnerDocument(this);
            element.bindBlueprintClass(cls);
            element.bindTarget(target);
            return element;
        }
        catch (Exception e) {
            System.err.println("cannot create element for target:");
            System.err.println("    target = " + target.getClass().getName());
            throw new BlueprintException(e);
        }
    }

    @Override
    public IText createText(String data) {
        return new ImplText(data);
    }

    @Override
    public Object findTargetByURI(String uri) {
        URI ref = URI.create(uri);
        String id2 = ref.getFragment();
        return this.findTargetById(id2);
    }
}

