/*
 * Decompiled with CFR 0.152.
 */
package ananas.lib.blueprint2.impl;

import ananas.lib.blueprint2.BlueprintException;
import ananas.lib.blueprint2.dom.IAttr;
import ananas.lib.blueprint2.dom.IDocument;
import ananas.lib.blueprint2.dom.IElement;
import ananas.lib.blueprint2.dom.IText;
import ananas.lib.blueprint2.dom.helper.IBlueprintContext;
import ananas.lib.blueprint2.dom.helper.IDocumentBuilder;
import ananas.lib.io.InputConnection;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Stack;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

final class ImplBuilder
implements IDocumentBuilder {
    private final IBlueprintContext mContext;

    public ImplBuilder(IBlueprintContext context) {
        this.mContext = context;
    }

    @Override
    public IDocument build(InputStream is, String docURI) {
        return this._build(is, docURI);
    }

    private IDocument _build(InputStream is, String docURI) {
        try {
            IDocument doc = this.getBlueprintContext().getImplementation().newDocument(docURI);
            SAXParserFactory pf = SAXParserFactory.newInstance();
            pf.setNamespaceAware(true);
            SAXParser parser = pf.newSAXParser();
            MyBuilder h = new MyBuilder(doc);
            parser.parse(is, (DefaultHandler)h);
            return doc;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public IDocument build(File file2) throws IOException {
        FileInputStream is = new FileInputStream(file2);
        String uri = "file://" + file2.getAbsolutePath();
        return this._build(is, uri);
    }

    @Override
    public IDocument build(String docURI) throws IOException {
        String uri = docURI;
        InputConnection conn = (InputConnection)this.getBlueprintContext().getConnector().open(uri);
        InputStream is = conn.getInputStream();
        return this._build(is, uri);
    }

    @Override
    public IBlueprintContext getBlueprintContext() {
        return this.mContext;
    }

    private static class MyBuilder
    extends DefaultHandler {
        private final IDocument mDoc;
        private final Stack<IElement> mStack;

        public MyBuilder(IDocument doc) {
            this.mDoc = doc;
            this.mStack = new Stack();
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            int cc = this._trimHead(ch, start, length);
            start += cc;
            length -= cc;
            if ((length -= (cc = this._trimTail(ch, start, length))) < 1) {
                return;
            }
            String data = new String(ch, start, length);
            IText text = this.mDoc.createText(data);
            IElement element = this._curElement();
            boolean rlt = element.appendChild(text);
            if (!rlt) {
                String msg = "the element do not accept the text";
                System.err.println(msg);
                System.err.println("    element = " + element);
                System.err.println("       text = " + data);
                System.err.println(msg);
                throw new BlueprintException(msg);
            }
        }

        private int _trimTail(char[] ch, int start, int length) {
            int cc = length;
            while (cc > 0) {
                boolean isSpace;
                char c = ch[start + cc - 1];
                switch (c) {
                    case '\t': 
                    case '\n': 
                    case '\r': 
                    case ' ': {
                        isSpace = true;
                        break;
                    }
                    default: {
                        isSpace = false;
                    }
                }
                if (!isSpace) break;
                --cc;
            }
            return length - cc;
        }

        private int _trimHead(char[] ch, int start, int length) {
            int cc = 0;
            while (cc < length) {
                boolean isSpace;
                char c = ch[start + cc];
                switch (c) {
                    case '\t': 
                    case '\n': 
                    case '\r': 
                    case ' ': {
                        isSpace = true;
                        break;
                    }
                    default: {
                        isSpace = false;
                    }
                }
                if (!isSpace) break;
                ++cc;
            }
            return cc;
        }

        private IElement _curElement() {
            return this.mStack.peek();
        }

        @Override
        public void endDocument() throws SAXException {
            this.mStack.clear();
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            IElement child = this.mStack.pop();
            child.tagEnd();
            IElement parent = !this.mStack.isEmpty() ? this.mStack.peek() : null;
            if (parent == null) {
                this.mDoc.setRootElement(child);
                return;
            }
            boolean rlt = parent.appendChild(child);
            if (!rlt) {
                String msg = "the parent do not accept the child";
                System.err.println(msg);
                System.err.println("    parent = " + parent);
                System.err.println("     child = " + child);
                System.err.println(msg);
                throw new BlueprintException(msg);
            }
        }

        @Override
        public void endPrefixMapping(String prefix) throws SAXException {
            super.endPrefixMapping(prefix);
        }

        @Override
        public void error(SAXParseException e) throws SAXException {
            super.error(e);
        }

        @Override
        public void fatalError(SAXParseException e) throws SAXException {
            super.fatalError(e);
        }

        @Override
        public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
            super.ignorableWhitespace(ch, start, length);
        }

        @Override
        public void setDocumentLocator(Locator locator) {
            super.setDocumentLocator(locator);
        }

        @Override
        public void startDocument() throws SAXException {
            this.mStack.clear();
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            IElement element = this.mDoc.createElement(uri, localName);
            if (element == null) {
                String msg = "cannot create element";
                System.err.println(msg);
                System.err.println("        nsURI = " + uri);
                System.err.println("    localName = " + localName);
                System.err.println(msg);
                throw new BlueprintException(msg);
            }
            int len = attributes.getLength();
            int i = 0;
            while (i < len) {
                String attrURI = attributes.getURI(i);
                String attrLName = attributes.getLocalName(i);
                String attrValue = attributes.getValue(i);
                if (attrURI != null && attrURI.isEmpty()) {
                    attrURI = null;
                }
                if (attrURI == null) {
                    attrURI = element.getBlueprintClass().getNamespaceURI();
                }
                IAttr attr = this.mDoc.createAttribute(attrURI, attrLName);
                attr.setValue(attrValue);
                boolean rlt = element.setAttribute(attr);
                if (!rlt) {
                    String msg = "the element do not accept the attr";
                    System.err.println(msg);
                    System.err.println("    parent    = " + element);
                    System.err.println("    attrURI   = " + attrURI);
                    System.err.println("    attrLName = " + attrLName);
                    System.err.println("    attrValue = " + attrValue);
                    System.err.println(msg);
                    throw new BlueprintException(msg);
                }
                ++i;
            }
            this.mStack.push(element);
            element.tagBegin();
        }

        @Override
        public void startPrefixMapping(String prefix, String uri) throws SAXException {
            super.startPrefixMapping(prefix, uri);
        }

        @Override
        public void warning(SAXParseException e) throws SAXException {
            super.warning(e);
        }
    }
}

