/*
 * Decompiled with CFR 0.152.
 */
package ananas.lib.blueprint2.element.base;

import ananas.lib.blueprint2.dom.IAttr;
import ananas.lib.blueprint2.dom.IElement;
import ananas.lib.blueprint2.dom.INode;
import ananas.lib.blueprint2.dom.IText;
import ananas.lib.blueprint2.element.base.BaseElement;

public class BpParameterElement
extends BaseElement {
    private INode m_value;
    private String m_attr_type;
    private String m_attr_object;

    @Override
    public boolean setAttribute(IAttr attr) {
        String name = attr.getBlueprintClass().getLocalName();
        if (name == null) {
            return false;
        }
        if (name.equals("object")) {
            this.m_attr_object = attr.getValue();
            return true;
        }
        if (name.equals("class")) {
            this.m_attr_type = attr.getValue();
            return true;
        }
        if (name.equals("type")) {
            this.m_attr_type = attr.getValue();
            return true;
        }
        return super.setAttribute(attr);
    }

    @Override
    public boolean onAppendChild(INode child) {
        this.m_value = child;
        return true;
    }

    public Class<?> getParameterClass() {
        return this._getParameterClass();
    }

    private Class<?> _getParameterClass() {
        try {
            String type = this.m_attr_type;
            if (type == null) {
                return String.class;
            }
            String classpath = type;
            if (classpath.contains(".")) {
                return Class.forName(classpath);
            }
            if (classpath.equals("int")) {
                return Integer.TYPE;
            }
            if (classpath.equals("long")) {
                return Long.TYPE;
            }
            if (classpath.equals("short")) {
                return Short.TYPE;
            }
            if (classpath.equals("byte")) {
                return Byte.TYPE;
            }
            if (classpath.equals("char")) {
                return Character.TYPE;
            }
            if (classpath.equals("double")) {
                return Double.TYPE;
            }
            if (classpath.equals("float")) {
                return Float.TYPE;
            }
            if (classpath.equals("boolean")) {
                return Boolean.TYPE;
            }
            return String.class;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public Object getParameterObject() {
        return this._getParameterObject();
    }

    private Object _getParameterObject() {
        INode value = this.m_value;
        if (value == null) {
            return null;
        }
        if (value instanceof IText) {
            return this._textToObject((IText)value);
        }
        if (value instanceof IElement) {
            IElement element = (IElement)value;
            if ("element".equals(this.m_attr_object)) {
                return element;
            }
            return element.getTarget(true);
        }
        return null;
    }

    private Object _textToObject(IText value) {
        String str = value.getData();
        String type = this.m_attr_type;
        if (type != null) {
            if (type.equals("int")) {
                return Integer.parseInt(str);
            }
            if (type.equals("long")) {
                return Long.parseLong(str);
            }
            if (type.equals("short")) {
                return Short.parseShort(str);
            }
            if (type.equals("byte")) {
                return Byte.parseByte(str);
            }
            if (type.equals("char")) {
                return Character.valueOf((char)str.indexOf(0));
            }
            if (type.equals("double")) {
                return Double.parseDouble(str);
            }
            if (type.equals("float")) {
                return Float.valueOf(Float.parseFloat(str));
            }
        }
        return str;
    }
}

