/*
 * Decompiled with CFR 0.152.
 */
package ananas.lib.blueprint2.awt;

import ananas.lib.blueprint2.awt.LayoutManagerWrapper;
import ananas.lib.blueprint2.awt.ObjectWrapper;
import ananas.lib.blueprint2.dom.IAttr;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.LayoutManager;
import java.util.HashMap;
import java.util.Map;

public class FlowLayoutWrapper
extends ObjectWrapper
implements LayoutManagerWrapper {
    private static Map<String, Integer> sAlignMapper = null;
    private String m_attr_align;

    @Override
    public LayoutManager getLayoutManager(boolean create) {
        return (LayoutManager)this.getTarget(create);
    }

    @Override
    public void addComponentToContainer(Component component, Container container, String position) {
        container.add(component);
    }

    @Override
    public boolean setAttribute(IAttr attr) {
        String name = attr.getBlueprintClass().getLocalName();
        if (name == null) {
            return false;
        }
        if (name.equals("align")) {
            this.m_attr_align = attr.getValue();
            return true;
        }
        return super.setAttribute(attr);
    }

    @Override
    public void onTagEnd() {
        super.onTagEnd();
        FlowLayout target = (FlowLayout)this.getTarget(true);
        String align = this.m_attr_align;
        if (align != null) {
            int n = this._alignStringToInt(align);
            target.setAlignment(n);
        }
    }

    private int _alignStringToInt(String align) {
        Integer ret;
        Map<String, Integer> map = sAlignMapper;
        if (map == null) {
            map = new HashMap<String, Integer>();
            map.put("CENTER", 1);
            map.put("LEFT", 0);
            map.put("RIGHT", 2);
            map.put("LEADING", 3);
            map.put("TRAILING", 4);
            sAlignMapper = map;
        }
        if ((ret = map.get(align)) == null) {
            return 1;
        }
        return ret;
    }

    @Override
    public boolean setContainer(Container container) {
        return false;
    }
}

