/*
 * Decompiled with CFR 0.152.
 */
package ananas.lib.blueprint2;

import ananas.lib.blueprint2.AbstractNode;
import ananas.lib.blueprint2.BlueprintException;
import ananas.lib.blueprint2.dom.IAttr;
import ananas.lib.blueprint2.dom.IDocument;
import ananas.lib.blueprint2.dom.IElement;
import ananas.lib.blueprint2.dom.INode;
import ananas.lib.blueprint2.dom.helper.IClass;
import ananas.lib.blueprint2.dom.helper.IInvokeable;
import java.util.List;

public class AbstractElement
extends AbstractNode
implements IElement {
    private IDocument mOwnerDoc;
    private IElement mParent;
    private Object mTarget;
    private String mId;
    private boolean mIsTagBegin;
    private boolean mIsTagEnd;

    protected AbstractElement() {
    }

    @Override
    public String getId() {
        return this.mId;
    }

    @Override
    public Object getTarget() {
        return this.mTarget;
    }

    @Override
    public Object createTarget() {
        IClass cls = this.getBlueprintClass();
        Class<?> tc = cls.getTargetClass();
        try {
            return tc.newInstance();
        }
        catch (Exception e) {
            throw new BlueprintException(e);
        }
    }

    @Override
    public IDocument getOwnerDocument() {
        return this.mOwnerDoc;
    }

    @Override
    public boolean bindTarget(Object target) {
        if (this.mTarget == null && target != null) {
            this.mTarget = target;
            return true;
        }
        return false;
    }

    @Override
    public final boolean bindOwnerDocument(IDocument ownerDoc) {
        if (this.mOwnerDoc == null && ownerDoc != null) {
            this.mOwnerDoc = ownerDoc;
            return true;
        }
        return false;
    }

    @Override
    public boolean setAttribute(IAttr attr) {
        String lname = attr.getBlueprintClass().getLocalName();
        if ("id".equalsIgnoreCase(lname)) {
            this.mId = attr.getValue();
            return true;
        }
        return false;
    }

    @Override
    public final void tagBegin() {
        this.onTagBegin();
        if (!this.mIsTagBegin) {
            System.err.println("warning: the onTagBegin() has not been called : " + this);
        }
    }

    @Override
    public final void tagEnd() {
        this.onTagEnd();
        if (!this.mIsTagEnd) {
            System.err.println("warning: the onTagEnd() has not been called : " + this);
        }
    }

    protected void onTagBegin() {
        this.mIsTagBegin = true;
        if (this.mId != null) {
            this.mOwnerDoc.registerElement(this);
        }
    }

    protected void onTagEnd() {
        this.mIsTagEnd = true;
    }

    @Override
    public IElement getParent() {
        return this.mParent;
    }

    @Override
    public List<IAttr> listAttributes() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final IElement _setParent(IElement newParent) {
        IElement oldParent;
        AbstractElement abstractElement = this;
        synchronized (abstractElement) {
            oldParent = this.mParent;
            this.mParent = newParent;
        }
        if (newParent == oldParent) {
            return oldParent;
        }
        if (oldParent != null) {
            oldParent.removeChild(this);
        }
        if (newParent != null) {
            newParent.appendChild(this);
        }
        this.onParentChanged(oldParent, newParent);
        return oldParent;
    }

    @Override
    public final IElement setParent(IElement newParent) {
        return this._setParent(newParent);
    }

    protected void onParentChanged(IElement oldParent, IElement newParent) {
    }

    @Override
    public final boolean appendChild(INode child) {
        if (child instanceof IElement) {
            IElement che = (IElement)child;
            IElement old = che.getParent();
            if (old == this) {
                return false;
            }
            boolean rlt = this.onAppendChild(child);
            if (rlt) {
                che.setParent(this);
            }
            return rlt;
        }
        return this.onAppendChild(child);
    }

    protected boolean onAppendChild(INode child) {
        if (child == null) {
            return false;
        }
        return child instanceof IInvokeable;
    }

    @Override
    public List<INode> listChildren() {
        return null;
    }

    @Override
    public Object getTarget(boolean create) {
        Object t = this.mTarget;
        if (t == null && create) {
            this.mTarget = t = this.createTarget();
        }
        return t;
    }

    @Override
    public boolean removeChild(INode child) {
        IElement che;
        IElement old;
        if (child instanceof IElement && (old = (che = (IElement)child).getParent()) == this) {
            che.setParent(null);
            return true;
        }
        return false;
    }
}

