/*
 * Decompiled with CFR 0.152.
 */
package ananas.cust.app.ir_therm.tools;

import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import javax.swing.DefaultListModel;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;

public class Irth2Monitor
implements Runnable {
    private DefaultListModel mListModel;
    private Thread mUIThread;
    private boolean mIsExit;

    public static void main(String[] args) {
        Irth2Monitor runn = new Irth2Monitor();
        SwingUtilities.invokeLater(runn);
    }

    private void startListenInput() {
        Thread thd = new Thread(new Runnable(){

            @Override
            public void run() {
                Irth2Monitor.this.doInputLoop();
            }
        });
        thd.start();
    }

    private void output(String str) {
        Thread thdUI;
        Thread thdCurr = Thread.currentThread();
        if (!thdCurr.equals(thdUI = this.mUIThread)) {
            MyOnLineRx runn = new MyOnLineRx(str);
            runn.call();
            return;
        }
        ArrayList<String> list = new ArrayList<String>();
        int limit = 80;
        while (str.length() > 0) {
            if (str.length() > limit) {
                String s2;
                String s1 = str.substring(0, limit);
                str = s2 = str.substring(limit);
                list.add(s1);
                continue;
            }
            list.add(str);
            str = "";
        }
        int i0 = 0;
        for (String s : list) {
            int i1;
            if ((i1 = i0++) == 0) {
                this.mListModel.addElement(s);
                continue;
            }
            this.mListModel.addElement("    " + s);
        }
    }

    protected void doInputLoop() {
        try {
            File log = this._getLogOutput();
            log.getParentFile().mkdirs();
            log.createNewFile();
            FileOutputStream out = new FileOutputStream(log);
            this.output("log to file " + log);
            int lenLimit = 1024;
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            InputStream in = System.in;
            int b = in.read();
            while (b >= 0) {
                if (this.mIsExit) break;
                ((OutputStream)out).write(b);
                if (b == 10 || b == 13) {
                    String str = new String(baos.toByteArray(), "UTF-8");
                    baos.reset();
                    this.output(str);
                    out.flush();
                } else {
                    int len = baos.size();
                    if (len < 1024) {
                        baos.write(b);
                    } else if (len == 1024) {
                        baos.write("[...]".getBytes());
                    }
                }
                b = in.read();
            }
            out.flush();
            ((OutputStream)out).close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private File _getLogOutput() {
        File dir = this.getWorkingDir();
        File file2 = new File(dir, "logs/log-" + System.currentTimeMillis() + ".txt");
        return file2;
    }

    private File getWorkingDir() {
        try {
            URL url = this.getClass().getProtectionDomain().getCodeSource().getLocation();
            URI uri = url.toURI();
            File dir = new File(uri);
            return dir.getParentFile();
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
            return new File("/tmp/");
        }
    }

    @Override
    public void run() {
        JFrame frame = new JFrame();
        frame.setBounds(0, 0, 200, 200);
        frame.setTitle("" + this);
        frame.setDefaultCloseOperation(3);
        frame.addWindowListener(this.getWindowListener());
        JScrollPane sp = new JScrollPane();
        JList list = new JList();
        DefaultListModel model = new DefaultListModel();
        int i = 100;
        while (i > 0) {
            --i;
        }
        list.setModel(model);
        this.mListModel = model;
        sp.setViewportView(list);
        frame.add(sp);
        frame.setVisible(true);
        this.startListenInput();
    }

    private WindowListener getWindowListener() {
        return new WindowListener(){
            private final String mExitCmd = "$EXIT$";

            @Override
            public void windowActivated(WindowEvent arg0) {
            }

            @Override
            public void windowClosed(WindowEvent arg0) {
                this.doClose();
            }

            @Override
            public void windowClosing(WindowEvent arg0) {
                this.doClose();
            }

            private void doClose() {
                Irth2Monitor.this.mIsExit = true;
                System.out.println("$EXIT$");
                System.out.println("$EXIT$");
                System.out.println("$EXIT$");
                System.out.println("$EXIT$");
            }

            @Override
            public void windowDeactivated(WindowEvent arg0) {
            }

            @Override
            public void windowDeiconified(WindowEvent arg0) {
            }

            @Override
            public void windowIconified(WindowEvent arg0) {
            }

            @Override
            public void windowOpened(WindowEvent arg0) {
            }
        };
    }

    class MyOnLineRx
    implements Runnable {
        private final String mLine;

        public MyOnLineRx(String str) {
            this.mLine = str;
        }

        public void call() {
            SwingUtilities.invokeLater(this);
        }

        @Override
        public void run() {
            Irth2Monitor.this.mUIThread = Thread.currentThread();
            Irth2Monitor.this.output(this.mLine);
        }
    }
}

