/*
 * Decompiled with CFR 0.152.
 */
package ananas.cust.app.ir_therm.log;

import ananas.cust.app.ir_therm.Irth;
import ananas.cust.app.ir_therm.core.Timestamp;
import ananas.cust.app.ir_therm.core.Timezone;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class LogOutputStream
extends OutputStream {
    private final OutputStream mOut;
    private final File mFile;
    private int mCntBytesInBuffer;
    private final ByteArrayOutputStream mBuffer = new ByteArrayOutputStream();

    public LogOutputStream(OutputStream out, String fileName) {
        this.mOut = out;
        this.mFile = this._getFileByName(fileName);
    }

    private File _getFileByName(String fileName) {
        Timestamp time = Timestamp.getTimestampNow();
        Timezone zone = Timezone.getLocalZone();
        String str = zone.format(time);
        File dir = new File(Irth.getWorkingDirectory(), "logs");
        str = String.valueOf(str) + "_" + fileName + ".log";
        str = this._normalFileName(str);
        File file2 = new File(dir, str);
        System.out.println("log to " + file2);
        return file2;
    }

    private String _normalFileName(String str) {
        char[] chs;
        StringBuilder sb = new StringBuilder();
        char[] cArray = chs = str.toCharArray();
        int n = chs.length;
        int n2 = 0;
        while (n2 < n) {
            int ch = cArray[n2];
            int ch2 = ch == 0 ? 0 : (48 <= ch && ch <= 57 ? ch : (97 <= ch && ch <= 122 ? ch : (65 <= ch && ch <= 90 ? ch : (ch == 58 ? 45 : (ch == 46 || ch == 45 || ch == 95 ? ch : 95)))));
            if (ch2 > 0) {
                sb.append((char)ch2);
            }
            ++n2;
        }
        return sb.toString();
    }

    @Override
    public void write(int b) throws IOException {
        if (b <= 0) {
            this.mOut.write("(hard flush)\n".getBytes());
            this.mOut.flush();
            this._doFlush();
        } else {
            this.mOut.write(b);
            this.mBuffer.write(b);
            ++this.mCntBytesInBuffer;
            if (this.mCntBytesInBuffer > 10240) {
                this._doFlush();
            }
        }
    }

    private void _doFlush() {
        this.mCntBytesInBuffer = 0;
        byte[] ba = this.mBuffer.toByteArray();
        this.mBuffer.reset();
        File file2 = this.mFile;
        FileOutputStream out = null;
        try {
            if (!file2.exists()) {
                file2.getParentFile().mkdirs();
                file2.createNewFile();
                out = new FileOutputStream(file2);
            } else {
                out = new FileOutputStream(file2, true);
            }
            out.write(ba);
            out.flush();
            out.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

