/*
 * Decompiled with CFR 0.152.
 */
package ananas.cust.app.ir_therm.gui.widget.line;

import ananas.cust.app.ir_therm.gui.widget.line.DefaultLineLevel;
import ananas.cust.app.ir_therm.gui.widget.line.ILineLevel;
import ananas.cust.app.ir_therm.gui.widget.line.ILineLevelSet;
import ananas.cust.app.ir_therm.gui.widget.line.ILineNode;
import java.util.ArrayList;
import java.util.List;

public class DefaultLineLevelSet
implements ILineLevelSet {
    private final List<ILineLevel> mList = new ArrayList<ILineLevel>();
    private final ILineLevel mBaseLine;
    private double mValueMin;
    private double mValueMax;

    public DefaultLineLevelSet(int size) {
        ILineLevel ll = null;
        int i = 0;
        while (i < size) {
            ll = new DefaultLineLevel(ll);
            ++i;
        }
        while (ll != null) {
            this.mList.add(ll);
            ll = ll.nextLevel();
        }
        this.mBaseLine = this.mList.get(0);
        this.reset();
    }

    @Override
    public void reset() {
        List<ILineLevel> list = this.mList;
        for (ILineLevel ll : list) {
            ll.reset();
        }
        this.mValueMax = Double.MIN_VALUE;
        this.mValueMin = Double.MAX_VALUE;
    }

    @Override
    public ILineNode getNode(int index) {
        return this.mBaseLine.getNode(index);
    }

    @Override
    public int countNode() {
        return this.mBaseLine.countNode();
    }

    @Override
    public void addNode(ILineNode node) {
        this.mBaseLine.addNode(node);
        node.rebuild();
        double value = node.value0();
        this.mValueMax = Math.max(this.mValueMax, value);
        this.mValueMin = Math.min(this.mValueMin, value);
    }

    @Override
    public ILineLevel nextLevel() {
        return this.mBaseLine.nextLevel();
    }

    @Override
    public ILineLevel getLevel(int index) {
        return this.mList.get(index);
    }

    @Override
    public int countLevel() {
        return this.mList.size();
    }

    @Override
    public double maxValue() {
        return this.mValueMax;
    }

    @Override
    public double minValue() {
        return this.mValueMin;
    }

    @Override
    public ILineNode getNode(int index, boolean autoCreate) {
        return this.mBaseLine.getNode(index, autoCreate);
    }
}

