/*
 * Decompiled with CFR 0.152.
 */
package ananas.cust.app.ir_therm.gui.widget.line;

import ananas.cust.app.ir_therm.gui.widget.line.DefaultLineNode;
import ananas.cust.app.ir_therm.gui.widget.line.ILineLevel;
import ananas.cust.app.ir_therm.gui.widget.line.ILineNode;
import java.util.ArrayList;
import java.util.List;

public class DefaultLineLevel
implements ILineLevel {
    private final ILineLevel mNextLevel;
    private final List<ILineNode> mList = new ArrayList<ILineNode>();

    public DefaultLineLevel(ILineLevel nextLevel) {
        this.mNextLevel = nextLevel;
    }

    @Override
    public ILineNode getNode(int index) {
        return this.mList.get(index);
    }

    @Override
    public int countNode() {
        return this.mList.size();
    }

    @Override
    public void addNode(ILineNode node) {
        int index = this.mList.size();
        this.mList.add(node);
        ILineLevel next = this.nextLevel();
        if (next != null) {
            ILineNode child = next.getNode(index / 2, true);
            node.setChild(child);
            if ((index & 1) == 0) {
                child.setParent0(node);
            } else {
                child.setParent1(node);
            }
        }
    }

    @Override
    public ILineLevel nextLevel() {
        return this.mNextLevel;
    }

    @Override
    public void reset() {
        this.mList.clear();
    }

    @Override
    public ILineNode getNode(int index, boolean autoCreate) {
        if (index < 0) {
            return null;
        }
        if (index < this.mList.size()) {
            return this.mList.get(index);
        }
        if (!autoCreate) {
            return null;
        }
        DefaultLineNode node = null;
        while (this.mList.size() <= index) {
            node = new DefaultLineNode();
            this.addNode(node);
        }
        return node;
    }
}

