/*
 * Decompiled with CFR 0.152.
 */
package ananas.cust.app.ir_therm.gui.widget.line;

import ananas.cust.app.ir_therm.core.Temperature;
import ananas.cust.app.ir_therm.core.TemperatureUnit;
import ananas.cust.app.ir_therm.gui.widget.line.IValueBarModel;

public abstract class AbstractValueBar
implements IValueBarModel {
    private double mA = 1.0;
    private double mB = 1.0;
    private int mHeight = 100;
    private double mValueMin = -1.0;
    private double mValueMax = 1.0;
    private double mScale = 0.5;
    private double mOffset = 0.5;
    private MyGridHelper mGridHelper;
    private double mGridStep;

    public AbstractValueBar() {
        this._rebuildAB();
    }

    @Override
    public int mapValueToY(double value) {
        return (int)(value * this.mA + this.mB);
    }

    @Override
    public double mapYtoValue(int y) {
        return ((double)y - this.mB) / this.mA;
    }

    @Override
    public int height() {
        return this.mHeight;
    }

    @Override
    public void setHeight(int height) {
        this.mHeight = height;
        this._rebuildAB();
    }

    private void _rebuildAB() {
        double off = this.mOffset;
        double scale = this.mScale;
        double h = this.mHeight;
        double dm = MyHelper.anti0(Math.abs(this.mValueMax - this.mValueMin));
        double a = 0.0 - h * scale / dm;
        double b = h * (off * (scale - 1.0) + scale * this.mValueMin / dm + 1.0);
        this.mA = MyHelper.anti0(a);
        this.mB = b;
        MyGridHelper helper = this._getGridHelper();
        AbstractValueBar model = this;
        this.mGridStep = helper.calcGridStep(model);
    }

    @Override
    public double valueMin() {
        return this.mValueMin;
    }

    @Override
    public double valueMax() {
        return this.mValueMax;
    }

    @Override
    public void setValueLimit(double vMin, double vMax) {
        this.mValueMin = vMin;
        this.mValueMax = vMax;
        this._rebuildAB();
    }

    @Override
    public double scale() {
        return this.mScale;
    }

    @Override
    public void setScale(double scale) {
        this.mScale = scale;
        this._rebuildAB();
    }

    @Override
    public double offset() {
        return this.mOffset;
    }

    @Override
    public void setOffset(double offset) {
        this.mOffset = offset;
        this._rebuildAB();
    }

    @Override
    public Temperature wrapValue(double value) {
        TemperatureUnit unit = this.getUnit();
        return unit.objectForValue(value);
    }

    @Override
    public double getGridStep() {
        return this.mGridStep;
    }

    private MyGridHelper _getGridHelper() {
        MyGridHelper helper = this.mGridHelper;
        if (helper == null) {
            this.mGridHelper = helper = new MyGridHelper();
        }
        return helper;
    }

    @Override
    public double getGridPos(double value) {
        double step = this.mGridStep;
        if (Math.abs(step) < 1.0E-7) {
            step = 1.0E-6;
        }
        int dt = (int)(value / step);
        return step * (double)dt;
    }

    class MyGridHelper {
        private final int mReferenceWidth;
        private final double[] mModeList;

        public MyGridHelper() {
            double[] list = new double[]{0.01, 0.02, 0.05, 0.1, 0.2, 0.5, 1.0, 2.0, 5.0, 10.0, 20.0, 50.0, 100.0, 200.0, 500.0, 1000.0, 2000.0, 5000.0, 10000.0, 20000.0};
            this.mModeList = list;
            this.mReferenceWidth = 50;
        }

        public double calcGridStep(IValueBarModel model) {
            double a = model.mapYtoValue(0);
            double b = model.mapYtoValue(this.mReferenceWidth);
            double c = Math.abs(a - b);
            double no = this.mModeList[0];
            double[] dArray = this.mModeList;
            int n = this.mModeList.length;
            int n2 = 0;
            while (n2 < n) {
                double n3;
                no = n3 = dArray[n2];
                if (n3 > c) break;
                ++n2;
            }
            return no;
        }
    }

    static class MyHelper {
        MyHelper() {
        }

        public static double anti0(double n) {
            double limit = 1.0E-9;
            if (Math.abs(n) < 1.0E-9) {
                return 1.0E-9;
            }
            return n;
        }

        public static int anti0(int n) {
            if (n == 0) {
                return 1;
            }
            return 0;
        }
    }
}

