/*
 * Decompiled with CFR 0.152.
 */
package ananas.cust.app.ir_therm.gui.widget.line;

import ananas.cust.app.ir_therm.core.Timestamp;
import ananas.cust.app.ir_therm.gui.widget.line.ITimeBarModel;

public abstract class AbstractTimeBar
implements ITimeBarModel {
    private double mA = 1.0;
    private double mB = 1.0;
    private double mOffset = 0.5;
    private double mScale = 0.5;
    private long mTimeMax = 0L;
    private long mTimeMin = 100L;
    private int mWidth = 100;
    private MyGridHelper mGridHelper;
    private long mGridStep;

    public AbstractTimeBar() {
        this._rebuildAB();
    }

    @Override
    public int mapTimeToX(long time) {
        return (int)((double)time * this.mA + this.mB);
    }

    @Override
    public long mapXtoTime(int x) {
        return (long)(((double)x - this.mB) / this.mA);
    }

    @Override
    public int width() {
        return this.mWidth;
    }

    @Override
    public void setWidth(int width) {
        this.mWidth = width;
        this._rebuildAB();
    }

    @Override
    public long timeMin() {
        return this.mTimeMin;
    }

    @Override
    public long timeMax() {
        return this.mTimeMax;
    }

    @Override
    public void setTimeLimit(long tMin, long tMax) {
        this.mTimeMax = tMax;
        this.mTimeMin = tMin;
        this._rebuildAB();
    }

    private void _rebuildAB() {
        double off = this.mOffset;
        double dm = MyHelper.anti0(Math.abs(this.mTimeMax - this.mTimeMin));
        double w = this.mWidth;
        double scale = this.mScale;
        double a = w * scale / dm;
        double b = w * (off * (1.0 - scale) - scale * (double)this.mTimeMin / dm);
        this.mA = MyHelper.anti0(a);
        this.mB = b;
        MyGridHelper helper = this._getGridHelper();
        AbstractTimeBar model = this;
        this.mGridStep = helper.calcGridStep(model);
    }

    @Override
    public double scale() {
        return this.mScale;
    }

    @Override
    public void setScale(double scale) {
        this.mScale = scale;
        this._rebuildAB();
    }

    @Override
    public double offset() {
        return this.mOffset;
    }

    @Override
    public void setOffset(double offset) {
        this.mOffset = offset;
        this._rebuildAB();
    }

    @Override
    public Timestamp wrapValue(long time) {
        return Timestamp.getTimestamp(time);
    }

    @Override
    public long getGridStep() {
        return this.mGridStep;
    }

    @Override
    public long getGridPos(long value) {
        long step = this.mGridStep;
        if (step == 0L) {
            step = 1L;
        }
        long dt = value / step;
        return step * dt;
    }

    private MyGridHelper _getGridHelper() {
        MyGridHelper helper = this.mGridHelper;
        if (helper == null) {
            this.mGridHelper = helper = new MyGridHelper();
        }
        return helper;
    }

    class MyGridHelper {
        private final int mReferenceWidth;
        private final long[] mModeList;

        public MyGridHelper() {
            long[] list = new long[]{10L, 20L, 50L, 100L, 200L, 500L, 1000L, 2000L, 5000L, 10000L, 20000L, 30000L, 60000L, 120000L, 300000L, 600000L, 1200000L, 1800000L, 3600000L, 0x6DDD00L, 14400000L, 28800000L, 43200000L, 86400000L, 172800000L, 432000000L, 864000000L};
            this.mModeList = list;
            this.mReferenceWidth = 100;
        }

        public long calcGridStep(ITimeBarModel model) {
            long a = model.mapXtoTime(0);
            long b = model.mapXtoTime(this.mReferenceWidth);
            long c = Math.abs(a - b);
            long no = this.mModeList[0];
            long[] lArray = this.mModeList;
            int n = this.mModeList.length;
            int n2 = 0;
            while (n2 < n) {
                long n3;
                no = n3 = lArray[n2];
                if (n3 > c) break;
                ++n2;
            }
            return no;
        }
    }

    static class MyHelper {
        MyHelper() {
        }

        public static long anti0(long n) {
            return n == 0L ? 1L : n;
        }

        public static double anti0(double n) {
            double limit = 1.0E-9;
            if (Math.abs(n) < 1.0E-9) {
                return 1.0E-9;
            }
            return n;
        }
    }
}

