/*
 * Decompiled with CFR 0.152.
 */
package ananas.cust.app.ir_therm.gui.widget.line;

import ananas.cust.app.ir_therm.core.TemperatureUnit;
import ananas.cust.app.ir_therm.core.Timezone;
import ananas.cust.app.ir_therm.event.DefaultEventDispatcher;
import ananas.cust.app.ir_therm.event.IEvent;
import ananas.cust.app.ir_therm.event.IEventDispatcher2;
import ananas.cust.app.ir_therm.event.IEventListener;
import ananas.cust.app.ir_therm.event.ModelChangedEvent;
import ananas.cust.app.ir_therm.gui.widget.line.AbstractTimeBar;
import ananas.cust.app.ir_therm.gui.widget.line.AbstractValueBar;
import ananas.cust.app.ir_therm.gui.widget.line.DefaultLineLevelSet;
import ananas.cust.app.ir_therm.gui.widget.line.ILineLevel;
import ananas.cust.app.ir_therm.gui.widget.line.ILineLevelSet;
import ananas.cust.app.ir_therm.gui.widget.line.ILineModel;
import ananas.cust.app.ir_therm.gui.widget.line.ILineNode;
import ananas.cust.app.ir_therm.gui.widget.line.ILineStyle;
import ananas.cust.app.ir_therm.gui.widget.line.ITimeBarModel;
import ananas.cust.app.ir_therm.gui.widget.line.IValueBarModel;
import java.awt.Color;

public abstract class AbstractLineModel
implements ILineModel {
    private final IEventDispatcher2 mEvtDisp = new DefaultEventDispatcher();
    private final IValueBarModel mValueBar = new MyVBar();
    private final ITimeBarModel mTimeBar = new MyTBar();
    private final ILineLevelSet mLLSet = new DefaultLineLevelSet(6);
    private final ILineStyle mStyle = new MyStyle();

    protected abstract Timezone getTimezone();

    protected abstract TemperatureUnit getUnit();

    @Override
    public void addListener(IEventListener listener) {
        this.mEvtDisp.addListener(listener);
    }

    @Override
    public void removeListener(IEventListener listener) {
        this.mEvtDisp.removeListener(listener);
    }

    @Override
    public void dispatchEvent(IEvent event) {
        this.mEvtDisp.dispatchEvent(event);
    }

    @Override
    public ITimeBarModel getTimeBar() {
        return this.mTimeBar;
    }

    @Override
    public IValueBarModel getValueBar() {
        return this.mValueBar;
    }

    @Override
    public ILineLevelSet getLineLevelSet() {
        return this.mLLSet;
    }

    @Override
    public ILineStyle getLineStyle() {
        return this.mStyle;
    }

    @Override
    public ILineNode findNode(long time) {
        ILineLevel ll = this.mLLSet.getLevel(0);
        int index = this._indexForTime(ll, time);
        if (index >= 0 && index < ll.countNode()) {
            return ll.getNode(index);
        }
        return null;
    }

    @Override
    public ILineLevel findViewRange(long from, long to, int dotLimit) {
        ILineLevel ll2;
        ILineLevel ll = this.getLineLevelSet();
        int iFrom = this._indexForTime(ll, from);
        int iTo = this._indexForTime(ll, to);
        while (iTo - iFrom > dotLimit && (ll2 = ll.nextLevel()) != null) {
            ll = ll2;
            iTo /= 2;
            iFrom /= 2;
        }
        return new MyLLWrapper(ll, iFrom - 2, iTo - iFrom + 4);
    }

    private int _indexForTime(ILineLevel ll, long time) {
        int i1 = 0;
        int i2 = ll.countNode() - 1;
        while (i1 < i2) {
            int im = (i1 + i2) / 2;
            ILineNode node = ll.getNode(im);
            long mtime = node.timestamp0();
            if (mtime < time) {
                i1 = im;
            } else {
                i2 = im;
            }
            if (Math.abs(i1 - i2) > 1) continue;
            long t1 = ll.getNode(i1).timestamp0();
            long t2 = ll.getNode(i2).timestamp0();
            if (Math.abs(t1 - time) <= Math.abs(t2 - time)) break;
            i1 = i2;
            break;
        }
        return i1;
    }

    protected void fireModelChanged() {
        this.dispatchEvent(new ModelChangedEvent(this, 16));
    }

    protected void fireModelUpdate() {
        this.dispatchEvent(new ModelChangedEvent(this, 8));
    }

    class MyLLWrapper
    implements ILineLevel {
        private final ILineLevel mList;
        private final int mOffset;
        private final int mLength;

        public MyLLWrapper(ILineLevel ll, int offset, int length) {
            this.mList = ll;
            if (offset < 0) {
                offset = 0;
            }
            if (offset + length > ll.countNode()) {
                length = ll.countNode() - offset;
            }
            this.mOffset = offset;
            this.mLength = length;
        }

        @Override
        public ILineNode getNode(int index) {
            if (index < this.mLength) {
                int i = this.mOffset + index;
                return this.mList.getNode(i);
            }
            return null;
        }

        @Override
        public int countNode() {
            return this.mLength;
        }

        @Override
        public void addNode(ILineNode node) {
        }

        @Override
        public void reset() {
        }

        @Override
        public ILineLevel nextLevel() {
            return null;
        }

        @Override
        public ILineNode getNode(int index, boolean autoCreate) {
            return this.getNode(index);
        }
    }

    class MyStyle
    implements ILineStyle {
        MyStyle() {
        }

        @Override
        public Color getBackgroundColor() {
            return Color.BLACK;
        }

        @Override
        public Color getLineColor() {
            return Color.YELLOW;
        }

        @Override
        public Color getGridColor() {
            return Color.gray;
        }

        @Override
        public Color getAlarmColorH() {
            return Color.red;
        }

        @Override
        public Color getAlarmColorL() {
            return Color.blue;
        }

        @Override
        public Color getCursorColor() {
            return Color.yellow;
        }
    }

    class MyTBar
    extends AbstractTimeBar {
        MyTBar() {
        }

        @Override
        public Timezone getTimezone() {
            return AbstractLineModel.this.getTimezone();
        }
    }

    class MyVBar
    extends AbstractValueBar {
        MyVBar() {
        }

        @Override
        public TemperatureUnit getUnit() {
            return AbstractLineModel.this.getUnit();
        }
    }
}

