/*
 * Decompiled with CFR 0.152.
 */
package ananas.cust.app.ir_therm.gui.widget;

import ananas.cust.app.ir_therm.core.Temperature;
import ananas.cust.app.ir_therm.event.IEvent;
import ananas.cust.app.ir_therm.event.IEventListener;
import ananas.cust.app.ir_therm.gui.widget.line.ILineModel;
import ananas.cust.app.ir_therm.gui.widget.line.ILineStyle;
import ananas.cust.app.ir_therm.gui.widget.line.IValueBarModel;
import java.awt.Color;
import java.awt.Graphics;
import javax.swing.JPanel;

public class ValueRuler
extends JPanel
implements IEventListener {
    private ILineModel mModel;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setModel(ILineModel model) {
        ILineModel pold;
        ValueRuler valueRuler = this;
        synchronized (valueRuler) {
            pold = this.mModel;
            this.mModel = model;
        }
        if (pold != null) {
            pold.removeListener(this);
        }
        if (model != null) {
            model.addListener(this);
        }
    }

    @Override
    public void paintComponent(Graphics g) {
        this._drawSelf(g);
    }

    private void _drawSelf(Graphics g) {
        int w = this.getWidth();
        int h = this.getHeight();
        ILineModel model = this.mModel;
        if (model == null) {
            g.setColor(Color.black);
            g.fillRect(0, 0, w, h);
            return;
        }
        this._drawBackground(g, model, w, h);
        this._drawGrid(g, model, w, h);
    }

    private void _drawGrid(Graphics g, ILineModel model, int w, int h) {
        g.setColor(model.getLineStyle().getGridColor());
        g.drawLine(w - 1, 0, w - 1, h);
        IValueBarModel vbar = model.getValueBar();
        double value_1 = vbar.mapYtoValue(0);
        double value_2 = vbar.mapYtoValue(h);
        double value0 = Math.min(value_1, value_2);
        double value1 = Math.max(value_1, value_2);
        double pos = vbar.getGridPos(value0);
        double step = vbar.getGridStep();
        int limit = h;
        while (pos < value1) {
            if (limit <= 0) break;
            --limit;
            int y = vbar.mapValueToY(pos);
            Temperature tempe = vbar.wrapValue(pos);
            g.drawLine(w - 1, y, w - 5, y);
            String str = tempe.toString();
            g.drawString(str, 5, y);
            pos += step;
        }
    }

    private void _drawBackground(Graphics g, ILineModel model, int w, int h) {
        ILineStyle style = model.getLineStyle();
        g.setColor(style.getBackgroundColor());
        g.fillRect(0, 0, w, h);
    }

    @Override
    public void onEvent(IEvent event) {
        this.repaint(100L);
    }
}

