/*
 * Decompiled with CFR 0.152.
 */
package ananas.cust.app.ir_therm.gui.widget;

import ananas.cust.app.ir_therm.core.Timestamp;
import ananas.cust.app.ir_therm.core.Timezone;
import ananas.cust.app.ir_therm.event.IEvent;
import ananas.cust.app.ir_therm.event.IEventListener;
import ananas.cust.app.ir_therm.gui.widget.line.ILineModel;
import ananas.cust.app.ir_therm.gui.widget.line.ILineStyle;
import ananas.cust.app.ir_therm.gui.widget.line.ITimeBarModel;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.event.MouseWheelEvent;
import javax.swing.JPanel;

public class TimeRuler
extends JPanel
implements IEventListener {
    private ILineModel mModel;

    public TimeRuler() {
        this.enableEvents(1531L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setModel(ILineModel model) {
        ILineModel pold;
        TimeRuler timeRuler = this;
        synchronized (timeRuler) {
            pold = this.mModel;
            this.mModel = model;
        }
        if (pold != null) {
            pold.removeListener(this);
        }
        if (model != null) {
            model.addListener(this);
        }
    }

    @Override
    public void paintComponent(Graphics g) {
        this._drawSelf(g);
    }

    private void _drawSelf(Graphics g) {
        int w = this.getWidth();
        int h = this.getHeight();
        ILineModel model = this.mModel;
        if (model == null) {
            g.setColor(Color.black);
            g.fillRect(0, 0, w, h);
            return;
        }
        this._drawBackground(g, model, w, h);
        this._drawGrid(g, model, w, h);
    }

    private void _drawGrid(Graphics g, ILineModel model, int w, int h) {
        g.setColor(model.getLineStyle().getGridColor());
        g.drawLine(0, 0, w, 0);
        ITimeBarModel tbar = model.getTimeBar();
        long value_1 = tbar.mapXtoTime(0);
        long value_2 = tbar.mapXtoTime(w);
        long value0 = Math.min(value_1, value_2);
        long value1 = Math.max(value_1, value_2);
        int textH = g.getFontMetrics().getHeight();
        Timezone zone = tbar.getTimezone();
        long pos = tbar.getGridPos(value0);
        long step = tbar.getGridStep();
        int limit = w;
        while (pos < value1) {
            if (limit <= 0) break;
            --limit;
            int x = tbar.mapTimeToX(pos);
            Timestamp time = tbar.wrapValue(pos);
            g.drawLine(x, 0, x, 5);
            String str = zone.format(time);
            int i = str.indexOf(32);
            int y = 10;
            if (i > 0) {
                String strA = str.substring(0, i);
                String strB = str.substring(i + 1);
                g.drawString(strA, x, y += textH);
                g.drawString(strB, x, y += textH);
            } else {
                g.drawString(str, x, y += textH);
            }
            pos += step;
        }
    }

    private void _drawBackground(Graphics g, ILineModel model, int w, int h) {
        ILineStyle style = model.getLineStyle();
        g.setColor(style.getBackgroundColor());
        g.fillRect(0, 0, w, h);
    }

    @Override
    public void onEvent(IEvent event) {
        this.repaint(100L);
    }

    @Override
    protected void processMouseWheelEvent(MouseWheelEvent e) {
        super.processMouseWheelEvent(e);
    }
}

