/*
 * Decompiled with CFR 0.152.
 */
package ananas.cust.app.ir_therm.gui.widget;

import ananas.cust.app.ir_therm.event.IEvent;
import ananas.cust.app.ir_therm.event.IEventListener;
import ananas.cust.app.ir_therm.event.ModelChangedEvent;
import ananas.cust.app.ir_therm.gui.widget.line.ILineModel;
import java.awt.Color;
import java.awt.Graphics;
import javax.swing.JPanel;

public class LineViewCorner
extends JPanel {
    private static final long serialVersionUID = 1L;
    private ILineModel mModel;
    private int mMouseY;
    private int mMouseX;
    private final IEventListener mModelListener = new IEventListener(){

        @Override
        public void onEvent(IEvent event) {
            if (event instanceof ModelChangedEvent) {
                ModelChangedEvent e = (ModelChangedEvent)event;
                if ((e.mask & 0x10) != 0) {
                    LineViewCorner.this.repaint();
                }
            }
        }
    };

    @Override
    protected void paintComponent(Graphics g) {
        this._paintSelf(g);
    }

    private void _paintSelf(Graphics g) {
        ILineModel model = this.mModel;
        Color color = model == null ? Color.black : model.getLineStyle().getBackgroundColor();
        int w = this.getWidth();
        int h = this.getHeight();
        g.setColor(color);
        g.fillRect(0, 0, w, h);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setModel(ILineModel pnew) {
        ILineModel pold;
        LineViewCorner lineViewCorner = this;
        synchronized (lineViewCorner) {
            pold = this.mModel;
            this.mModel = pnew;
        }
        if (pold != null) {
            pold.removeListener(this.mModelListener);
        }
        if (pnew != null) {
            pnew.addListener(this.mModelListener);
        }
    }
}

