/*
 * Decompiled with CFR 0.152.
 */
package ananas.cust.app.ir_therm.gui.widget;

import ananas.cust.app.ir_therm.core.Temperature;
import ananas.cust.app.ir_therm.core.TemperatureUnit;
import ananas.cust.app.ir_therm.core.Timestamp;
import ananas.cust.app.ir_therm.core.Timezone;
import ananas.cust.app.ir_therm.event.IEvent;
import ananas.cust.app.ir_therm.event.IEventListener;
import ananas.cust.app.ir_therm.gui.widget.line.ILineLevel;
import ananas.cust.app.ir_therm.gui.widget.line.ILineModel;
import ananas.cust.app.ir_therm.gui.widget.line.ILineNode;
import ananas.cust.app.ir_therm.gui.widget.line.ILineStyle;
import ananas.cust.app.ir_therm.gui.widget.line.ITimeBarModel;
import ananas.cust.app.ir_therm.gui.widget.line.IValueBarModel;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.JPanel;

public class LineView
extends JPanel
implements MouseListener,
MouseMotionListener {
    private static final long serialVersionUID = 1L;
    private ILineModel mModel;
    private final IEventListener mModelListener = new IEventListener(){

        @Override
        public void onEvent(IEvent event) {
            LineView.this.repaint(100L);
        }
    };
    private MyMouseDragContext mCurMouseDrag;
    private MyMouseMoveContext mCurMouseMove;

    public LineView() {
        this.enableEvents(511L);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
    }

    @Override
    protected void paintComponent(Graphics g) {
        this._paintSelf(g);
    }

    private void _paintSelf(Graphics g) {
        ILineModel model = this.mModel;
        int cx = this.getWidth();
        int cy = this.getHeight();
        if (model == null) {
            int border = 20;
            g.setColor(Color.black);
            g.fillRect(20, 20, cx - 40, cy - 40);
            return;
        }
        this._drawBackground(g, model, cx, cy);
        if (model.isGridVisibleX()) {
            this._drawGridX(g, model, cx, cy);
        }
        if (model.isGridVisibleY()) {
            this._drawGridY(g, model, cx, cy);
        }
        if (model.isAlarmVisible()) {
            this._drawAlarmLine(g, model, cx, cy);
        }
        this._drawLineString(g, model, cx, cy);
        this._drawMouseDrag(g, model, cx, cy);
        if (model.isCursorCrossVisible()) {
            this._drawMouseCross(g, model, cx, cy);
        }
    }

    private void _drawAlarmLine(Graphics g, ILineModel model, int cx, int cy) {
    }

    private void _drawGridY(Graphics g, ILineModel model, int w, int h) {
        g.setColor(model.getLineStyle().getGridColor());
        IValueBarModel vbar = model.getValueBar();
        double value_1 = vbar.mapYtoValue(0);
        double value_2 = vbar.mapYtoValue(h);
        double value0 = Math.min(value_1, value_2);
        double value1 = Math.max(value_1, value_2);
        double pos = vbar.getGridPos(value0);
        double step = vbar.getGridStep();
        int limit = h;
        while (pos < value1) {
            if (limit <= 0) break;
            --limit;
            int y = vbar.mapValueToY(pos);
            g.drawLine(0, y, w, y);
            pos += step;
        }
    }

    private void _drawGridX(Graphics g, ILineModel model, int w, int h) {
        g.setColor(model.getLineStyle().getGridColor());
        ITimeBarModel tbar = model.getTimeBar();
        long value_1 = tbar.mapXtoTime(0);
        long value_2 = tbar.mapXtoTime(w);
        long value0 = Math.min(value_1, value_2);
        long value1 = Math.max(value_1, value_2);
        long pos = tbar.getGridPos(value0);
        long step = tbar.getGridStep();
        int limit = w;
        while (pos < value1) {
            if (limit <= 0) break;
            --limit;
            int x = tbar.mapTimeToX(pos);
            g.drawLine(x, 0, x, h);
            pos += step;
        }
    }

    private void _drawBackground(Graphics g, ILineModel model, int cx, int cy) {
        ILineStyle style = model.getLineStyle();
        Color bgColor = style.getBackgroundColor();
        g.setColor(bgColor);
        g.fillRect(0, 0, cx, cy);
    }

    private void _drawLineString(Graphics gr, ILineModel model, int cx, int cy) {
        block11: {
            ILineStyle style = model.getLineStyle();
            ITimeBarModel tbar = model.getTimeBar();
            IValueBarModel vbar = model.getValueBar();
            double ah = model.getHighAlarmValue();
            double al = model.getLowAlarmValue();
            int aly = vbar.mapValueToY(al);
            int ahy = vbar.mapValueToY(ah);
            Color colorLine = style.getLineColor();
            Color colorAH = style.getAlarmColorH();
            Color colorAL = style.getAlarmColorL();
            long from = tbar.mapXtoTime(0);
            long to = tbar.mapXtoTime(cx);
            ILineLevel list = model.findViewRange(from, to, cx);
            int cnt = list.countNode();
            MyGraphicsProxy gp = new MyGraphicsProxy(gr, ahy, aly, colorLine, colorAH, colorAL);
            if (cnt <= 0) break block11;
            if (cnt > cx * 5) {
                System.err.println("the cnt is too large:" + cnt);
                return;
            }
            ILineNode node0 = list.getNode(0);
            if (node0.timestamp0() == node0.timestamp1()) {
                int y1 = 0;
                int x1 = 0;
                int i = 0;
                while (i < cnt) {
                    ILineNode node = list.getNode(i);
                    long t0 = node.timestamp0();
                    double v0 = node.value0();
                    int x2 = tbar.mapTimeToX(t0);
                    int y2 = vbar.mapValueToY(v0);
                    if (i > 0) {
                        gp.drawLine(x1, y1, x2, y2);
                    }
                    x1 = x2;
                    y1 = y2;
                    gp.fillRect(x2 - 1, y2 - 1, 3, 3);
                    ++i;
                }
            } else {
                int ly1 = 0;
                int lx1 = 0;
                int i = 0;
                while (i < cnt) {
                    int m;
                    ILineNode node = list.getNode(i);
                    long t0 = node.timestamp0();
                    long t1 = node.timestamp1();
                    double v0 = node.value0();
                    double v1 = node.value1();
                    int x0 = tbar.mapTimeToX(t0);
                    int x1 = tbar.mapTimeToX(t1);
                    int y0 = vbar.mapValueToY(v0);
                    int y1 = vbar.mapValueToY(v1);
                    if (x0 > x1) {
                        m = x0;
                        x0 = x1;
                        x1 = m;
                    }
                    if (y0 > y1) {
                        m = y0;
                        y0 = y1;
                        y1 = m;
                    }
                    int rw = x1 - x0;
                    int rh = y1 - y0;
                    if (rw == 0) {
                        rw = 1;
                    }
                    if (rh == 0) {
                        rh = 1;
                    }
                    int lx2 = (x0 + x1) / 2;
                    int ly2 = (y0 + y1) / 2;
                    if (i > 0) {
                        gp.drawLine(lx1, ly1, lx2, ly2);
                    }
                    lx1 = lx2;
                    ly1 = ly2;
                    gp.fillRect(x0, y0, rw, rh);
                    ++i;
                }
            }
        }
    }

    private void _drawMouseDrag(Graphics g, ILineModel model, int w, int h) {
        MyMouseDragContext drag = this.mCurMouseDrag;
        if (drag == null) {
            return;
        }
        int x1 = drag.getX1();
        int x2 = drag.getX2();
        int y1 = drag.getY1();
        int y2 = drag.getY2();
        g.setColor(model.getLineStyle().getCursorColor());
        g.drawRect(x1, y1, x2 - x1, y2 - y1);
    }

    private void _drawMouseCross(Graphics g, ILineModel model, int w, int h) {
        MyMouseMoveContext move = this.mCurMouseMove;
        if (move == null) {
            return;
        }
        int x = move.getX();
        int y = move.getY();
        ITimeBarModel tbar = model.getTimeBar();
        IValueBarModel vbar = model.getValueBar();
        long time = tbar.mapXtoTime(x);
        ILineNode node = model.findNode(time);
        if (node == null) {
            return;
        }
        time = node.timestamp0();
        double value = node.value0();
        x = tbar.mapTimeToX(time);
        y = vbar.mapValueToY(value);
        g.setColor(model.getLineStyle().getCursorColor());
        g.drawLine(x, 0, x, h);
        g.drawLine(0, y, w, y);
        Timestamp _time = tbar.wrapValue(time);
        Temperature _value_x = vbar.wrapValue(value);
        Timezone zone = tbar.getTimezone();
        Temperature _value_c = TemperatureUnit.unit_c.convert(_value_x);
        Temperature _value_f = TemperatureUnit.unit_f.convert(_value_x);
        String index = node.id();
        String str = "index:" + index + "    x:" + zone.format(_time) + "    y:" + _value_c.toString() + " | " + _value_f.toString();
        int fontH = g.getFontMetrics().getHeight();
        g.drawString(str, 0, fontH);
    }

    public ILineModel getModel() {
        return this.mModel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setModel(ILineModel pnew) {
        ILineModel pold;
        LineView lineView = this;
        synchronized (lineView) {
            pold = this.mModel;
            this.mModel = pnew;
        }
        if (pold != null) {
            pold.removeListener(this.mModelListener);
        }
        if (pnew != null) {
            pnew.addListener(this.mModelListener);
        }
    }

    @Override
    public void setBounds(int x, int y, int width, int height) {
        super.setBounds(x, y, width, height);
        ILineModel model = this.mModel;
        if (model != null) {
            model.getTimeBar().setWidth(width);
            model.getValueBar().setHeight(height);
        }
    }

    @Override
    public void mouseClicked(MouseEvent arg0) {
    }

    @Override
    public void mouseEntered(MouseEvent arg0) {
    }

    @Override
    public void mouseExited(MouseEvent arg0) {
        this.mCurMouseMove = null;
        this.repaint();
    }

    @Override
    public void mousePressed(MouseEvent e) {
        int x = e.getX();
        int y = e.getY();
        this.mCurMouseDrag = new MyMouseDragContext(x, y);
        this.mCurMouseMove = null;
        this.repaint();
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        MyMouseDragContext drag = this.mCurMouseDrag;
        if (drag != null) {
            this._doDragZoom(drag);
        }
        this.mCurMouseDrag = null;
        this.mCurMouseMove = new MyMouseMoveContext(e.getX(), e.getY());
        this.repaint();
    }

    private void _doDragZoom(MyMouseDragContext drag) {
        double vScale;
        double vOff;
        int x1 = drag.getX1();
        int x2 = drag.getX2();
        int y1 = drag.getY1();
        int y2 = drag.getY2();
        int dtX = x1 - x2;
        int dtY = y1 - y2;
        if (Math.abs(dtX) < 10 || Math.abs(dtY) < 10) {
            return;
        }
        ILineModel model = this.getModel();
        ITimeBarModel tbar = model.getTimeBar();
        IValueBarModel vbar = model.getValueBar();
        long t1 = tbar.mapXtoTime(x1);
        long t2 = tbar.mapXtoTime(x2);
        double v1 = vbar.mapYtoValue(y2);
        double v2 = vbar.mapYtoValue(y1);
        double vMax = vbar.valueMax();
        double vMin = vbar.valueMin();
        long tMin = tbar.timeMin();
        long tMax = tbar.timeMax();
        if (v1 < vMin && v2 > vMax) {
            vOff = 0.5;
            vScale = 0.8;
        } else {
            vScale = (vMax - vMin) / (v2 - v1);
            vOff = (v1 - vMin) / (vMax - vMin - (v2 - v1));
        }
        double tScale = (double)(tMax - tMin) * 1.0 / (double)(t2 - t1);
        double tOff = (double)(t1 - tMin) * 1.0 / (double)(tMax - tMin - (t2 - t1));
        vbar.setOffset(vOff);
        vbar.setScale(vScale);
        tbar.setOffset(tOff);
        tbar.setScale(tScale);
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        int x = e.getX();
        int y = e.getY();
        MyMouseDragContext context = this.mCurMouseDrag;
        if (context != null) {
            context.setCurrentXY(x, y);
        }
        this.repaint();
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        int x = e.getX();
        int y = e.getY();
        this.mCurMouseMove = new MyMouseMoveContext(x, y);
        this.repaint();
    }

    static interface IGraphicsProxy {
        public void fillRect(int var1, int var2, int var3, int var4);

        public void drawLine(int var1, int var2, int var3, int var4);
    }

    class MyGraphicsProxy
    implements IGraphicsProxy {
        private final Graphics mg;
        private int mah;
        private int mal;
        private Color mch;
        private Color mcm;
        private Color mcl;

        public MyGraphicsProxy(Graphics gr, int ahy, int aly, Color colorLine, Color colorAH, Color colorAL) {
            this.mg = gr;
            this.mah = ahy;
            this.mal = aly;
            this.mch = colorAH;
            this.mcm = colorLine;
            this.mcl = colorAL;
        }

        @Override
        public void fillRect(int x, int y, int w, int h) {
            if (y <= this.mah) {
                this.mg.setColor(this.mch);
            } else if (y >= this.mal) {
                this.mg.setColor(this.mcl);
            } else {
                this.mg.setColor(this.mcm);
            }
            this.mg.fillRect(x, y, w, h);
        }

        @Override
        public void drawLine(int x1, int y1, int x2, int y2) {
            if (y1 <= this.mah) {
                this.mg.setColor(this.mch);
            } else if (y1 >= this.mal) {
                this.mg.setColor(this.mcl);
            } else {
                this.mg.setColor(this.mcm);
            }
            this.mg.drawLine(x1, y1, x2, y2);
        }
    }

    private class MyMouseDragContext {
        private final int mX1;
        private final int mY1;
        private int mX2;
        private int mY2;

        public MyMouseDragContext(int x, int y) {
            this.mX2 = this.mX1 = x;
            this.mY2 = this.mY1 = y;
        }

        public int getY2() {
            return Math.max(this.mY1, this.mY2);
        }

        public int getX1() {
            return Math.min(this.mX1, this.mX2);
        }

        public int getX2() {
            return Math.max(this.mX1, this.mX2);
        }

        public int getY1() {
            return Math.min(this.mY1, this.mY2);
        }

        public void setCurrentXY(int x, int y) {
            this.mX2 = x;
            this.mY2 = y;
        }
    }

    private class MyMouseMoveContext {
        private final int mY;
        private final int mX;

        public MyMouseMoveContext(int x, int y) {
            this.mY = y;
            this.mX = x;
        }

        public int getX() {
            return this.mX;
        }

        public int getY() {
            return this.mY;
        }
    }
}

