/*
 * Decompiled with CFR 0.152.
 */
package ananas.cust.app.ir_therm.gui.widget;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;

public class ColorCombo
extends JComboBox {
    private static final long serialVersionUID = 1L;
    final ActionListener mActionListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent arg0) {
            ColorCombo.this._onItemSel();
        }
    };
    private Color mColor = Color.GRAY;
    private ColorListener mColorListener = new ColorListener(){

        @Override
        public void onColorChanged(Color color) {
            System.out.println("new color:" + color);
        }
    };

    public ColorCombo() {
        this.setPreferredSize(new Dimension(72, 24));
        ArrayList<Color> v = new ArrayList<Color>();
        v.add(Color.GRAY);
        v.add(Color.BLACK);
        v.add(Color.WHITE);
        v.add(Color.GRAY);
        v.add(Color.RED);
        v.add(Color.GREEN);
        v.add(Color.BLUE);
        v.add(Color.cyan);
        v.add(Color.darkGray);
        v.add(Color.lightGray);
        v.add(Color.magenta);
        v.add(Color.orange);
        v.add(Color.pink);
        v.add(Color.yellow);
        DefaultComboBoxModel<ColorItem> model = new DefaultComboBoxModel<ColorItem>();
        for (Color color : v) {
            model.addElement(new ColorItem(color));
        }
        model.addElement(new ColorItem(null));
        this.setEditor(null);
        this.setModel(model);
        this.setRenderer(new ColorRenderer());
        this.addActionListener(this.mActionListener);
    }

    private void _onItemSel() {
        ColorItem item = (ColorItem)this.getSelectedItem();
        Color color = item.mColor;
        if (color == null && (color = JColorChooser.showDialog(this, "select color", this.mColor)) == null) {
            color = this.mColor;
        }
        this.setColor(color);
    }

    private void _colorToUI() {
        ColorItem item = (ColorItem)this.getModel().getElementAt(0);
        item.setColor(this.mColor);
        this.setSelectedItem(item);
        this.repaint();
    }

    public void setColorListener(ColorListener cl) {
        this.mColorListener = cl;
    }

    public void setColor(Color color) {
        if (color == null) {
            return;
        }
        boolean changed = !color.equals(this.mColor);
        this.mColor = color;
        this._colorToUI();
        ColorListener cl = this.mColorListener;
        if (cl != null && changed) {
            cl.onColorChanged(color);
        }
    }

    public Color getColor() {
        return this.mColor;
    }

    public static class ColorItem {
        private Color mColor;

        public ColorItem(Color color) {
            this.mColor = color;
        }

        public void setColor(Color color) {
            if (color != null) {
                this.mColor = color;
            }
        }
    }

    public static interface ColorListener {
        public void onColorChanged(Color var1);
    }

    static class ColorRenderer
    extends JPanel
    implements ListCellRenderer {
        private static final long serialVersionUID = 1L;
        final JLabel mLabel = new JLabel();
        final JPanel mBox = new JPanel();

        public ColorRenderer() {
            this.setPreferredSize(new Dimension(24, 24));
            this.setLayout(new GridLayout(1, 1));
            this.mBox.setLayout(new GridLayout(1, 1));
            this.add(this.mBox);
            this.mBox.add(this.mLabel);
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Color color = ((ColorItem)value).mColor;
            String txt = "";
            if (color == null) {
                txt = "more...";
                color = Color.white;
            }
            this.mBox.setBackground(color);
            this.mLabel.setText(txt);
            return this;
        }
    }
}

