/*
 * Decompiled with CFR 0.152.
 */
package ananas.cust.app.ir_therm.gui;

import ananas.cust.app.ir_therm.core.IDataBuffer;
import ananas.cust.app.ir_therm.core.IDataCenter;
import ananas.cust.app.ir_therm.core.Temperature;
import ananas.cust.app.ir_therm.core.TemperatureUnit;
import ananas.cust.app.ir_therm.core.ThermoResult;
import ananas.cust.app.ir_therm.core.Timestamp;
import ananas.cust.app.ir_therm.core.Timezone;
import ananas.cust.app.ir_therm.event.IEvent;
import ananas.cust.app.ir_therm.event.IEventListener;
import ananas.cust.app.ir_therm.event.ModelChangedEvent;
import javax.swing.table.AbstractTableModel;

public class TheTableModel
extends AbstractTableModel {
    private static final long serialVersionUID = 2817601537685874951L;
    private String[] mColList;
    private IDataBuffer mBuffer;
    private final IDataCenter mDataCenter;
    private int mLastCount;
    private Timezone mZone;
    private TemperatureUnit mUnitCache;

    public TheTableModel(IDataCenter dc) {
        this.mDataCenter = dc;
        String[] array = new String[]{"index", "time", "value", "unit"};
        this.mColList = array;
        this._listen(dc);
    }

    private void _listen(IDataCenter dc) {
        dc.getEventDispatcher().addListener(new IEventListener(){

            @Override
            public void onEvent(IEvent event) {
                if (event instanceof ModelChangedEvent) {
                    ModelChangedEvent e = (ModelChangedEvent)event;
                    if (e.mask != 0) {
                        if ((e.mask & 0x10) != 0) {
                            TheTableModel.this._onDataReset();
                        } else if ((e.mask & 8) != 0) {
                            TheTableModel.this._onDataUpdate();
                        }
                    }
                }
            }
        });
    }

    protected void _onDataReset() {
        this.mUnitCache = null;
        IDataBuffer buff = this.mDataCenter.getCurrentBuffer();
        this._setBuffer(buff);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _setBuffer(IDataBuffer pnew) {
        IDataBuffer pold;
        TheTableModel theTableModel = this;
        synchronized (theTableModel) {
            pold = this.mBuffer;
            this.mBuffer = pnew;
        }
        if (pnew == null) {
            if (pold == null) {
                boolean bufch = false;
            } else {
                boolean bufch = true;
            }
        } else if (pold == null) {
            boolean bufch = true;
        } else {
            boolean bufch = !pold.equals(pnew);
        }
        this.fireTableDataChanged();
    }

    protected void _onDataUpdate() {
        IDataBuffer buff = this.mBuffer;
        if (buff == null) {
            return;
        }
        int cnt = buff.count();
        if (cnt == this.mLastCount) {
            return;
        }
        if (cnt < this.mLastCount) {
            this.fireTableRowsDeleted(cnt, this.mLastCount);
        } else if (cnt > this.mLastCount) {
            this.fireTableRowsInserted(this.mLastCount, cnt);
        }
        this.mLastCount = cnt;
    }

    @Override
    public Class<?> getColumnClass(int arg0) {
        return String.class;
    }

    @Override
    public int getColumnCount() {
        return this.mColList.length;
    }

    @Override
    public String getColumnName(int arg0) {
        return this.mColList[arg0];
    }

    @Override
    public int getRowCount() {
        IDataBuffer buff = this.mBuffer;
        if (buff == null) {
            return 0;
        }
        return this.mBuffer.count();
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        IDataBuffer buff = this.mBuffer;
        if (buff == null) {
            return null;
        }
        ThermoResult rlt = this.mBuffer.get(rowIndex);
        switch (columnIndex) {
            case 0: {
                return String.valueOf(rlt.getIndex());
            }
            case 1: {
                return this._getTimestampString(rlt);
            }
            case 2: {
                return this._getValueString(rlt);
            }
            case 3: {
                return this._getUnitString(rlt);
            }
        }
        return "" + rlt;
    }

    private Object _getUnitString(ThermoResult rlt) {
        TemperatureUnit unit = this._getUnit();
        return unit.toString();
    }

    private TemperatureUnit _getUnit() {
        TemperatureUnit unit = this.mUnitCache;
        if (unit == null) {
            this.mUnitCache = unit = this.mDataCenter.getUnit();
        }
        return unit;
    }

    private String _getValueString(ThermoResult rlt) {
        TemperatureUnit unit = this._getUnit();
        Temperature tempe = unit.convert(rlt.getTemperature());
        return tempe.getValueString();
    }

    private Object _getTimestampString(ThermoResult rlt) {
        Timezone zone = this._getTimezone();
        Timestamp time = rlt.getTimestamp();
        return zone.format(time);
    }

    private Timezone _getTimezone() {
        Timezone zone = this.mZone;
        if (zone == null) {
            this.mZone = zone = Timezone.getLocalZone();
        }
        return zone;
    }

    @Override
    public boolean isCellEditable(int arg0, int arg1) {
        return false;
    }
}

