/*
 * Decompiled with CFR 0.152.
 */
package ananas.cust.app.ir_therm.gui;

import ananas.cust.app.ir_therm.core.IColorStyle;
import ananas.cust.app.ir_therm.core.IDataBuffer;
import ananas.cust.app.ir_therm.core.IDataCenter;
import ananas.cust.app.ir_therm.core.IDocSettings;
import ananas.cust.app.ir_therm.core.Temperature;
import ananas.cust.app.ir_therm.core.TemperatureUnit;
import ananas.cust.app.ir_therm.core.ThermoResult;
import ananas.cust.app.ir_therm.core.Timezone;
import ananas.cust.app.ir_therm.event.IEvent;
import ananas.cust.app.ir_therm.event.IEventListener;
import ananas.cust.app.ir_therm.event.ModelChangedEvent;
import ananas.cust.app.ir_therm.gui.widget.line.AbstractLineModel;
import ananas.cust.app.ir_therm.gui.widget.line.ILineLevelSet;
import ananas.cust.app.ir_therm.gui.widget.line.ILineNode;
import ananas.cust.app.ir_therm.gui.widget.line.ILineStyle;
import ananas.cust.app.ir_therm.gui.widget.line.ITimeBarModel;
import ananas.cust.app.ir_therm.gui.widget.line.IValueBarModel;
import java.awt.Color;

public class TheLineModel
extends AbstractLineModel {
    private final IDataCenter mDataCenter;
    private IDataBuffer mCurBuffer;
    private TemperatureUnit mUnit = TemperatureUnit.unit_c;
    private Timezone mZone = Timezone.getLocalZone();
    private final ILineStyle myStyle = new ILineStyle(){

        @Override
        public Color getBackgroundColor() {
            return this._getColorStyle().getLineBgColor();
        }

        private IColorStyle _getColorStyle() {
            return TheLineModel.this.mDataCenter.getColorStyle();
        }

        @Override
        public Color getLineColor() {
            return this._getColorStyle().getLineFgColor();
        }

        @Override
        public Color getGridColor() {
            return this._getColorStyle().getGridColor();
        }

        @Override
        public Color getAlarmColorH() {
            return this._getColorStyle().getHighAlarmColor();
        }

        @Override
        public Color getAlarmColorL() {
            return this._getColorStyle().getLowAlarmColor();
        }

        @Override
        public Color getCursorColor() {
            return Color.yellow;
        }
    };
    private double mAlarmValueL;
    private double mAlarmValueH;

    public TheLineModel(IDataCenter dc) {
        this.mDataCenter = dc;
        this._linsten(dc);
    }

    private void _linsten(IDataCenter dc) {
        dc.getEventDispatcher().addListener(new IEventListener(){

            @Override
            public void onEvent(IEvent event) {
                if (event instanceof ModelChangedEvent) {
                    ModelChangedEvent e = (ModelChangedEvent)event;
                    if (e.mask != 0) {
                        if ((e.mask & 0x10) != 0) {
                            TheLineModel.this._onDataReset();
                        } else if ((e.mask & 1) != 0) {
                            TheLineModel.this._onDataUpdate();
                        } else if ((e.mask & 8) != 0) {
                            TheLineModel.this._onDataUpdate();
                        }
                    }
                }
            }
        });
    }

    protected void _onDataUpdate() {
        TemperatureUnit unit = this.mUnit;
        IDataBuffer buff = this.mDataCenter.getCurrentBuffer();
        IDataBuffer buff2 = this.mCurBuffer;
        if (buff == null || buff2 == null) {
            this._onDataReset();
            return;
        }
        if (buff.equals(buff2)) {
            int cnt2;
            ILineLevelSet lls = this.getLineLevelSet();
            int cnt1 = buff.count();
            int i = cnt2 = lls.countNode();
            while (i < cnt1) {
                ThermoResult item = buff.get(i);
                lls.addNode(new MyLineNode(item, unit));
                ++i;
            }
            this._autoZoom(0.8);
            this.fireModelUpdate();
        }
    }

    private void _autoZoom(double fillPercent) {
        long tMax;
        long tMin;
        boolean hard = fillPercent > 0.95;
        ILineLevelSet lls = this.getLineLevelSet();
        int cnt = lls.countNode();
        if (cnt > 0) {
            tMin = lls.getNode(0).timestamp0();
            tMax = lls.getNode(cnt - 1).timestamp1();
        } else {
            tMax = 0L;
            tMin = 0L;
        }
        double vMin = lls.minValue() - 0.1;
        double vMax = lls.maxValue() + 0.1;
        ITimeBarModel tbar = this.getTimeBar();
        IValueBarModel vbar = this.getValueBar();
        if (hard) {
            tbar.setOffset(0.0);
            tbar.setScale(1.0);
            tbar.setTimeLimit(tMin, tMax);
        } else {
            long right = tbar.mapXtoTime(tbar.width());
            if (tMax >= right) {
                tbar.setOffset(0.0);
                tbar.setScale(1.0);
                double max2 = (double)tMin + (double)(tMax - tMin) / fillPercent;
                tbar.setTimeLimit(tMin, (long)max2);
            }
        }
        vbar.setValueLimit(vMin, vMax);
        vbar.setScale(0.8);
        vbar.setOffset(0.5);
    }

    protected void _onDataReset() {
        IDataBuffer buff;
        System.out.println(this + "._onDataReset()");
        TemperatureUnit unit = this._setUnit(this.mDataCenter.getUnit());
        this.mCurBuffer = buff = this.mDataCenter.getCurrentBuffer();
        if (buff != null) {
            IDocSettings settings = buff.getSubDocument().getMainDocument().getSettings();
            this.mAlarmValueH = unit.convert(settings.getHighAlarm()).getValue();
            this.mAlarmValueL = unit.convert(settings.getLowAlarm()).getValue();
            ILineLevelSet lls = this.getLineLevelSet();
            lls.reset();
            int cnt = buff.count();
            int i = 0;
            while (i < cnt) {
                ThermoResult item = buff.get(i);
                lls.addNode(new MyLineNode(item, unit));
                ++i;
            }
            this._autoZoom(1.0);
            this.fireModelChanged();
        }
    }

    private TemperatureUnit _setUnit(TemperatureUnit unit) {
        if (unit == null) {
            return this.mUnit;
        }
        this.mUnit = unit;
        return unit;
    }

    @Override
    protected Timezone getTimezone() {
        return this.mZone;
    }

    @Override
    protected TemperatureUnit getUnit() {
        return this.mUnit;
    }

    @Override
    public boolean isGridVisibleX() {
        IColorStyle cs = this.mDataCenter.getColorStyle();
        return cs.isVisibleGridX();
    }

    @Override
    public boolean isGridVisibleY() {
        IColorStyle cs = this.mDataCenter.getColorStyle();
        return cs.isVisibleGridY();
    }

    @Override
    public boolean isCursorCrossVisible() {
        IColorStyle cs = this.mDataCenter.getColorStyle();
        return cs.isVisibleCursorCross();
    }

    @Override
    public ILineStyle getLineStyle() {
        return this.myStyle;
    }

    @Override
    public boolean isAlarmVisible() {
        return true;
    }

    @Override
    public double getHighAlarmValue() {
        return this.mAlarmValueH;
    }

    @Override
    public double getLowAlarmValue() {
        return this.mAlarmValueL;
    }

    @Override
    public void doAutoZoom() {
        this._autoZoom(1.0);
    }

    private class MyLineNode
    implements ILineNode {
        private final ThermoResult mTarget;
        private final long mTime;
        private final double mValue;
        private ILineNode mChild;

        public MyLineNode(ThermoResult item, TemperatureUnit unit) {
            this.mTarget = item;
            Temperature temp = item.getTemperature();
            temp = unit.convert(temp);
            this.mTime = item.getTimestamp().milliseconds();
            this.mValue = temp.getValue();
        }

        @Override
        public ILineNode parent0() {
            return null;
        }

        @Override
        public ILineNode parent1() {
            return null;
        }

        @Override
        public ILineNode child() {
            return this.mChild;
        }

        @Override
        public long timestamp0() {
            return this.mTime;
        }

        @Override
        public long timestamp1() {
            return this.mTime;
        }

        @Override
        public double value0() {
            return this.mValue;
        }

        @Override
        public double value1() {
            return this.mValue;
        }

        @Override
        public void rebuild() {
            ILineNode ch = this.mChild;
            if (ch != null) {
                ch.rebuild();
            }
        }

        @Override
        public void setChild(ILineNode ch) {
            this.mChild = ch;
        }

        @Override
        public void setParent1(ILineNode ch) {
        }

        @Override
        public void setParent0(ILineNode ch) {
        }

        @Override
        public String id() {
            return String.valueOf(this.mTarget.getIndex());
        }
    }
}

