/*
 * Decompiled with CFR 0.152.
 */
package ananas.cust.app.ir_therm.gui;

import ananas.cust.app.ir_therm.core.IDataCenter;
import ananas.cust.app.ir_therm.event.ModelChangedEvent;
import ananas.cust.app.ir_therm.gui.IMainFrame;
import ananas.cust.app.ir_therm.gui.TheLineModel;
import ananas.cust.app.ir_therm.gui.widget.LineView;
import ananas.cust.app.ir_therm.gui.widget.LineViewCorner;
import ananas.cust.app.ir_therm.gui.widget.TimeRuler;
import ananas.cust.app.ir_therm.gui.widget.ValueRuler;
import ananas.cust.app.ir_therm.gui.widget.line.ILineModel;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import javax.swing.BoundedRangeModel;
import javax.swing.DefaultBoundedRangeModel;
import javax.swing.JScrollBar;

public class TheLineCtrl {
    private final IMainFrame mFrame;
    private final ILineModel mLineModel;
    static final int max_value = 1000;

    public TheLineCtrl(IMainFrame frame) {
        this.mFrame = frame;
        this.mLineModel = this._init();
    }

    private ILineModel _init() {
        IDataCenter dc = this.mFrame.getDataCenter();
        LineView lv = this.mFrame.getLineView();
        TimeRuler tr = this.mFrame.getTimeRuler();
        ValueRuler vr = this.mFrame.getValueRuler();
        LineViewCorner lvc = this.mFrame.getLineViewCorner();
        TheLineModel model = new TheLineModel(dc);
        lv.setModel(model);
        tr.setModel(model);
        vr.setModel(model);
        lvc.setModel(model);
        JScrollBar tscroll = this.mFrame.getLineScrollBarT();
        JScrollBar vscroll = this.mFrame.getLineScrollBarV();
        this._listenVScroll(vscroll, model);
        this._listenTScroll(tscroll, model);
        return model;
    }

    private void _listenTScroll(final JScrollBar tscroll, final ILineModel model) {
        DefaultBoundedRangeModel brModel = new DefaultBoundedRangeModel();
        brModel.setRangeProperties(500, 100, 0, 1000, true);
        tscroll.setModel(brModel);
        tscroll.addAdjustmentListener(new AdjustmentListener(){

            @Override
            public void adjustmentValueChanged(AdjustmentEvent event) {
                BoundedRangeModel brm = tscroll.getModel();
                double max = brm.getMaximum();
                double min = brm.getMinimum();
                double ext = brm.getExtent();
                double value = brm.getValue();
                double off = value / (max - min - ext);
                model.getTimeBar().setOffset(off *= 1.001);
                TheLineCtrl.this._modelToView();
            }
        });
    }

    protected void _modelToView() {
        this.mLineModel.dispatchEvent(new ModelChangedEvent(this, 1));
    }

    private void _listenVScroll(final JScrollBar vscroll, final ILineModel model) {
        DefaultBoundedRangeModel brModel = new DefaultBoundedRangeModel();
        brModel.setRangeProperties(500, 100, 0, 1000, true);
        vscroll.setModel(brModel);
        vscroll.addAdjustmentListener(new AdjustmentListener(){

            @Override
            public void adjustmentValueChanged(AdjustmentEvent event) {
                BoundedRangeModel brm = vscroll.getModel();
                double max = brm.getMaximum();
                double min = brm.getMinimum();
                double ext = brm.getExtent();
                double value = brm.getValue();
                double off = value / (max - min - ext);
                off *= 1.001;
                off = 1.0 - off;
                model.getValueBar().setOffset(off);
                TheLineCtrl.this._modelToView();
            }
        });
    }
}

