/*
 * Decompiled with CFR 0.152.
 */
package ananas.cust.app.ir_therm.gui;

import ananas.cust.app.ir_therm.core.SampleRate;
import ananas.cust.app.ir_therm.core.Temperature;
import ananas.cust.app.ir_therm.core.TemperatureUnit;
import ananas.cust.app.ir_therm.gui.Bp2Ctrl;
import ananas.lib.blueprint2.dom.IDocument;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JTextField;

public class StartRecDialogCtrl
extends Bp2Ctrl {
    public final Settings settings = new Settings();
    private final JDialog mDialog;
    private final JButton mBtnCancel;
    private final JButton mBtnOK;
    private final JTextField mTxtAlarmH;
    private final JTextField mTxtAlarmL;
    private final JComboBox mCombSampleRate;
    private final JComboBox mCombUnit;

    public StartRecDialogCtrl() {
        IDocument doc = this._loadXml();
        this.mDialog = (JDialog)doc.findTargetById("root");
        this.mBtnCancel = (JButton)doc.findTargetById("btn_cancel");
        this.mBtnOK = (JButton)doc.findTargetById("btn_ok");
        this.mTxtAlarmH = (JTextField)doc.findTargetById("text_high_alarm");
        this.mTxtAlarmL = (JTextField)doc.findTargetById("text_low_alarm");
        this.mCombUnit = (JComboBox)doc.findTargetById("combo_unit");
        this.mCombSampleRate = (JComboBox)doc.findTargetById("combo_sample_rate");
        this.mBtnCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                StartRecDialogCtrl.this._onClickCancel();
            }
        });
        this.mBtnOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                StartRecDialogCtrl.this._onClickOK();
            }
        });
        DefaultComboBoxModel<Object> model = new DefaultComboBoxModel<Object>();
        int i = 1;
        while (i <= 60) {
            model.addElement(new SampleRate(i * 1000));
            ++i;
        }
        this.mCombSampleRate.setModel(model);
        model = new DefaultComboBoxModel();
        model.addElement(TemperatureUnit.unit_c);
        model.addElement(TemperatureUnit.unit_f);
        this.mCombUnit.setModel(model);
    }

    protected void _onClickCancel() {
        this.settings.isok = false;
        this.mDialog.setVisible(false);
    }

    protected void _onClickOK() {
        this.settings.isok = true;
        this.mDialog.setVisible(false);
    }

    private IDocument _loadXml() {
        IDocument doc = this.loadDocument("resource:///StartRecDialog.xml");
        return doc;
    }

    public void doModel() {
        this._settingsToUI();
        this.mDialog.setResizable(false);
        this.mDialog.setModal(true);
        this.mDialog.setVisible(true);
        this._uiToSettings();
    }

    private void _uiToSettings() {
        TemperatureUnit unit;
        Settings sett = this.settings;
        double al = this._safe_double_from_text(this.mTxtAlarmL.getText());
        double ah = this._safe_double_from_text(this.mTxtAlarmH.getText());
        sett.unit = unit = (TemperatureUnit)this.mCombUnit.getSelectedItem();
        sett.sampleRate = (SampleRate)this.mCombSampleRate.getSelectedItem();
        sett.lowAlarm = unit.objectForValue(al);
        sett.highAlarm = unit.objectForValue(ah);
    }

    private double _safe_double_from_text(String text) {
        try {
            return Double.parseDouble(text);
        }
        catch (Exception e) {
            return 0.0;
        }
    }

    private void _settingsToUI() {
        Settings sett = this.settings;
        TemperatureUnit unit = sett.unit;
        SampleRate rate = sett.sampleRate;
        Temperature ah = sett.highAlarm;
        Temperature al = sett.lowAlarm;
        if (unit == null) {
            unit = TemperatureUnit.unit_c;
        }
        if (rate == null) {
            rate = new SampleRate(1000);
        }
        if (al == null) {
            al = unit.objectForValue(0.0);
        }
        if (ah == null) {
            ah = unit.objectForValue(40.0);
        }
        this.mCombSampleRate.setSelectedItem(rate);
        this.mCombUnit.setSelectedItem(unit);
        this.mTxtAlarmH.setText(ah.getValueString());
        this.mTxtAlarmL.setText(al.getValueString());
    }

    public JDialog getDialog() {
        return this.mDialog;
    }

    public static class Settings {
        boolean isok = false;
        SampleRate sampleRate;
        TemperatureUnit unit;
        Temperature highAlarm;
        Temperature lowAlarm;
    }
}

