/*
 * Decompiled with CFR 0.152.
 */
package ananas.cust.app.ir_therm.gui;

import ananas.cust.app.ir_therm.core.IColorStyle;
import ananas.cust.app.ir_therm.core.IDataCenter;
import ananas.cust.app.ir_therm.core.IDocSettings;
import ananas.cust.app.ir_therm.core.IMainDoc;
import ananas.cust.app.ir_therm.core.ISubDoc;
import ananas.cust.app.ir_therm.core.SampleRate;
import ananas.cust.app.ir_therm.core.Temperature;
import ananas.cust.app.ir_therm.core.TemperatureUnit;
import ananas.cust.app.ir_therm.event.IEvent;
import ananas.cust.app.ir_therm.event.IEventListener;
import ananas.cust.app.ir_therm.event.ModelChangedEvent;
import ananas.cust.app.ir_therm.gui.IMainFrame;
import ananas.cust.app.ir_therm.gui.widget.ColorCombo;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.JTextField;

public class SettingsCtrl {
    private final IMainFrame mFrame;
    private final JTextField mMainFileName;
    private final JTextField mHighAlarm;
    private final JTextField mSampleRate;
    private final JTextField mLowAlarm;
    private final JComboBox mSubDocList;
    private final ColorCombo mColorBg;
    private final ColorCombo mColorAlarmH;
    private final ColorCombo mColorFg;
    private final ColorCombo mColorAlarmL;
    private final JCheckBoxMenuItem mMenuItemViewCross;
    private final JCheckBoxMenuItem mMenuItemViewGridX;
    private final JCheckBoxMenuItem mMenuItemViewGridY;

    public SettingsCtrl(IMainFrame frame) {
        this.mFrame = frame;
        this.mLowAlarm = frame.getLowAlarm();
        this.mHighAlarm = frame.getHighAlarm();
        this.mSampleRate = frame.getSampleRate();
        this.mMainFileName = frame.getMainFileName();
        this.mSubDocList = frame.getSubList();
        this.mColorBg = frame.getBgColor();
        this.mColorFg = frame.getFgColor();
        this.mColorAlarmH = frame.getAlarmHighColor();
        this.mColorAlarmL = frame.getAlarmLowColor();
        this.mMenuItemViewCross = frame.getMenuItemViewCross();
        this.mMenuItemViewGridX = frame.getMenuItemViewGridX();
        this.mMenuItemViewGridY = frame.getMenuItemViewGridY();
        this._listen(frame.getDataCenter());
        this._initSubDocList(this.mSubDocList);
        this._initColorBg(this.mColorBg);
        this._initColorFg(this.mColorFg);
        this._initColorAlarmH(this.mColorAlarmH);
        this._initColorAlarmL(this.mColorAlarmL);
    }

    private void _initColorAlarmL(ColorCombo cc) {
        cc.setColorListener(new ColorCombo.ColorListener(){

            @Override
            public void onColorChanged(Color color) {
                SettingsCtrl sc = SettingsCtrl.this;
                IDataCenter dc = sc.mFrame.getDataCenter();
                dc.getColorStyle().setLowAlarmColor(color);
            }
        });
    }

    private void _initColorAlarmH(ColorCombo cc) {
        cc.setColorListener(new ColorCombo.ColorListener(){

            @Override
            public void onColorChanged(Color color) {
                SettingsCtrl sc = SettingsCtrl.this;
                IDataCenter dc = sc.mFrame.getDataCenter();
                dc.getColorStyle().setHighAlarmColor(color);
            }
        });
    }

    private void _initColorFg(ColorCombo cc) {
        cc.setColorListener(new ColorCombo.ColorListener(){

            @Override
            public void onColorChanged(Color color) {
                SettingsCtrl sc = SettingsCtrl.this;
                IDataCenter dc = sc.mFrame.getDataCenter();
                dc.getColorStyle().setLineFgColor(color);
            }
        });
    }

    private void _initColorBg(ColorCombo cc) {
        cc.setColorListener(new ColorCombo.ColorListener(){

            @Override
            public void onColorChanged(Color color) {
                SettingsCtrl sc = SettingsCtrl.this;
                IDataCenter dc = sc.mFrame.getDataCenter();
                dc.getColorStyle().setLineBgColor(color);
            }
        });
    }

    private void _initSubDocList(JComboBox cbox) {
        cbox.setRenderer(new MySubListRenderer());
        cbox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                SettingsCtrl.this._onSubDocSelected();
            }
        });
    }

    protected void _onSubDocSelected() {
        JComboBox cbox = this.mSubDocList;
        Object item = cbox.getSelectedItem();
        if (item instanceof ISubDoc) {
            ISubDoc sd = (ISubDoc)item;
            this.mFrame.getDataCenter().setCurrentSubDoc(sd);
            System.out.println(this + "._onSubDocSelected()");
        }
    }

    private void _listen(IDataCenter dc) {
        dc.getEventDispatcher().addListener(new IEventListener(){

            @Override
            public void onEvent(IEvent event) {
                if (event instanceof ModelChangedEvent) {
                    ModelChangedEvent e = (ModelChangedEvent)event;
                    if (e.mask != 0) {
                        if ((e.mask & 1) != 0) {
                            SettingsCtrl.this._doUpdate();
                        } else if ((e.mask & 0x10) != 0) {
                            SettingsCtrl.this._doUpdate();
                        }
                    }
                }
            }
        });
    }

    protected void _doUpdate() {
        IDataCenter dc = this.mFrame.getDataCenter();
        TemperatureUnit unit = dc.getUnit();
        IMainDoc md = dc.getMainDoc();
        if (md == null) {
            return;
        }
        IColorStyle cs = dc.getColorStyle();
        IDocSettings settings = md.getSettings();
        File file2 = md.getFile();
        this.mMainFileName.setText(file2.getName());
        SampleRate rate = settings.getSampleRate();
        this.mSampleRate.setText("" + rate);
        Temperature alarmH = settings.getHighAlarm();
        alarmH = unit.convert(alarmH);
        this.mHighAlarm.setText(alarmH.toString());
        this.mColorAlarmH.setColor(cs.getHighAlarmColor());
        Temperature alarmL = settings.getLowAlarm();
        alarmL = unit.convert(alarmL);
        this.mLowAlarm.setText(alarmL.toString());
        this.mColorAlarmL.setColor(cs.getLowAlarmColor());
        this._loadSubFileList(dc.getCurrentSubDoc());
        this.mColorBg.setColor(cs.getLineBgColor());
        this.mColorFg.setColor(cs.getLineFgColor());
        this.mMenuItemViewCross.setSelected(cs.isVisibleCursorCross());
        this.mMenuItemViewGridX.setSelected(cs.isVisibleGridX());
        this.mMenuItemViewGridY.setSelected(cs.isVisibleGridY());
    }

    private void _loadSubFileList(ISubDoc curSub) {
        if (curSub == null) {
            this.mSubDocList.setModel(new DefaultComboBoxModel());
            return;
        }
        IMainDoc md = curSub.getMainDocument();
        DefaultComboBoxModel<ISubDoc> model = new DefaultComboBoxModel<ISubDoc>();
        int cnt = md.countSubDoc();
        int i = 0;
        while (i < cnt) {
            ISubDoc sd = md.getSubDoc(i);
            model.addElement(sd);
            ++i;
        }
        model.setSelectedItem(curSub);
        this.mSubDocList.setModel(model);
    }

    class MySubListRenderer
    extends DefaultListCellRenderer {
        MySubListRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (value instanceof ISubDoc) {
                ISubDoc sd = (ISubDoc)value;
                String name = sd.getFile().getName();
                value = name;
            }
            return super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
        }
    }
}

