/*
 * Decompiled with CFR 0.152.
 */
package ananas.cust.app.ir_therm.gui;

import ananas.cust.app.ir_therm.core.IColorStyle;
import ananas.cust.app.ir_therm.core.IDataBuffer;
import ananas.cust.app.ir_therm.core.IDataCenter;
import ananas.cust.app.ir_therm.core.IDocSettings;
import ananas.cust.app.ir_therm.core.IMainDoc;
import ananas.cust.app.ir_therm.core.IThermo;
import ananas.cust.app.ir_therm.core.TemperatureUnit;
import ananas.cust.app.ir_therm.core.Timestamp;
import ananas.cust.app.ir_therm.core.Timezone;
import ananas.cust.app.ir_therm.event.IEvent;
import ananas.cust.app.ir_therm.event.IEventListener;
import ananas.cust.app.ir_therm.event.ModelChangedEvent;
import ananas.cust.app.ir_therm.gui.Bp2Ctrl;
import ananas.cust.app.ir_therm.gui.IMainFrame;
import ananas.cust.app.ir_therm.gui.StartRecDialogCtrl;
import ananas.cust.app.ir_therm.gui.print.PrintFactory;
import ananas.cust.app.ir_therm.gui.widget.ColorCombo;
import ananas.cust.app.ir_therm.gui.widget.LineView;
import ananas.cust.app.ir_therm.gui.widget.LineViewCorner;
import ananas.cust.app.ir_therm.gui.widget.TimeRuler;
import ananas.cust.app.ir_therm.gui.widget.ValueRuler;
import ananas.cust.app.ir_therm.gui.widget.line.ILineModel;
import ananas.cust.app.ir_therm.gui.widget.line.ITimeBarModel;
import ananas.cust.app.ir_therm.gui.widget.line.IValueBarModel;
import ananas.lib.blueprint2.awt.util.Awt_responseChainNode;
import ananas.lib.blueprint2.awt.util.IResponseChainNode;
import ananas.lib.blueprint2.dom.IDocument;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.io.File;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JScrollBar;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.filechooser.FileFilter;

public class MainFrame
extends Bp2Ctrl
implements IMainFrame {
    private JFrame mFrame;
    private JTextField mStartTime;
    private JTextField mEndTime;
    private JTextField mSaveName;
    private JTextField mHighAlarm;
    private ColorCombo mHighAlarmColor;
    private JTextField mLowAlarm;
    private ColorCombo mLowAlarmColor;
    private JComboBox mFileList;
    private JTextField mAverage;
    private JTextField mSampleRate;
    private JTextField mDataNum;
    private JTextField mMaxValue;
    private JTextField mMinValue;
    private JLabel mCurTemper;
    private ColorCombo mLineBgColor;
    private ColorCombo mLineFgColor;
    private JScrollBar mLineScrollHorz;
    private JScrollBar mLineScrollVert;
    private LineView mLineView;
    private LineViewCorner mLineViewCorner;
    private TimeRuler mRulerHorz;
    private ValueRuler mRulerVert;
    private JTable mDataTable;
    private JComponent mPrintView;
    private JCheckBoxMenuItem mMenuItemViewCursor;
    private JCheckBoxMenuItem mMenuItemViewGridX;
    private JCheckBoxMenuItem mMenuItemViewGridY;
    final Awt_responseChainNode mRespChainHook = new Awt_responseChainNode(){

        @Override
        public boolean processEvent(ActionEvent e) {
            String cmd = e.getActionCommand();
            return MainFrame.this._processCommand(String.valueOf(cmd));
        }
    };
    private IDataCenter mDataCenter;
    private final JLabel mConnStatus;
    private JFileChooser mFileOpenDialog;
    private JFileChooser mFileSaveDialog;
    private JButton mToolConn;
    private JButton mToolDiscon;

    public MainFrame() {
        IDocument doc = this._loadXml();
        this.mStartTime = (JTextField)doc.findTargetById("start_time");
        this.mEndTime = (JTextField)doc.findTargetById("end_time");
        this.mSaveName = (JTextField)doc.findTargetById("save_name");
        this.mHighAlarm = (JTextField)doc.findTargetById("high_alarm");
        this.mLowAlarm = (JTextField)doc.findTargetById("low_alarm");
        this.mFileList = (JComboBox)doc.findTargetById("file_list");
        this.mAverage = (JTextField)doc.findTargetById("average");
        this.mDataNum = (JTextField)doc.findTargetById("data_no");
        this.mMaxValue = (JTextField)doc.findTargetById("max_value");
        this.mMinValue = (JTextField)doc.findTargetById("min_value");
        this.mCurTemper = (JLabel)doc.findTargetById("cur_temper");
        this.mLineBgColor = (ColorCombo)doc.findTargetById("line_bg_color");
        this.mLineFgColor = (ColorCombo)doc.findTargetById("line_fg_color");
        this.mLineView = (LineView)doc.findTargetById("line_view");
        this.mRulerHorz = (TimeRuler)doc.findTargetById("ruler_horz");
        this.mRulerVert = (ValueRuler)doc.findTargetById("ruler_vert");
        this.mDataTable = (JTable)doc.findTargetById("data_table");
        this.mSampleRate = (JTextField)doc.findTargetById("sample_rate");
        this.mPrintView = (JComponent)doc.findTargetById("the_print_view");
        this.mConnStatus = (JLabel)doc.findTargetById("connection_status");
        this.mToolConn = (JButton)doc.findTargetById("tool_connect");
        this.mToolDiscon = (JButton)doc.findTargetById("tool_disconnect");
        this.mLineScrollVert = (JScrollBar)doc.findTargetById("line_scroll_vert");
        this.mLineScrollHorz = (JScrollBar)doc.findTargetById("line_scroll_horz");
        this.mLineViewCorner = (LineViewCorner)doc.findTargetById("line_view_corner");
        this.mHighAlarmColor = (ColorCombo)doc.findTargetById("high_alarm_color");
        this.mLowAlarmColor = (ColorCombo)doc.findTargetById("low_alarm_color");
        ImageIcon icon = (ImageIcon)doc.findTargetById("app_icon");
        this.mFrame.setIconImage(icon.getImage());
    }

    private IDocument _loadXml() {
        IDocument doc = this.loadDocument("resource:///MainFrame.xml");
        this.mFrame = (JFrame)doc.findTargetById("root");
        this.mFrame.setDefaultCloseOperation(3);
        IResponseChainNode chainNode = (IResponseChainNode)doc.findTargetById("resp_chain_node_3");
        chainNode.setHook(this.mRespChainHook);
        this.mMenuItemViewCursor = (JCheckBoxMenuItem)doc.findTargetById("view_cursor_cross");
        this.mMenuItemViewGridX = (JCheckBoxMenuItem)doc.findTargetById("view_grid_x");
        this.mMenuItemViewGridY = (JCheckBoxMenuItem)doc.findTargetById("view_grid_y");
        return doc;
    }

    public boolean _processCommand(String cmd) {
        if (cmd == null) {
            return false;
        }
        if (cmd.equals("file_open")) {
            this._doFileOpen();
        } else if (cmd.equals("file_save")) {
            this._doFileSave();
        } else if (cmd.equals("file_save_as")) {
            this._doFileSaveAs();
        } else if (cmd.equals("file_print")) {
            this._doFilePrint();
        } else if (cmd.equals("file_exit")) {
            this._doFileExit();
        } else if (cmd.equals("view_zoom_cls")) {
            this._doZoomCls();
        } else if (cmd.equals("view_zoom_in")) {
            this._doZoomIn();
        } else if (cmd.equals("view_zoom_out")) {
            this._doZoomOut();
        } else if (cmd.equals("view_grid_x")) {
            this._doViewGridX();
        } else if (cmd.equals("view_grid_y")) {
            this._doViewGridY();
        } else if (cmd.equals("view_cursor_cross")) {
            this._doViewCursorCross();
        } else if (cmd.equals("view_change_unit")) {
            this._doViewChangeUnit();
        } else if (cmd.equals("ctrl_start")) {
            this._doStartRec();
        } else if (cmd.equals("ctrl_stop")) {
            this._doStopRec();
        } else if (cmd.equals("ctrl_connect")) {
            this._doConnect();
        } else if (cmd.equals("ctrl_disconnect")) {
            this._doDisconnect();
        } else if (cmd.equals("help_content")) {
            this._doHelpContent();
        } else if (cmd.equals("help_about")) {
            this._doHelpAbout();
        } else {
            return false;
        }
        return true;
    }

    private void _doHelpAbout() {
        IDocument doc = this.loadDocument("resource:///AboutDialog.xml");
        JDialog dlg = (JDialog)doc.findTargetById("root");
        dlg.setResizable(false);
        dlg.setModal(true);
        dlg.setVisible(true);
    }

    private void _doHelpContent() {
        IThermo the = this.mDataCenter.getThermo();
        the.openHelpContent();
    }

    private void _doViewChangeUnit() {
        IDataCenter dc = this.mDataCenter;
        TemperatureUnit unit = dc.getUnit();
        unit = unit == null ? TemperatureUnit.unit_c : (unit.equals(TemperatureUnit.unit_c) ? TemperatureUnit.unit_f : TemperatureUnit.unit_c);
        dc.setUnit(unit);
    }

    private void _doViewCursorCross() {
        IColorStyle cs;
        cs.setVisibleCursorCross(!(cs = this.mDataCenter.getColorStyle()).isVisibleCursorCross());
    }

    private void _doViewGridY() {
        IColorStyle cs;
        cs.setVisibleGridY(!(cs = this.mDataCenter.getColorStyle()).isVisibleGridY());
    }

    private void _doViewGridX() {
        IColorStyle cs;
        cs.setVisibleGridX(!(cs = this.mDataCenter.getColorStyle()).isVisibleGridX());
    }

    private void _doConnect() {
        this.mDataCenter.getThermo().start();
    }

    private void _doDisconnect() {
        this.mDataCenter.getThermo().stop();
    }

    public File getHomeDir() {
        String base = System.getProperty("user.home");
        return new File(base, "ir-thermo");
    }

    private void _doFilePrint() {
        JComponent comp = this.mPrintView;
        PrintFactory.getInstance().printJComponent(comp);
    }

    private void _doFileExit() {
        this.mDataCenter.onClose();
        System.exit(0);
    }

    private void _doFileSaveAs() {
    }

    private void _doFileSave() {
        IDataBuffer buff = this.mDataCenter.getCurrentBuffer();
        buff.save();
    }

    private void _doFileOpen() {
        int rlt;
        JFileChooser fc = this.mFileOpenDialog;
        if (fc == null) {
            fc = new JFileChooser();
            fc.setCurrentDirectory(this.getHomeDir());
            FileFilter ff = new FileFilter(){

                @Override
                public boolean accept(File file2) {
                    String s = file2.getName().toLowerCase();
                    if (file2.isDirectory()) {
                        return !s.contains(".irt.");
                    }
                    return s.endsWith(".irt");
                }

                @Override
                public String getDescription() {
                    return "*.irt";
                }
            };
            fc.setFileFilter(ff);
            this.mFileOpenDialog = fc;
        }
        if ((rlt = fc.showOpenDialog(this.mFrame)) != 0) {
            return;
        }
        File file2 = fc.getSelectedFile();
        System.out.println("open : " + file2);
        IDataCenter dc = this.getDataCenter();
        IMainDoc md = dc.newDoc(file2);
        md.setReadonly(true);
        if (!md.load()) {
            String msg = "cannot open the file \n " + file2;
            JOptionPane.showMessageDialog(this.mFrame, msg);
            return;
        }
        dc.setMainDoc(md);
    }

    private void _doZoomOut() {
        ILineModel model = this.getLineView().getModel();
        IValueBarModel vbar = model.getValueBar();
        ITimeBarModel tbar = model.getTimeBar();
        vbar.setScale(vbar.scale() * 0.5);
        tbar.setScale(tbar.scale() * 0.5);
        model.dispatchEvent(new ModelChangedEvent(model, 8));
    }

    private void _doZoomIn() {
        ILineModel model = this.getLineView().getModel();
        IValueBarModel vbar = model.getValueBar();
        ITimeBarModel tbar = model.getTimeBar();
        vbar.setScale(vbar.scale() * 2.0);
        tbar.setScale(tbar.scale() * 2.0);
        model.dispatchEvent(new ModelChangedEvent(model, 8));
    }

    private void _doZoomCls() {
        ILineModel model = this.getLineView().getModel();
        model.doAutoZoom();
        model.dispatchEvent(new ModelChangedEvent(model, 8));
    }

    private void _doStopRec() {
        IMainDoc md = this.mDataCenter.getMainDoc();
        if (md != null) {
            md.stop();
        }
    }

    private void _doStartRec() {
        StartRecDialogCtrl dlgctrl = new StartRecDialogCtrl();
        JDialog dlg = dlgctrl.getDialog();
        Rectangle bou1 = dlg.getBounds();
        Rectangle bou2 = this.mFrame.getBounds();
        dlg.setBounds(bou2.x + (bou2.width - bou1.width) / 2, bou2.y + (bou2.height - bou1.height) / 2, bou1.width, bou1.height);
        dlgctrl.doModel();
        StartRecDialogCtrl.Settings sett = dlgctrl.settings;
        if (!sett.isok) {
            return;
        }
        Timezone zone = Timezone.getLocalZone();
        Timestamp time = Timestamp.getTimestamp(System.currentTimeMillis());
        String timeStr = zone.format(time);
        File dir = this.getHomeDir();
        String filename = this._normalFilename("irth&" + timeStr + ".irt");
        File file0 = new File(dir, filename);
        file0.getParentFile().mkdirs();
        File file2 = null;
        do {
            JFileChooser fc;
            if ((fc = this.mFileSaveDialog) == null) {
                FileFilter ff = new FileFilter(){

                    @Override
                    public boolean accept(File f) {
                        String str = f.getName().toLowerCase();
                        if (f.isDirectory()) {
                            return true;
                        }
                        return str.endsWith(".irt");
                    }

                    @Override
                    public String getDescription() {
                        return "*.irt";
                    }
                };
                fc = new JFileChooser();
                fc.setFileFilter(ff);
                this.mFileSaveDialog = fc;
            }
            fc.setSelectedFile(file0);
            int rlt = fc.showSaveDialog(this.mFrame);
            if (rlt != 0) {
                return;
            }
            file2 = fc.getSelectedFile();
            if (!file2.exists()) continue;
            file2 = null;
            String msg = "The file is existed, please select another one.";
            JOptionPane.showMessageDialog(this.mFrame, msg);
        } while (file2 == null);
        System.out.println("save to : " + file2);
        IDataCenter dc = this.getDataCenter();
        IMainDoc md = dc.newDoc(file2);
        md.setReadonly(false);
        IDocSettings set2 = md.getSettings();
        set2.setHighAlarm(sett.highAlarm);
        set2.setLowAlarm(sett.lowAlarm);
        set2.setUnit(sett.unit);
        set2.setSampleRate(sett.sampleRate);
        dc.setMainDoc(md);
        md.start();
    }

    private String _normalFilename(String string) {
        char[] chs;
        StringBuilder sb = new StringBuilder();
        char[] cArray = chs = string.toCharArray();
        int n = chs.length;
        int n2 = 0;
        while (n2 < n) {
            int ch2;
            int ch = cArray[n2];
            switch (ch) {
                case 46: {
                    ch2 = 46;
                    break;
                }
                case 45: 
                case 58: {
                    ch2 = 45;
                    break;
                }
                default: {
                    ch2 = 48 <= ch && ch <= 57 ? ch : (97 <= ch && ch <= 122 ? ch : (65 <= ch && ch <= 90 ? ch : 95));
                }
            }
            sb.append((char)ch2);
            ++n2;
        }
        return sb.toString();
    }

    @Override
    public void show() {
        this.mFrame.setVisible(true);
    }

    @Override
    public void setDataCenter(IDataCenter dc) {
        this.mDataCenter = dc;
        dc.getEventDispatcher().addListener(new IEventListener(){

            @Override
            public void onEvent(IEvent event) {
            }
        });
        dc.getThermo().start();
    }

    @Override
    public IDataCenter getDataCenter() {
        return this.mDataCenter;
    }

    @Override
    public JLabel getCurrentTempe() {
        return this.mCurTemper;
    }

    @Override
    public JTable getDataTable() {
        return this.mDataTable;
    }

    @Override
    public JComboBox getSubList() {
        return this.mFileList;
    }

    @Override
    public LineView getLineView() {
        return this.mLineView;
    }

    @Override
    public ValueRuler getValueRuler() {
        return this.mRulerVert;
    }

    @Override
    public TimeRuler getTimeRuler() {
        return this.mRulerHorz;
    }

    @Override
    public LineViewCorner getLineViewCorner() {
        return this.mLineViewCorner;
    }

    @Override
    public JTextField getStartTime() {
        return this.mStartTime;
    }

    @Override
    public JTextField getEndTime() {
        return this.mEndTime;
    }

    @Override
    public JTextField getMinValue() {
        return this.mMinValue;
    }

    @Override
    public JTextField getDataNumber() {
        return this.mDataNum;
    }

    @Override
    public JTextField getAverage() {
        return this.mAverage;
    }

    @Override
    public JTextField getMaxValue() {
        return this.mMaxValue;
    }

    @Override
    public JTextField getMainFileName() {
        return this.mSaveName;
    }

    @Override
    public JTextField getLowAlarm() {
        return this.mLowAlarm;
    }

    @Override
    public JTextField getHighAlarm() {
        return this.mHighAlarm;
    }

    @Override
    public JTextField getSampleRate() {
        return this.mSampleRate;
    }

    @Override
    public ColorCombo getAlarmHighColor() {
        return this.mHighAlarmColor;
    }

    @Override
    public ColorCombo getAlarmLowColor() {
        return this.mLowAlarmColor;
    }

    @Override
    public ColorCombo getFgColor() {
        return this.mLineFgColor;
    }

    @Override
    public ColorCombo getBgColor() {
        return this.mLineBgColor;
    }

    @Override
    public JFrame getFrame() {
        return this.mFrame;
    }

    @Override
    public JScrollBar getLineScrollBarV() {
        return this.mLineScrollVert;
    }

    @Override
    public JScrollBar getLineScrollBarT() {
        return this.mLineScrollHorz;
    }

    @Override
    public JLabel getConnectionStatus() {
        return this.mConnStatus;
    }

    @Override
    public JButton getToolConnect() {
        return this.mToolConn;
    }

    @Override
    public JButton getToolDisconnect() {
        return this.mToolDiscon;
    }

    @Override
    public JCheckBoxMenuItem getMenuItemViewCross() {
        return this.mMenuItemViewCursor;
    }

    @Override
    public JCheckBoxMenuItem getMenuItemViewGridX() {
        return this.mMenuItemViewGridX;
    }

    @Override
    public JCheckBoxMenuItem getMenuItemViewGridY() {
        return this.mMenuItemViewGridY;
    }
}

