/*
 * Decompiled with CFR 0.152.
 */
package ananas.cust.app.ir_therm.gui;

import ananas.cust.app.ir_therm.core.DefaultDataCenter;
import ananas.cust.app.ir_therm.core.DefaultThermoResult;
import ananas.cust.app.ir_therm.core.IDataCenter;
import ananas.cust.app.ir_therm.core.IThermo;
import ananas.cust.app.ir_therm.core.SafeThermoFactory;
import ananas.cust.app.ir_therm.core.Temperature;
import ananas.cust.app.ir_therm.core.TemperatureUnit;
import ananas.cust.app.ir_therm.core.ThermoResult;
import ananas.cust.app.ir_therm.event.IEvent;
import ananas.cust.app.ir_therm.event.IEventListener;
import ananas.cust.app.ir_therm.event.ModelChangedEvent;
import ananas.cust.app.ir_therm.event.ThermoResultEvent;
import ananas.cust.app.ir_therm.gui.IMainFrame;
import ananas.cust.app.ir_therm.gui.InfoCtrl;
import ananas.cust.app.ir_therm.gui.MainFrame;
import ananas.cust.app.ir_therm.gui.SettingsCtrl;
import ananas.cust.app.ir_therm.gui.TheLineCtrl;
import ananas.cust.app.ir_therm.gui.TheTableModel;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import javax.swing.JFrame;
import javax.swing.JTable;

public class MainCtrl {
    private final IMainFrame mFrame;
    private InfoCtrl mInfoCtrl;
    private SettingsCtrl mSettingsCtrl;

    public MainCtrl() {
        MainFrame mf = new MainFrame();
        DefaultDataCenter dc = new DefaultDataCenter();
        mf.setDataCenter(dc);
        this.mFrame = mf;
        this._listenDataCenter(dc);
        this._listenFrame(this.mFrame.getFrame());
        this._initThermo();
        this._initLineView();
        this._initTable();
        this.mInfoCtrl = new InfoCtrl(mf);
        this.mSettingsCtrl = new SettingsCtrl(mf);
        dc.loadAppSettings();
    }

    private void _listenFrame(JFrame frame) {
        frame.addWindowListener(new WindowListener(){

            @Override
            public void windowActivated(WindowEvent arg0) {
                this._printEvent(arg0);
            }

            private void _printEvent(WindowEvent arg0) {
            }

            @Override
            public void windowClosed(WindowEvent arg0) {
                this._printEvent(arg0);
            }

            @Override
            public void windowClosing(WindowEvent arg0) {
                this._printEvent(arg0);
                MainCtrl.this._onFrameClosing();
            }

            @Override
            public void windowDeactivated(WindowEvent arg0) {
                this._printEvent(arg0);
            }

            @Override
            public void windowDeiconified(WindowEvent arg0) {
                this._printEvent(arg0);
            }

            @Override
            public void windowIconified(WindowEvent arg0) {
                this._printEvent(arg0);
            }

            @Override
            public void windowOpened(WindowEvent arg0) {
                this._printEvent(arg0);
            }
        });
        if (SafeThermoFactory.isEval()) {
            String title = frame.getTitle();
            frame.setTitle(String.valueOf(title) + " (Evaluate Version)");
        }
    }

    protected void _onFrameClosing() {
        IDataCenter dc = this.mFrame.getDataCenter();
        dc.onClose();
    }

    private void _initTable() {
        IDataCenter dc = this.mFrame.getDataCenter();
        JTable table = this.mFrame.getDataTable();
        TheTableModel model = new TheTableModel(dc);
        table.setModel(model);
    }

    private void _initLineView() {
        TheLineCtrl ctrl = new TheLineCtrl(this.mFrame);
    }

    private void _listenDataCenter(IDataCenter dc) {
        dc.getEventDispatcher().addListener(new IEventListener(){

            @Override
            public void onEvent(IEvent event) {
                if (event instanceof ModelChangedEvent) {
                    ModelChangedEvent modelChangedEvent = (ModelChangedEvent)event;
                }
            }
        });
    }

    private void _initThermo() {
        IThermo thermo = this.mFrame.getDataCenter().getThermo();
        this.mFrame.getDataCenter().getEventDispatcher().addListener(new IEventListener(){

            @Override
            public void onEvent(IEvent event) {
                if (event instanceof ThermoResultEvent) {
                    ThermoResultEvent tre = (ThermoResultEvent)event;
                    MainCtrl.this._updateInfo(tre.result);
                } else if (event instanceof ModelChangedEvent) {
                    MainCtrl.this._updateInfo(null);
                }
            }
        });
        thermo.start();
    }

    private void _updateInfo(ThermoResult result) {
        if (result == null) {
            result = new DefaultThermoResult();
        }
        IDataCenter dc = this.mFrame.getDataCenter();
        ThermoResult rlt = dc.getThermo().getCurrentResult();
        TemperatureUnit unit = dc.getUnit();
        Temperature temp = rlt.getTemperature();
        String str = unit.convert(temp).toString();
        if (temp.getValue() < -10000.0) {
            str = "---";
        }
        this.mFrame.getCurrentTempe().setText(str);
    }

    public IMainFrame getFrame() {
        return this.mFrame;
    }

    class MyEventReporter
    implements IEventListener {
        private int mCount;

        MyEventReporter() {
        }

        @Override
        public void onEvent(IEvent event) {
            System.out.println("onEvent(" + this.mCount++ + "):" + event);
        }
    }
}

