/*
 * Decompiled with CFR 0.152.
 */
package ananas.cust.app.ir_therm.gui;

import ananas.cust.app.ir_therm.core.IDataBuffer;
import ananas.cust.app.ir_therm.core.IDataCenter;
import ananas.cust.app.ir_therm.core.Temperature;
import ananas.cust.app.ir_therm.core.TemperatureUnit;
import ananas.cust.app.ir_therm.core.ThermoResult;
import ananas.cust.app.ir_therm.core.Timestamp;
import ananas.cust.app.ir_therm.core.Timezone;
import ananas.cust.app.ir_therm.event.IEvent;
import ananas.cust.app.ir_therm.event.IEventListener;
import ananas.cust.app.ir_therm.event.ModelChangedEvent;
import ananas.cust.app.ir_therm.event.ThermoStatusEvent;
import ananas.cust.app.ir_therm.gui.IMainFrame;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JTextField;

public class InfoCtrl {
    private final IMainFrame mFrame;
    private final JTextField mStartTime;
    private final JTextField mAverage;
    private final JTextField mMinValue;
    private final JTextField mEndTime;
    private final JTextField mDataNumber;
    private final JTextField mMaxValue;
    private final JLabel mConnStatus;
    private final JButton mToolDiscon;
    private final JButton mToolConn;

    public InfoCtrl(IMainFrame frame) {
        this.mFrame = frame;
        this._listen(frame.getDataCenter());
        this.mEndTime = frame.getEndTime();
        this.mAverage = frame.getAverage();
        this.mMinValue = frame.getMinValue();
        this.mMaxValue = frame.getMaxValue();
        this.mStartTime = frame.getStartTime();
        this.mDataNumber = frame.getDataNumber();
        this.mConnStatus = frame.getConnectionStatus();
        this.mToolConn = frame.getToolConnect();
        this.mToolDiscon = frame.getToolDisconnect();
    }

    private void _listen(IDataCenter dc) {
        dc.getEventDispatcher().addListener(new IEventListener(){

            @Override
            public void onEvent(IEvent event) {
                if (event != null) {
                    if (event instanceof ModelChangedEvent) {
                        ModelChangedEvent e = (ModelChangedEvent)event;
                        if ((e.mask & 2) != 0) {
                            InfoCtrl.this._doUpdate();
                        }
                    } else if (event instanceof ThermoStatusEvent) {
                        ThermoStatusEvent e = (ThermoStatusEvent)event;
                        InfoCtrl.this._setConnStatus(e.status);
                    }
                }
            }
        });
    }

    protected void _setConnStatus(ThermoStatusEvent.Status status) {
        this.mConnStatus.setText("Connection : " + status);
        if (status.equals(ThermoStatusEvent.status_disconnected)) {
            this.mToolConn.setEnabled(true);
            this.mToolDiscon.setEnabled(false);
        } else {
            this.mToolConn.setEnabled(false);
            this.mToolDiscon.setEnabled(true);
        }
    }

    protected void _doUpdate() {
        IDataCenter dc = this.mFrame.getDataCenter();
        TemperatureUnit unit = dc.getUnit();
        Timezone zone = dc.getTimezone();
        Timestamp timeStart = null;
        Timestamp timeEnd = null;
        Temperature average = null;
        ThermoResult max = null;
        ThermoResult min = null;
        int count = 0;
        IDataBuffer buff = dc.getCurrentBuffer();
        if (buff != null) {
            timeStart = buff.startTime();
            timeEnd = buff.endTime();
            average = buff.average();
            max = buff.max();
            min = buff.min();
            count = buff.count();
        }
        this.mDataNumber.setText(String.valueOf(count));
        if (max == null) {
            this.mMaxValue.setText(" - ");
        } else {
            this.mMaxValue.setText(this.resultTimeValueToString(max, unit));
        }
        if (min == null) {
            this.mMinValue.setText(" - ");
        } else {
            this.mMinValue.setText(this.resultTimeValueToString(min, unit));
        }
        if (average == null) {
            this.mAverage.setText(" - ");
        } else {
            this.mAverage.setText(unit.convert(average).toString());
        }
        if (timeStart == null) {
            this.mStartTime.setText(" - ");
        } else {
            this.mStartTime.setText(zone.format(timeStart));
        }
        if (timeEnd == null) {
            this.mEndTime.setText(" - ");
        } else {
            this.mEndTime.setText(zone.format(timeEnd));
        }
    }

    private String resultTimeValueToString(ThermoResult result, TemperatureUnit unit) {
        String str1 = unit.convert(result.getTemperature()).toString();
        String str2 = Timezone.getLocalZone().format(result.getTimestamp());
        return String.valueOf(str1) + "    " + str2;
    }
}

