/*
 * Decompiled with CFR 0.152.
 */
package ananas.cust.app.ir_therm.driver;

import ananas.cust.app.ir_therm.driver.IrtbResult;

public class IrtbResultParser {
    public static final IrtbResult null_data = new IrtbResult(301, "");
    private byte[] mBytesBuffer;

    public IrtbResult parse(String str) {
        if (str == null) {
            return null_data;
        }
        if (!str.startsWith("$")) {
            return null_data;
        }
        if (str.startsWith("$DATA-RX:")) {
            return this._parseData(str);
        }
        if (str.startsWith("$INFO:")) {
            return this._parseInfo(str);
        }
        if (str.startsWith("$ERROR:")) {
            return this._parseError(str);
        }
        return null_data;
    }

    private IrtbResult _parseInfo(String str) {
        String msg = str;
        int i = str.indexOf(58);
        if (i > 0) {
            msg = str.substring(i + 1);
        }
        IrtbResult rlt = new IrtbResult(300, msg);
        return rlt;
    }

    private IrtbResult _parseData(String str) {
        byte[] buff = this._getDataBytes(str.toCharArray());
        if (buff == null) {
            return null;
        }
        int b3 = 0;
        int b2 = 0;
        int b1 = 0;
        int b0 = 0;
        byte[] byArray = buff;
        int n = buff.length;
        int n2 = 0;
        while (n2 < n) {
            byte b = byArray[n2];
            b0 = b1;
            b1 = b2;
            b2 = b3;
            b3 = b & 0xFF;
            if ((b0 & 0xF0) == 128 && (b1 & 0xF0) == 144 && (b2 & 0xF0) == 160 && (b3 & 0xF0) == 176) {
                int n3 = 0;
                n3 |= b0 << 12 & 0xF000;
                n3 |= b1 << 8 & 0xF00;
                n3 |= b2 << 4 & 0xF0;
                short sn = (short)(n3 |= b3 << 0 & 0xF);
                n3 = sn;
                double dn = (double)n3 / 10.0;
                IrtbResult rlt = new IrtbResult(200, "");
                rlt.temper_c = dn;
                return rlt;
            }
            ++n2;
        }
        return null_data;
    }

    private byte[] _getDataBytes(char[] charArray) {
        byte[] buff = this.mBytesBuffer;
        if (buff == null) {
            this.mBytesBuffer = buff = new byte[32];
        }
        int d1 = 0;
        int d0 = 0;
        int digiIndex = 0;
        int cb = 0;
        boolean started = false;
        char[] cArray = charArray;
        int n = charArray.length;
        int n2 = 0;
        while (n2 < n) {
            char ch = cArray[n2];
            if (!started) {
                if (ch == ',') {
                    started = true;
                }
            } else {
                int digi = '0' <= ch && ch <= '9' ? ch - 48 : ('a' <= ch && ch <= 'f' ? ch - 97 + 10 : ('A' <= ch && ch <= 'F' ? ch - 65 + 10 : -1));
                if (digi < 0) {
                    if (digiIndex > 0 && cb < buff.length) {
                        int b = d0 << 4 & 0xF0 | d1 & 0xF;
                        buff[cb++] = (byte)b;
                    }
                    digiIndex = 0;
                    d1 = 0;
                    d0 = 0;
                } else {
                    switch (digiIndex) {
                        case 0: {
                            d0 = digi;
                            break;
                        }
                        case 1: {
                            d1 = digi;
                        }
                    }
                    ++digiIndex;
                }
            }
            ++n2;
        }
        return buff;
    }

    private IrtbResult _parseError(String str) {
        String msg = str;
        int i = str.indexOf(58);
        if (i > 0) {
            msg = str.substring(i + 1);
        }
        IrtbResult rlt = new IrtbResult(400, msg);
        return rlt;
    }
}

