/*
 * Decompiled with CFR 0.152.
 */
package ananas.cust.app.ir_therm.driver;

import ananas.cust.app.ir_therm.driver.IrtbResult;
import ananas.cust.app.ir_therm.driver.IrtbResultParser;
import java.io.IOException;
import java.io.InputStream;

public class IrtbReader {
    private final InputStream mIS;
    private final StringBuilder mStrBuf = new StringBuilder();
    private MyInputStreamReader mReader;
    private IrtbResultParser mParser;

    public IrtbReader(InputStream is) {
        this.mIS = is;
    }

    public IrtbResult read() throws IOException {
        StringBuilder sb = this.mStrBuf;
        MyInputStreamReader rdr = this._getReader();
        int ch;
        while ((ch = rdr.read()) >= 0) {
            if (ch == 0) {
                this._safe_sleep(100);
            } else {
                if (ch == 13 || ch == 10) {
                    String str = sb.toString();
                    sb.setLength(0);
                    IrtbResultParser parser = this._getParser();
                    IrtbResult rlt = parser.parse(str);
                    return rlt;
                }
                sb.append((char)ch);
            }
            if (sb.length() <= 256) continue;
            sb.setLength(256);
        }
        return null;
    }

    private void _safe_sleep(int ms) {
        try {
            Thread.sleep(ms);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    private IrtbResultParser _getParser() {
        IrtbResultParser irp = this.mParser;
        if (irp == null) {
            this.mParser = irp = new IrtbResultParser();
        }
        return irp;
    }

    private MyInputStreamReader _getReader() {
        MyInputStreamReader rdr = this.mReader;
        if (rdr == null) {
            this.mReader = rdr = new MyInputStreamReader(this.mIS);
        }
        return rdr;
    }

    static class MyInputStreamReader {
        private final InputStream mIS;

        public MyInputStreamReader(InputStream is) {
            this.mIS = is;
        }

        public int read() throws IOException {
            return this.mIS.read();
        }
    }
}

