/*
 * Decompiled with CFR 0.152.
 */
package ananas.cust.app.ir_therm.driver;

import ananas.cust.app.ir_therm.Irth;
import ananas.cust.app.ir_therm.driver.IrtbConnection;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Properties;

public class IrtbDriver {
    public IrtbConnection openConnection() throws IOException {
        MyIrtbConn conn = new MyIrtbConn();
        conn._conn();
        return conn;
    }

    private class MyIrtbConn
    implements IrtbConnection {
        private InputStream mIS;
        private Process mProc;
        private InputStream mErrS;

        private MyIrtbConn() {
        }

        @Override
        public InputStream getInputStream() {
            return this.mIS;
        }

        public void _conn() throws IOException {
            Process proc;
            Runtime rtime = Runtime.getRuntime();
            String[] envp = null;
            File dir = this._getWorkingDir();
            String command2 = this._loadCmd(dir, "irtb.ini");
            System.out.println("Working-Dir=" + dir);
            System.out.println("Command=" + command2);
            this.mProc = proc = rtime.exec(command2, envp, dir);
            this.mIS = proc.getInputStream();
            this.mErrS = proc.getErrorStream();
            MyStreamPump pump = new MyStreamPump(this.mErrS, System.err);
            new Thread(pump).start();
        }

        private String _loadCmd(File dir, String filename) throws IOException {
            File file2 = new File(dir, filename);
            FileInputStream is = new FileInputStream(file2);
            Properties prop = new Properties();
            prop.load(is);
            is.close();
            String cmd = prop.getProperty("command");
            File cmdfile = new File(dir, cmd);
            return cmdfile.getAbsolutePath();
        }

        private File _getWorkingDir() {
            return Irth.getWorkingDirectory();
        }

        @Override
        public void close() {
            try {
                this.mIS.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            try {
                this.mProc.destroy();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    class MyStreamPump
    implements Runnable {
        private final InputStream mIS;
        private final OutputStream mOS;

        public MyStreamPump(InputStream is, OutputStream os) {
            this.mIS = is;
            this.mOS = os;
        }

        @Override
        public void run() {
            try {
                int cb;
                byte[] buf = new byte[128];
                InputStream is = this.mIS;
                OutputStream os = this.mOS;
                while ((cb = is.read(buf)) > 0) {
                    os.write(buf, 0, cb);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

