/*
 * Decompiled with CFR 0.152.
 */
package ananas.cust.app.ir_therm.core;

import ananas.cust.app.ir_therm.Irth;
import ananas.cust.app.ir_therm.core.DefaultThermoResult;
import ananas.cust.app.ir_therm.core.IContext;
import ananas.cust.app.ir_therm.core.IThermo;
import ananas.cust.app.ir_therm.core.IThermoFactory;
import ananas.cust.app.ir_therm.core.SampleRate;
import ananas.cust.app.ir_therm.core.TemperatureC;
import ananas.cust.app.ir_therm.core.ThermoResult;
import ananas.cust.app.ir_therm.core.Timestamp;
import ananas.cust.app.ir_therm.event.IEventDispatcher2;
import ananas.cust.app.ir_therm.event.ThermoResultEvent;
import ananas.cust.app.ir_therm.event.ThermoStatusEvent;
import java.io.File;
import java.io.IOException;

public class VirtualThermoFactory
implements IThermoFactory {
    @Override
    public IThermo newThermo(IContext context) {
        return new MyThermo(context);
    }

    private static class MyThermo
    implements IThermo {
        private Runnable mRunn;
        private ThermoResult mCurResult;
        private SampleRate mRate = new SampleRate(500);
        private final IEventDispatcher2 mEvtDisp;

        public MyThermo(IContext context) {
            this.mEvtDisp = context.getEventDispatcher();
        }

        @Override
        public void start() {
            MyThermoRunn runn = new MyThermoRunn(this);
            this.mRunn = runn;
            new Thread(runn).start();
        }

        @Override
        public void restart() {
            this.start();
        }

        @Override
        public void stop() {
            this.mRunn = null;
        }

        @Override
        public ThermoResult getCurrentResult() {
            return this.mCurResult;
        }

        @Override
        public void setSampleRate(SampleRate rate) {
        }

        @Override
        public void openHelpContent() {
            File index = new File(Irth.getWorkingDirectory(), "help/index.html");
            try {
                String cmd = "firefox " + index.getAbsolutePath();
                System.out.println("exec : " + cmd);
                Runtime.getRuntime().exec(cmd);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private static class MyThermoRunn
    implements Runnable {
        private final MyThermo mCore;
        private int mIndexCount;

        public MyThermoRunn(MyThermo core) {
            this.mCore = core;
        }

        @Override
        public void run() {
            this._dispStatusEvent(ThermoStatusEvent.status_connected);
            long last = 0L;
            while (this.equals(this.mCore.mRunn)) {
                long now;
                int rate = this.mCore.mRate.getValue();
                if ((long)rate <= (now = System.currentTimeMillis()) - last) {
                    this._dispEvent(now);
                    last = now;
                }
                this._safe_sleep(200);
            }
            this._dispStatusEvent(ThermoStatusEvent.status_disconnected);
        }

        private void _dispStatusEvent(ThermoStatusEvent.Status status) {
            try {
                ThermoStatusEvent event = new ThermoStatusEvent(this, status);
                this.mCore.mEvtDisp.dispatchEvent(event);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        private void _dispEvent(long now) {
            try {
                double val = (double)(now * 2L) * Math.PI / 60000.0;
                val = Math.sin(val) * 600.0 - 500.0;
                int index = this.mIndexCount++;
                Timestamp time = new Timestamp(now);
                TemperatureC temper = new TemperatureC(val);
                DefaultThermoResult rlt = new DefaultThermoResult(index, time, temper);
                this.mCore.mCurResult = rlt;
                ThermoResultEvent event = new ThermoResultEvent(this, rlt);
                this.mCore.mEvtDisp.dispatchEvent(event);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        private void _safe_sleep(int ms) {
            try {
                Thread.sleep(ms);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }
}

